/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.ens;

import org.web3j.ens.EnsResolutionException;

public class Contracts {
    public static final String MAINNET = "0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e";
    public static final String ROPSTEN = "0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e";
    public static final String RINKEBY = "0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e";
    public static final String GOERLI = "0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e";
    public static final String SEPOLIA = "0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e";
    public static final String HOLESKY = "0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e";
    public static final String LINEA = "0x50130b669B28C339991d8676FA73CF122a121267";
    public static final String LINEA_SEPOLIA = "0x5B2636F0f2137B4aE722C01dd5122D7d3e9541f7";

    private Contracts() {
    }

    public static String resolveRegistryContract(String chainId) {
        Long chainIdLong = Long.parseLong(chainId);
        if (chainIdLong.equals(1L)) {
            return "0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e";
        }
        if (chainIdLong.equals(3L)) {
            return "0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e";
        }
        if (chainIdLong.equals(4L)) {
            return "0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e";
        }
        if (chainIdLong.equals(5L)) {
            return "0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e";
        }
        if (chainIdLong.equals(11155111L)) {
            return "0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e";
        }
        if (chainIdLong.equals(17000L)) {
            return "0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e";
        }
        if (chainIdLong.equals(59144L)) {
            return LINEA;
        }
        if (chainIdLong.equals(59141L)) {
            return LINEA_SEPOLIA;
        }
        throw new EnsResolutionException("Unable to resolve ENS registry contract for network id: " + chainId);
    }
}

