/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi;

import java.util.List;
import java.util.stream.Collectors;
import org.web3j.abi.TypeReference;
import org.web3j.abi.Utils;
import org.web3j.abi.datatypes.CustomError;
import org.web3j.abi.datatypes.Type;
import org.web3j.crypto.Hash;
import org.web3j.utils.Numeric;

public class CustomErrorEncoder {
    private CustomErrorEncoder() {
    }

    public static String encode(CustomError error) {
        return CustomErrorEncoder.calculateSignatureHash(CustomErrorEncoder.buildErrorSignature(error.getName(), error.getParameters()));
    }

    static <T extends Type> String buildErrorSignature(String errorName, List<TypeReference<T>> parameters) {
        StringBuilder result = new StringBuilder();
        result.append(errorName);
        result.append("(");
        String params = parameters.stream().map(Utils::getTypeName).collect(Collectors.joining(","));
        result.append(params);
        result.append(")");
        return result.toString();
    }

    public static String calculateSignatureHash(String errorSignature) {
        byte[] input = errorSignature.getBytes();
        byte[] hash = Hash.sha3((byte[])input);
        return Numeric.toHexString((byte[])hash);
    }
}

