/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.web3j.abi.TypeMappingException;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.Fixed;
import org.web3j.abi.datatypes.Int;
import org.web3j.abi.datatypes.StaticArray;
import org.web3j.abi.datatypes.StaticStruct;
import org.web3j.abi.datatypes.StructType;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Ufixed;
import org.web3j.abi.datatypes.Uint;
import org.web3j.abi.datatypes.Utf8String;

public class Utils {
    private Utils() {
    }

    static <T extends Type> String getTypeName(TypeReference<T> typeReference) {
        try {
            java.lang.reflect.Type reflectedType = typeReference.getType();
            if (reflectedType instanceof ParameterizedType) {
                Class type = (Class)((ParameterizedType)reflectedType).getRawType();
                return Utils.getParameterizedTypeName(typeReference, type);
            }
            Class<?> type = Class.forName(reflectedType.getTypeName());
            return Utils.getSimpleTypeName(type);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    static String getSimpleTypeName(Class<?> type) {
        String simpleName = type.getSimpleName().toLowerCase();
        if (type.equals(Uint.class) || type.equals(Int.class) || type.equals(Ufixed.class) || type.equals(Fixed.class)) {
            return simpleName + "256";
        }
        if (type.equals(Utf8String.class)) {
            return "string";
        }
        if (type.equals(DynamicBytes.class)) {
            return "bytes";
        }
        if (StructType.class.isAssignableFrom(type)) {
            return type.getName();
        }
        return simpleName;
    }

    static <T extends Type, U extends Type> String getParameterizedTypeName(TypeReference<T> typeReference, Class<?> type) {
        try {
            if (type.equals(DynamicArray.class)) {
                Class<T> parameterizedType = Utils.getParameterizedTypeFromArray(typeReference);
                String parameterizedTypeName = Utils.getSimpleTypeName(parameterizedType);
                return parameterizedTypeName + "[]";
            }
            if (type.equals(StaticArray.class)) {
                Class<T> parameterizedType = Utils.getParameterizedTypeFromArray(typeReference);
                String parameterizedTypeName = Utils.getSimpleTypeName(parameterizedType);
                return parameterizedTypeName + "[" + ((TypeReference.StaticArrayTypeReference)typeReference).getSize() + "]";
            }
            throw new UnsupportedOperationException("Invalid type provided " + type.getName());
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    static <T extends Type> Class<T> getParameterizedTypeFromArray(TypeReference typeReference) throws ClassNotFoundException {
        java.lang.reflect.Type type = typeReference.getType();
        java.lang.reflect.Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
        String parameterizedTypeName = typeArguments[0].getTypeName();
        return Class.forName(parameterizedTypeName);
    }

    public static List<TypeReference<Type>> convert(List<TypeReference<?>> input) {
        ArrayList<TypeReference<Type>> result = new ArrayList<TypeReference<Type>>(input.size());
        result.addAll(input.stream().map(typeReference -> typeReference).collect(Collectors.toList()));
        return result;
    }

    public static <T, R extends Type<T>, E extends Type<T>> List<E> typeMap(List<List<T>> input, Class<E> outerDestType, Class<R> innerType) {
        ArrayList<Type> result = new ArrayList<Type>();
        try {
            Constructor<E> constructor = outerDestType.getDeclaredConstructor(Class.class, List.class);
            for (List<T> ts : input) {
                Type e = (Type)constructor.newInstance(innerType, Utils.typeMap(ts, innerType));
                result.add(e);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TypeMappingException(e);
        }
        return result;
    }

    public static <T, R extends Type<T>> List<R> typeMap(List<T> input, Class<R> destType) throws TypeMappingException {
        ArrayList<R> result = new ArrayList<R>(input.size());
        if (!input.isEmpty()) {
            try {
                Constructor<R> constructor = destType.getDeclaredConstructor(input.get(0).getClass());
                for (T value : input) {
                    result.add(constructor.newInstance(value));
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new TypeMappingException(e);
            }
        }
        return result;
    }

    public static List<Field> staticStructNestedPublicFieldsFlatList(Class<Type> classType) {
        return Utils.staticStructsNestedFieldsFlatList(classType).stream().filter(field -> Modifier.isPublic(field.getModifiers())).collect(Collectors.toList());
    }

    public static List<Field> staticStructsNestedFieldsFlatList(Class<Type> classType) {
        List canonicalFields = Arrays.stream(classType.getDeclaredFields()).filter(field -> !StaticStruct.class.isAssignableFrom(field.getType())).collect(Collectors.toList());
        List nestedFields = Arrays.stream(classType.getDeclaredFields()).filter(field -> StaticStruct.class.isAssignableFrom(field.getType())).map(field -> Utils.staticStructsNestedFieldsFlatList(field.getType())).flatMap(Collection::stream).collect(Collectors.toList());
        return Stream.concat(canonicalFields.stream(), nestedFields.stream()).collect(Collectors.toList());
    }
}

