/*
 * Decompiled with CFR 0.152.
 */
package org.scalastyle.util;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.scalastyle.BuildInfo$;
import org.scalastyle.DefinitionChecker;
import org.scalastyle.DefinitionParameter;
import org.scalastyle.ScalastyleDefinition;
import org.scalastyle.ScalastyleDefinition$;
import org.scalastyle.XmlPrettyPrinter;
import org.scalastyle.util.CreateRulesMarkdown;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.PrettyPrinter;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;
import scala.xml.XML$;

public final class CreateRulesMarkdown$ {
    public static CreateRulesMarkdown$ MODULE$;
    private final String docFile;
    private final String defnFile;

    static {
        new CreateRulesMarkdown$();
    }

    private void usage(String version) {
        Predef$.MODULE$.println((Object)("scalastyle " + version));
        Predef$.MODULE$.println((Object)"Usage: CreateRulesMarkdown <output file>");
        System.exit(1);
    }

    private String docFile() {
        return this.docFile;
    }

    private String defnFile() {
        return this.defnFile;
    }

    private Option<String> toText(NodeSeq elem) {
        return elem.isEmpty() ? None$.MODULE$ : new Some((Object)elem.text().trim());
    }

    private scala.collection.immutable.Seq<String> toList(NodeSeq elem) {
        return (scala.collection.immutable.Seq)elem.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.text().trim(), Seq$.MODULE$.canBuildFrom());
    }

    private Elem toXml(String description, String s) {
        Elem elem;
        try {
            elem = (Elem)XML$.MODULE$.loadString(s);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(description + " for " + s, e);
        }
        return elem;
    }

    private List<String> withTitle(Option<String> os, String title) {
        Nil$ nil$;
        Option<String> option = os;
        if (option instanceof Some) {
            Some some = (Some)option;
            String x = (String)some.value();
            nil$ = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"#### " + title, x, ""}));
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    private String id(String s) {
        return s.replaceAll("\\.", "_");
    }

    private List<String> contents(List<DefinitionChecker> checkers, Config config) {
        List cs = (List)checkers.map((Function1 & Serializable & scala.Serializable)c -> {
            String desc = config.getString(c.id() + ".description").replaceAll("''\\[''", "'\\\\['");
            return "|[" + c.className() + "](#" + this.id(c.className()) + ")|" + desc + "|";
        }, List$.MODULE$.canBuildFrom());
        List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| Checker | Description |", "| ------------- | ------------- |"}));
        List list2 = cs;
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""})).$colon$colon$colon(list2).$colon$colon$colon(list);
    }

    private List<String> checker(DefinitionChecker c, CreateRulesMarkdown.Documentation doc, Config config) {
        List list;
        String desc = config.getString(c.id() + ".description").replaceAll("''\\[''", "'\\\\['");
        List header = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<a name=\"", "\" />"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.id(c.className())})), "", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"### ", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.className(), desc})), "", " * id - " + c.id(), " * description - " + desc, " * class - " + c.className(), " * default level - " + c.level(), ""}));
        List<String> justifcation = this.withTitle(doc.justification(), "Justification");
        List<String> description = this.withTitle(doc.extraDescription(), "Description");
        List parametersTitle = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"#### Parameters"}));
        if (c.parameters().isEmpty()) {
            list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No parameters"}));
        } else {
            List headers = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parameter", "Description", "Type", "Default Value"})).map((Function1 & Serializable & scala.Serializable)s -> {
                void var1_1;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus(s);
                return new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var1_1);
            }, List$.MODULE$.canBuildFrom());
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)headers);
            Elem header2 = new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            Iterable f = (Iterable)c.parameters().map((Function1 & Serializable & scala.Serializable)p -> {
                void var3_3;
                NodeBuffer $buf = new NodeBuffer();
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)((DefinitionParameter)p._2()).name());
                $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
                $buf.$amp$plus((Object)new Text("\n        "));
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)config.getString(c.id() + "." + ((DefinitionParameter)p._2()).name() + ".label"));
                $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
                $buf.$amp$plus((Object)new Text("\n        "));
                NodeBuffer $buf4 = new NodeBuffer();
                $buf4.$amp$plus((Object)((DefinitionParameter)p._2()).typeName().name());
                $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
                $buf.$amp$plus((Object)new Text("\n        "));
                NodeBuffer $buf5 = new NodeBuffer();
                $buf5.$amp$plus((Object)((DefinitionParameter)p._2()).defaultValue());
                $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
                $buf.$amp$plus((Object)new Text("\n      "));
                return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
            }, Iterable$.MODULE$.canBuildFrom());
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("width", (Seq)new Text("80%"), (MetaData)$md);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)header2);
            $buf2.$amp$plus((Object)f);
            Elem x2 = new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2);
            list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x2.toString()}));
        }
        List parameters = list;
        Seq s2 = (Seq)doc.example().map((Function1 & Serializable & scala.Serializable)x -> {
            PrettyPrinter qual$1 = new PrettyPrinter(1000, 1);
            Elem x$11 = this.toXml(this.docFile() + ":" + c.id(), (String)x);
            NamespaceBinding x$12 = qual$1.format$default$2();
            return qual$1.format((Node)x$11, x$12);
        }, scala.collection.Seq$.MODULE$.canBuildFrom());
        Seq x3 = (Seq)((TraversableLike)s2.map((Function1 & Serializable & scala.Serializable)t -> {
            void var1_1;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus(t);
            return new Elem(null, "pre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var1_1);
        }, scala.collection.Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> {
            XmlPrettyPrinter qual$2 = new XmlPrettyPrinter(1000, 1);
            Elem x$13 = x;
            NamespaceBinding x$14 = qual$2.format$default$2();
            return qual$2.format((Node)x$13, x$14);
        }, scala.collection.Seq$.MODULE$.canBuildFrom());
        String x2 = x3.isEmpty() ? "TBD" : x3.mkString("\nor\n");
        List example = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "### Example configuration", x2}));
        List list2 = header;
        List<String> list3 = justifcation;
        List<String> list4 = description;
        List list5 = parametersTitle;
        List list6 = parameters;
        return example.$colon$colon$colon(list6).$colon$colon$colon(list5).$colon$colon$colon(list4).$colon$colon$colon(list3).$colon$colon$colon(list2);
    }

    public Seq<String> generate() {
        InputStream sdefStream = this.getClass().getClassLoader().getResourceAsStream(this.defnFile());
        InputStream sdocStream = this.getClass().getClassLoader().getResourceAsStream(this.docFile());
        ScalastyleDefinition scalastyleDefinition = ScalastyleDefinition$.MODULE$.readFromXml(sdefStream);
        Config config = ConfigFactory.load();
        Map scalastyleDocumentation = ((TraversableOnce)XML$.MODULE$.load(sdocStream).$bslash$bslash("check").map((Function1 & Serializable & scala.Serializable)ns -> new Tuple2((Object)NodeSeq$.MODULE$.seqToNodeSeq((Seq)ns.attribute("id").get()).text(), (Object)new CreateRulesMarkdown.Documentation(this.toText(ns.$bslash$bslash("justification")), this.toText(ns.$bslash$bslash("extra-description")), (Seq<String>)this.toList(ns.$bslash$bslash("example-configuration")))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        List fileHeader = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"---", "layout: scalastyle", "title: \"Scalastyle: Implemented Rules\"", "---", "", "There are " + scalastyleDefinition.checkers().size() + " rules which are currently implemented:", ""}));
        List checkers = (List)scalastyleDefinition.checkers().sortWith((Function2 & Serializable & scala.Serializable)(e1, e2) -> BoxesRunTime.boxToBoolean((boolean)CreateRulesMarkdown$.$anonfun$generate$2(e1, e2)));
        List<String> contentString = this.contents((List<DefinitionChecker>)checkers, config);
        List docs = (List)checkers.flatMap((Function1 & Serializable & scala.Serializable)c -> {
            CreateRulesMarkdown.Documentation doc = (CreateRulesMarkdown.Documentation)scalastyleDocumentation.getOrElse((Object)c.id(), (Function0 & Serializable & scala.Serializable)() -> new CreateRulesMarkdown.Documentation((Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Seq<String>)Nil$.MODULE$));
            return this.checker((DefinitionChecker)c, doc, config);
        }, List$.MODULE$.canBuildFrom());
        List list = fileHeader;
        List<String> list2 = contentString;
        return docs.$colon$colon$colon(list2).$colon$colon$colon(list);
    }

    private void generateToFile(String file) {
        Predef$.MODULE$.println((Object)("writing to " + file));
        String contents = this.generate().mkString("\n");
        Files.write(Paths.get(file, new String[0]), contents.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public void main(String[] args) {
        if (args.length == 0) {
            this.usage(BuildInfo$.MODULE$.version());
        } else {
            BoxedUnit boxedUnit;
            try {
                this.generateToFile(args[0]);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.exit(1);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public static final /* synthetic */ boolean $anonfun$generate$2(DefinitionChecker e1, DefinitionChecker e2) {
        return e1.className().compareTo(e2.className()) < 0;
    }

    private CreateRulesMarkdown$() {
        MODULE$ = this;
        this.docFile = "scalastyle_documentation.xml";
        this.defnFile = "scalastyle_definition.xml";
    }
}

