/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.PendingIntent;
import android.telephony.SmsManager;
import android.text.TextUtils;
import java.util.ArrayList;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.internal.Shadow;

@Implements(value=SmsManager.class)
public class ShadowSmsManager {
    private static SmsManager realManager = (SmsManager)Shadow.newInstanceOf(SmsManager.class);
    private TextSmsParams lastTextSmsParams;
    private TextMultipartParams lastTextMultipartParams;
    private DataMessageParams lastDataParams;

    @Implementation
    public static SmsManager getDefault() {
        return realManager;
    }

    @Implementation
    public void sendDataMessage(String destinationAddress, String scAddress, short destinationPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        if (TextUtils.isEmpty((CharSequence)destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        this.lastDataParams = new DataMessageParams(destinationAddress, scAddress, destinationPort, data, sentIntent, deliveryIntent);
    }

    @Implementation
    public void sendTextMessage(String destinationAddress, String scAddress, String text, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        if (TextUtils.isEmpty((CharSequence)destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (TextUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("Invalid message body");
        }
        this.lastTextSmsParams = new TextSmsParams(destinationAddress, scAddress, text, sentIntent, deliveryIntent);
    }

    @Implementation
    public void sendMultipartTextMessage(String destinationAddress, String scAddress, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents) {
        if (TextUtils.isEmpty((CharSequence)destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (parts == null) {
            throw new IllegalArgumentException("Invalid message parts");
        }
        this.lastTextMultipartParams = new TextMultipartParams(destinationAddress, scAddress, parts, sentIntents, deliveryIntents);
    }

    public DataMessageParams getLastSentDataMessageParams() {
        return this.lastDataParams;
    }

    public void clearLastSentDataMessageParams() {
        this.lastDataParams = null;
    }

    public TextSmsParams getLastSentTextMessageParams() {
        return this.lastTextSmsParams;
    }

    public void clearLastSentTextMessageParams() {
        this.lastTextSmsParams = null;
    }

    public TextMultipartParams getLastSentMultipartTextMessageParams() {
        return this.lastTextMultipartParams;
    }

    public void clearLastSentMultipartTextMessageParams() {
        this.lastTextMultipartParams = null;
    }

    public static class TextMultipartParams {
        private final String destinationAddress;
        private final String scAddress;
        private final ArrayList<String> parts;
        private final ArrayList<PendingIntent> sentIntents;
        private final ArrayList<PendingIntent> deliveryIntents;

        public TextMultipartParams(String destinationAddress, String scAddress, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents) {
            this.destinationAddress = destinationAddress;
            this.scAddress = scAddress;
            this.parts = parts;
            this.sentIntents = sentIntents;
            this.deliveryIntents = deliveryIntents;
        }

        public String getDestinationAddress() {
            return this.destinationAddress;
        }

        public String getScAddress() {
            return this.scAddress;
        }

        public ArrayList<String> getParts() {
            return this.parts;
        }

        public ArrayList<PendingIntent> getSentIntents() {
            return this.sentIntents;
        }

        public ArrayList<PendingIntent> getDeliveryIntents() {
            return this.deliveryIntents;
        }
    }

    public static class TextSmsParams {
        private final String destinationAddress;
        private final String scAddress;
        private final String text;
        private final PendingIntent sentIntent;
        private final PendingIntent deliveryIntent;

        public TextSmsParams(String destinationAddress, String scAddress, String text, PendingIntent sentIntent, PendingIntent deliveryIntent) {
            this.destinationAddress = destinationAddress;
            this.scAddress = scAddress;
            this.text = text;
            this.sentIntent = sentIntent;
            this.deliveryIntent = deliveryIntent;
        }

        public String getDestinationAddress() {
            return this.destinationAddress;
        }

        public String getScAddress() {
            return this.scAddress;
        }

        public String getText() {
            return this.text;
        }

        public PendingIntent getSentIntent() {
            return this.sentIntent;
        }

        public PendingIntent getDeliveryIntent() {
            return this.deliveryIntent;
        }
    }

    public static class DataMessageParams {
        private final String destinationAddress;
        private final String scAddress;
        private final short destinationPort;
        private final byte[] data;
        private final PendingIntent sentIntent;
        private final PendingIntent deliveryIntent;

        public DataMessageParams(String destinationAddress, String scAddress, short destinationPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
            this.destinationAddress = destinationAddress;
            this.scAddress = scAddress;
            this.destinationPort = destinationPort;
            this.data = data;
            this.sentIntent = sentIntent;
            this.deliveryIntent = deliveryIntent;
        }

        public String getDestinationAddress() {
            return this.destinationAddress;
        }

        public String getScAddress() {
            return this.scAddress;
        }

        public short getDestinationPort() {
            return this.destinationPort;
        }

        public byte[] getData() {
            return this.data;
        }

        public PendingIntent getSentIntent() {
            return this.sentIntent;
        }

        public PendingIntent getDeliveryIntent() {
            return this.deliveryIntent;
        }
    }
}

