/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Handler;
import android.os.Message;
import android.os.MessageQueue;
import org.robolectric.Shadows;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.internal.Shadow;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.Scheduler;

@Implements(value=MessageQueue.class)
public class ShadowMessageQueue {
    @RealObject
    private MessageQueue realQueue;
    private Scheduler scheduler;

    @HiddenApi
    @Implementation
    public static long nativeInit() {
        return 1L;
    }

    @HiddenApi
    @Implementation
    public static void nativeDestroy(long ptr) {
    }

    @HiddenApi
    @Implementation
    public static void nativePollOnce(long ptr, int timeoutMillis) {
        throw new AssertionError((Object)"Should not be called");
    }

    @HiddenApi
    @Implementation
    public static void nativeWake(long ptr) {
        throw new AssertionError((Object)"Should not be called");
    }

    @HiddenApi
    @Implementation
    public static boolean nativeIsIdling(long ptr) {
        return false;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Message getHead() {
        return (Message)ReflectionHelpers.getField((Object)this.realQueue, (String)"mMessages");
    }

    public void setHead(Message msg) {
        ReflectionHelpers.setField((Object)this.realQueue, (String)"mMessages", (Object)msg);
    }

    public void reset() {
        this.setHead(null);
    }

    @Implementation
    public boolean enqueueMessage(final Message msg, long when) {
        boolean retval = (Boolean)Shadow.directlyOn((Object)this.realQueue, MessageQueue.class, (String)"enqueueMessage", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Message.class, (Object)msg), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)when)});
        if (retval) {
            Runnable callback = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    MessageQueue messageQueue = ShadowMessageQueue.this.realQueue;
                    synchronized (messageQueue) {
                        Message m = ShadowMessageQueue.this.getHead();
                        if (m == null) {
                            return;
                        }
                        Message n = Shadows.shadowOf(m).getNext();
                        if (m == msg) {
                            ShadowMessageQueue.this.setHead(n);
                            ShadowMessageQueue.dispatchMessage(msg);
                            return;
                        }
                        while (n != null) {
                            if (n == msg) {
                                n = Shadows.shadowOf(n).getNext();
                                Shadows.shadowOf(m).setNext(n);
                                ShadowMessageQueue.dispatchMessage(msg);
                                return;
                            }
                            m = n;
                            n = Shadows.shadowOf(m).getNext();
                        }
                    }
                }
            };
            Shadows.shadowOf(msg).setScheduledRunnable(callback);
            if (when == 0L) {
                this.scheduler.postAtFrontOfQueue(callback);
            } else {
                this.scheduler.postDelayed(callback, when - this.scheduler.getCurrentTime());
            }
        }
        return retval;
    }

    @HiddenApi
    @Implementation
    public void removeSyncBarrier(int token) {
    }

    private static void dispatchMessage(Message msg) {
        Handler target = msg.getTarget();
        Shadows.shadowOf(msg).setNext(null);
        if (target != null) {
            ReflectionHelpers.callInstanceMethod((Object)msg, (String)"markInUse", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
            target.dispatchMessage(msg);
            ReflectionHelpers.callInstanceMethod((Object)msg, (String)"recycleUnchecked", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        }
    }
}

