/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.JobSchedulerImpl;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=JobScheduler.class)
public abstract class ShadowJobScheduler {
    @Implementation
    public abstract int schedule(JobInfo var1);

    @Implementation
    public abstract void cancel(int var1);

    @Implementation
    public abstract void cancelAll();

    @Implementation
    public abstract List<JobInfo> getAllPendingJobs();

    public abstract void failOnJob(int var1);

    @Implements(value=JobSchedulerImpl.class, isInAndroidSdk=false)
    public static class ShadowJobSchedulerImpl
    extends ShadowJobScheduler {
        private Map<Integer, JobInfo> scheduledJobs = new HashMap<Integer, JobInfo>();
        private Set<Integer> jobsToFail = new HashSet<Integer>();

        @Override
        @Implementation
        public int schedule(JobInfo job) {
            if (this.jobsToFail.contains(job.getId())) {
                return 0;
            }
            this.scheduledJobs.put(job.getId(), job);
            return 1;
        }

        @Override
        @Implementation
        public void cancel(int jobId) {
        }

        @Override
        @Implementation
        public void cancelAll() {
            this.scheduledJobs.clear();
        }

        @Override
        @Implementation
        public List<JobInfo> getAllPendingJobs() {
            return new ArrayList<JobInfo>(this.scheduledJobs.values());
        }

        @Override
        public void failOnJob(int jobId) {
            this.jobsToFail.add(jobId);
        }
    }
}

