/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Environment;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.TempDirectory;

@Implements(value=Environment.class)
public class ShadowEnvironment {
    private static String externalStorageState = "removed";
    private static final Map<File, Boolean> STORAGE_EMULATED = new HashMap<File, Boolean>();
    private static final Map<File, Boolean> STORAGE_REMOVABLE = new HashMap<File, Boolean>();
    static Path EXTERNAL_CACHE_DIR;
    static Path EXTERNAL_FILES_DIR;

    @Implementation
    public static String getExternalStorageState() {
        return externalStorageState;
    }

    public static void setExternalStorageState(String externalStorageState) {
        ShadowEnvironment.externalStorageState = externalStorageState;
    }

    @Implementation
    public static File getExternalStorageDirectory() {
        if (!ShadowEnvironment.exists(EXTERNAL_CACHE_DIR)) {
            EXTERNAL_CACHE_DIR = TempDirectory.create();
        }
        return EXTERNAL_CACHE_DIR.toFile();
    }

    @Implementation
    public static File getExternalStoragePublicDirectory(String type) {
        if (!ShadowEnvironment.exists(EXTERNAL_FILES_DIR)) {
            EXTERNAL_FILES_DIR = TempDirectory.create();
        }
        if (type == null) {
            return EXTERNAL_FILES_DIR.toFile();
        }
        Path path = EXTERNAL_FILES_DIR.resolve(type);
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return path.toFile();
    }

    @Resetter
    public static void reset() {
        TempDirectory.destroy((Path)EXTERNAL_CACHE_DIR);
        TempDirectory.destroy((Path)EXTERNAL_FILES_DIR);
        EXTERNAL_CACHE_DIR = null;
        EXTERNAL_FILES_DIR = null;
        STORAGE_EMULATED.clear();
        STORAGE_REMOVABLE.clear();
    }

    private static boolean exists(Path path) {
        return path != null && Files.exists(path, new LinkOption[0]);
    }

    @Implementation
    public static boolean isExternalStorageRemovable() {
        Boolean exists = STORAGE_REMOVABLE.get(ShadowEnvironment.getExternalStorageDirectory());
        return exists != null ? exists : false;
    }

    @Implementation
    public static String getStorageState(File path) {
        return externalStorageState;
    }

    @Implementation
    public static String getExternalStorageState(File path) {
        return externalStorageState;
    }

    @Implementation
    public static boolean isExternalStorageRemovable(File path) {
        Boolean exists = STORAGE_REMOVABLE.get(path);
        return exists != null ? exists : false;
    }

    @Implementation
    public static boolean isExternalStorageEmulated(File path) {
        Boolean emulated = STORAGE_EMULATED.get(path);
        return emulated != null ? emulated : false;
    }

    public static void setExternalStorageRemovable(File file, boolean isRemovable) {
        STORAGE_REMOVABLE.put(file, isRemovable);
    }

    public static void setExternalStorageEmulated(File file, boolean isEmulated) {
        STORAGE_EMULATED.put(file, isEmulated);
    }
}

