/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.database.CursorWindow;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=CursorWindow.class)
public class ShadowCursorWindow {
    private static final WindowData WINDOW_DATA = new WindowData();

    @Implementation
    public static long nativeCreate(String name, int cursorWindowSize) {
        return WINDOW_DATA.create(name, cursorWindowSize);
    }

    @Implementation
    public static void nativeDispose(long windowPtr) {
        WINDOW_DATA.close(windowPtr);
    }

    @Implementation
    public static byte[] nativeGetBlob(long windowPtr, int row, int column) {
        Value value = WINDOW_DATA.get(windowPtr).value(row, column);
        switch (value.type) {
            case 0: {
                return null;
            }
            case 4: {
                byte[] blob = (byte[])value.value;
                return blob == null ? new byte[]{} : blob;
            }
            case 3: {
                return ((String)value.value).getBytes();
            }
        }
        throw new android.database.sqlite.SQLiteException("Getting blob when column is non-blob. Row " + row + ", col " + column);
    }

    @Implementation
    public static String nativeGetString(long windowPtr, int row, int column) {
        Value val = WINDOW_DATA.get(windowPtr).value(row, column);
        if (val.type == 4) {
            throw new android.database.sqlite.SQLiteException("Getting string when column is blob. Row " + row + ", col " + column);
        }
        Object value = val.value;
        return value == null ? null : String.valueOf(value);
    }

    @Implementation
    public static long nativeGetLong(long windowPtr, int row, int column) {
        return ShadowCursorWindow.nativeGetNumber(windowPtr, row, column).longValue();
    }

    @Implementation
    public static double nativeGetDouble(long windowPtr, int row, int column) {
        return ShadowCursorWindow.nativeGetNumber(windowPtr, row, column).doubleValue();
    }

    @Implementation
    public static int nativeGetType(long windowPtr, int row, int column) {
        return WINDOW_DATA.get(windowPtr).value(row, column).type;
    }

    @Implementation
    public static void nativeClear(long windowPtr) {
        WINDOW_DATA.clear(windowPtr);
    }

    @Implementation
    public static int nativeGetNumRows(long windowPtr) {
        return WINDOW_DATA.get(windowPtr).numRows();
    }

    @Implementation
    public static boolean nativePutBlob(long windowPtr, byte[] value, int row, int column) {
        return WINDOW_DATA.get(windowPtr).putValue(new Value(value, 4), row, column);
    }

    @Implementation
    public static boolean nativePutString(long windowPtr, String value, int row, int column) {
        return WINDOW_DATA.get(windowPtr).putValue(new Value(value, 3), row, column);
    }

    @Implementation
    public static boolean nativePutLong(long windowPtr, long value, int row, int column) {
        return WINDOW_DATA.get(windowPtr).putValue(new Value(value, 1), row, column);
    }

    @Implementation
    public static boolean nativePutDouble(long windowPtr, double value, int row, int column) {
        return WINDOW_DATA.get(windowPtr).putValue(new Value(value, 2), row, column);
    }

    @Implementation
    public static boolean nativePutNull(long windowPtr, int row, int column) {
        return WINDOW_DATA.get(windowPtr).putValue(new Value(null, 0), row, column);
    }

    @Implementation
    public static boolean nativeAllocRow(long windowPtr) {
        return WINDOW_DATA.get(windowPtr).allocRow();
    }

    @Implementation
    public static boolean nativeSetNumColumns(long windowPtr, int columnNum) {
        return WINDOW_DATA.get(windowPtr).setNumColumns(columnNum);
    }

    @Implementation
    public static String nativeGetName(long windowPtr) {
        return WINDOW_DATA.get(windowPtr).getName();
    }

    protected static int setData(long windowPtr, SQLiteStatement stmt) throws SQLiteException {
        return WINDOW_DATA.setData(windowPtr, stmt);
    }

    private static Number nativeGetNumber(long windowPtr, int row, int column) {
        Value value = WINDOW_DATA.get(windowPtr).value(row, column);
        switch (value.type) {
            case 0: 
            case 5: {
                return 0;
            }
            case 1: 
            case 2: {
                return (Number)value.value;
            }
            case 3: {
                try {
                    return Double.parseDouble((String)value.value);
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
            case 4: {
                throw new android.database.sqlite.SQLiteException("could not convert " + value);
            }
        }
        throw new android.database.sqlite.SQLiteException("unknown type: " + value.type);
    }

    private static class WindowData {
        private final AtomicLong windowPtrCounter = new AtomicLong(0L);
        private final Map<Long, Data> dataMap = new ConcurrentHashMap<Long, Data>();

        private WindowData() {
        }

        public Data get(long ptr) {
            Data data = this.dataMap.get(ptr);
            if (data == null) {
                throw new IllegalArgumentException("Invalid window pointer: " + ptr + "; current pointers: " + this.dataMap.keySet());
            }
            return data;
        }

        public int setData(long ptr, SQLiteStatement stmt) throws SQLiteException {
            Data data = this.get(ptr);
            data.fillWith(stmt);
            return data.numRows();
        }

        public void close(long ptr) {
            Data removed = this.dataMap.remove(ptr);
            if (removed == null) {
                throw new IllegalArgumentException("Bad cursor window pointer " + ptr + ". Valid pointers: " + this.dataMap.keySet());
            }
        }

        public void clear(long ptr) {
            this.get(ptr).clear();
        }

        public long create(String name, int cursorWindowSize) {
            long ptr = this.windowPtrCounter.incrementAndGet();
            this.dataMap.put(ptr, new Data(name, cursorWindowSize));
            return ptr;
        }
    }

    private static class Value {
        private final Object value;
        private final int type;

        public Value(Object value, int type) {
            this.value = value;
            this.type = type;
        }
    }

    private static class Row {
        private final List<Value> values;

        public Row(int length) {
            this.values = new ArrayList<Value>(length);
            for (int i = 0; i < length; ++i) {
                this.values.add(new Value(null, 0));
            }
        }

        public Value get(int n) {
            return this.values.get(n);
        }

        public boolean set(int colN, Value value) {
            this.values.set(colN, value);
            return true;
        }
    }

    private static class Data {
        private final List<Row> rows;
        private final String name;
        private int numColumns;

        public Data(String name, int cursorWindowSize) {
            this.name = name;
            this.rows = new ArrayList<Row>(cursorWindowSize);
        }

        public Value value(int rowN, int colN) {
            Row row = this.rows.get(rowN);
            if (row == null) {
                throw new IllegalArgumentException("Bad row number: " + rowN + ", count: " + this.rows.size());
            }
            return row.get(colN);
        }

        public int numRows() {
            return this.rows.size();
        }

        public boolean putValue(Value value, int rowN, int colN) {
            return this.rows.get(rowN).set(colN, value);
        }

        public void fillWith(SQLiteStatement stmt) throws SQLiteException {
            while (stmt.step()) {
                this.rows.add(Data.fillRowValues(stmt));
            }
        }

        private static int cursorValueType(int sqliteType) {
            switch (sqliteType) {
                case 5: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
            }
            throw new IllegalArgumentException("Bad SQLite type " + sqliteType + ". See possible values in SQLiteConstants.");
        }

        private static Row fillRowValues(SQLiteStatement stmt) throws SQLiteException {
            int columnCount = stmt.columnCount();
            Row row = new Row(columnCount);
            for (int index = 0; index < columnCount; ++index) {
                row.set(index, new Value(stmt.columnValue(index), Data.cursorValueType(stmt.columnType(index))));
            }
            return row;
        }

        public void clear() {
            this.rows.clear();
        }

        public boolean allocRow() {
            this.rows.add(new Row(this.numColumns));
            return true;
        }

        public boolean setNumColumns(int numColumns) {
            this.numColumns = numColumns;
            return true;
        }

        public String getName() {
            return this.name;
        }
    }
}

