/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.robolectric.Shadows;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowNetwork;
import org.robolectric.shadows.ShadowNetworkInfo;

@Implements(value=ConnectivityManager.class)
public class ShadowConnectivityManager {
    static final int NET_ID_WIFI = 1;
    static final int NET_ID_MOBILE = 0;
    private NetworkInfo activeNetworkInfo;
    private boolean backgroundDataSetting;
    private int networkPreference = 1;
    private final Map<Integer, NetworkInfo> networkTypeToNetworkInfo = new HashMap<Integer, NetworkInfo>();
    private HashSet<ConnectivityManager.NetworkCallback> networkCallbacks = new HashSet();
    private final Map<Integer, Network> netIdToNetwork = new HashMap<Integer, Network>();
    private final Map<Integer, NetworkInfo> netIdToNetworkInfo = new HashMap<Integer, NetworkInfo>();

    public ShadowConnectivityManager() {
        NetworkInfo wifi = ShadowNetworkInfo.newInstance(NetworkInfo.DetailedState.DISCONNECTED, 1, 0, true, false);
        this.networkTypeToNetworkInfo.put(1, wifi);
        NetworkInfo mobile = ShadowNetworkInfo.newInstance(NetworkInfo.DetailedState.CONNECTED, 0, 2, true, true);
        this.networkTypeToNetworkInfo.put(0, mobile);
        this.activeNetworkInfo = mobile;
        this.netIdToNetwork.put(1, ShadowNetwork.newInstance(1));
        this.netIdToNetwork.put(0, ShadowNetwork.newInstance(0));
        this.netIdToNetworkInfo.put(1, wifi);
        this.netIdToNetworkInfo.put(0, mobile);
    }

    public Set<ConnectivityManager.NetworkCallback> getNetworkCallbacks() {
        return this.networkCallbacks;
    }

    @Implementation
    public void registerNetworkCallback(NetworkRequest request, ConnectivityManager.NetworkCallback networkCallback) {
        this.networkCallbacks.add(networkCallback);
    }

    @Implementation
    public void unregisterNetworkCallback(ConnectivityManager.NetworkCallback networkCallback) {
        if (networkCallback == null) {
            throw new IllegalArgumentException("Invalid NetworkCallback");
        }
        if (this.networkCallbacks.contains(networkCallback)) {
            this.networkCallbacks.remove(networkCallback);
        }
    }

    @Implementation
    public NetworkInfo getActiveNetworkInfo() {
        return this.activeNetworkInfo;
    }

    @Implementation
    public Network getActiveNetwork() {
        return this.netIdToNetwork.get(this.getActiveNetworkInfo().getType());
    }

    @Implementation
    public NetworkInfo[] getAllNetworkInfo() {
        return this.networkTypeToNetworkInfo.values().toArray(new NetworkInfo[this.networkTypeToNetworkInfo.size()]);
    }

    @Implementation
    public NetworkInfo getNetworkInfo(int networkType) {
        return this.networkTypeToNetworkInfo.get(networkType);
    }

    @Implementation
    public NetworkInfo getNetworkInfo(Network network) {
        ShadowNetwork shadowNetwork = Shadows.shadowOf(network);
        return this.netIdToNetworkInfo.get(shadowNetwork.getNetId());
    }

    @Implementation
    public Network[] getAllNetworks() {
        return this.netIdToNetwork.values().toArray(new Network[this.netIdToNetwork.size()]);
    }

    @Implementation
    public boolean getBackgroundDataSetting() {
        return this.backgroundDataSetting;
    }

    @Implementation
    public void setNetworkPreference(int preference) {
        this.networkPreference = preference;
    }

    @Implementation
    public int getNetworkPreference() {
        return this.networkPreference;
    }

    @Implementation
    public boolean isActiveNetworkMetered() {
        if (this.activeNetworkInfo != null) {
            return this.activeNetworkInfo.getType() == 0;
        }
        return false;
    }

    public void setNetworkInfo(int networkType, NetworkInfo networkInfo) {
        this.networkTypeToNetworkInfo.put(networkType, networkInfo);
    }

    @HiddenApi
    @Implementation
    public void setBackgroundDataSetting(boolean b) {
        this.backgroundDataSetting = b;
    }

    public void setActiveNetworkInfo(NetworkInfo info) {
        this.activeNetworkInfo = info;
        if (info != null) {
            this.networkTypeToNetworkInfo.put(info.getType(), info);
            this.netIdToNetwork.put(info.getType(), ShadowNetwork.newInstance(info.getType()));
        } else {
            this.networkTypeToNetworkInfo.clear();
            this.netIdToNetwork.clear();
        }
    }

    public void addNetwork(Network network, NetworkInfo networkInfo) {
        ShadowNetwork shadowNetwork = Shadows.shadowOf(network);
        int netId = shadowNetwork.getNetId();
        this.netIdToNetwork.put(netId, network);
        this.netIdToNetworkInfo.put(netId, networkInfo);
    }

    public void removeNetwork(Network network) {
        ShadowNetwork shadowNetwork = Shadows.shadowOf(network);
        int netId = shadowNetwork.getNetId();
        this.netIdToNetwork.remove(netId);
        this.netIdToNetworkInfo.remove(netId);
    }

    public void clearAllNetworks() {
        this.netIdToNetwork.clear();
        this.netIdToNetworkInfo.clear();
    }
}

