/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import java.util.Optional;
import javax.annotation.Nonnull;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.VersionStoreException;

public class ReferenceConflictException
extends VersionStoreException {
    private static final long serialVersionUID = 4381980193289615523L;

    public ReferenceConflictException(String message) {
        super(message);
    }

    public ReferenceConflictException(String message, Throwable t) {
        super(message, t);
    }

    @Nonnull
    public static ReferenceConflictException forReference(@Nonnull NamedRef ref, @Nonnull Optional<Hash> expected, @Nonnull Optional<Hash> actual) {
        String expectedArgument = expected.map(Hash::asString).orElse("no reference");
        String actualArgument = actual.map(Hash::asString).orElse("no reference");
        String refType = ref instanceof BranchName ? "branch" : (ref instanceof TagName ? "tag" : "named ref");
        return new ReferenceConflictException(String.format("Expected %s for %s '%s' but was %s", expectedArgument, refType, ref.getName(), actualArgument));
    }

    @Nonnull
    public static ReferenceConflictException forReference(@Nonnull NamedRef ref, @Nonnull Optional<Hash> expected, @Nonnull Optional<Hash> actual, @Nonnull Throwable t) {
        String expectedArgument = expected.map(Hash::asString).orElse("no reference");
        String actualArgument = actual.map(Hash::asString).orElse("no reference");
        String refType = ref instanceof BranchName ? "branch" : (ref instanceof TagName ? "tag" : "named ref");
        return new ReferenceConflictException(String.format("Expected %s for %s '%s' but was %s", expectedArgument, refType, ref.getName(), actualArgument), t);
    }
}

