/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.WithHash;
import org.projectnessie.versioned.WithType;

public final class MetricsVersionStore<VALUE, METADATA, VALUE_TYPE extends Enum<VALUE_TYPE>>
implements VersionStore<VALUE, METADATA, VALUE_TYPE> {
    private final VersionStore<VALUE, METADATA, VALUE_TYPE> delegate;
    private final MeterRegistry registry;
    private final Clock clock;
    private final Iterable<Tag> commonTags;

    MetricsVersionStore(VersionStore<VALUE, METADATA, VALUE_TYPE> delegate, MeterRegistry registry, Clock clock) {
        this.delegate = delegate;
        this.registry = registry;
        this.clock = clock;
        this.commonTags = Tags.of((String)"application", (String)"Nessie");
    }

    public MetricsVersionStore(VersionStore<VALUE, METADATA, VALUE_TYPE> delegate) {
        this(delegate, (MeterRegistry)Metrics.globalRegistry, Clock.SYSTEM);
    }

    @Override
    public Hash hashOnReference(NamedRef namedReference, Optional<Hash> hashOnReference) throws ReferenceNotFoundException {
        return this.delegate1Ex("hashonreference", () -> this.delegate.hashOnReference(namedReference, hashOnReference));
    }

    @Override
    @Nonnull
    public Hash noAncestorHash() {
        return this.delegate.noAncestorHash();
    }

    @Override
    public WithHash<Ref> toRef(@Nonnull String refOfUnknownType) throws ReferenceNotFoundException {
        return this.delegate1Ex("toref", () -> this.delegate.toRef(refOfUnknownType));
    }

    @Override
    public Hash commit(@Nonnull BranchName branch, @Nonnull Optional<Hash> referenceHash, @Nonnull METADATA metadata, @Nonnull List<Operation<VALUE>> operations) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.delegate2ExR("commit", () -> this.delegate.commit(branch, referenceHash, metadata, operations));
    }

    @Override
    public void transplant(BranchName targetBranch, Optional<Hash> referenceHash, List<Hash> sequenceToTransplant) throws ReferenceNotFoundException, ReferenceConflictException {
        this.delegate2Ex("transplant", () -> this.delegate.transplant(targetBranch, referenceHash, sequenceToTransplant));
    }

    @Override
    public void merge(Hash fromHash, BranchName toBranch, Optional<Hash> expectedHash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.delegate2Ex("merge", () -> this.delegate.merge(fromHash, toBranch, expectedHash));
    }

    @Override
    public void assign(NamedRef ref, Optional<Hash> expectedHash, Hash targetHash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.delegate2Ex("assign", () -> this.delegate.assign(ref, expectedHash, targetHash));
    }

    @Override
    public Hash create(NamedRef ref, Optional<Hash> targetHash) throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        return this.delegate2ExR("create", () -> this.delegate.create(ref, targetHash));
    }

    @Override
    public void delete(NamedRef ref, Optional<Hash> hash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.delegate2Ex("delete", () -> this.delegate.delete(ref, hash));
    }

    @Override
    public ReferenceInfo<METADATA> getNamedRef(String ref, GetNamedRefsParams params) throws ReferenceNotFoundException {
        return this.delegate1Ex("getnamedref", () -> this.delegate.getNamedRef(ref, params));
    }

    @Override
    public Stream<ReferenceInfo<METADATA>> getNamedRefs(GetNamedRefsParams params) throws ReferenceNotFoundException {
        return this.delegateStream1Ex("getnamedrefs", () -> this.delegate.getNamedRefs(params));
    }

    @Override
    public Stream<Commit<METADATA, VALUE>> getCommits(Ref ref, boolean fetchAdditionalInfo) throws ReferenceNotFoundException {
        return this.delegateStream1Ex("getcommits", () -> this.delegate.getCommits(ref, fetchAdditionalInfo));
    }

    @Override
    public Stream<WithType<Key, VALUE_TYPE>> getKeys(Ref ref) throws ReferenceNotFoundException {
        return this.delegateStream1Ex("getkeys", () -> this.delegate.getKeys(ref));
    }

    @Override
    public VALUE getValue(Ref ref, Key key) throws ReferenceNotFoundException {
        return (VALUE)this.delegate1Ex("getvalue", () -> this.delegate.getValue(ref, key));
    }

    @Override
    public Map<Key, VALUE> getValues(Ref ref, Collection<Key> keys) throws ReferenceNotFoundException {
        return this.delegate1Ex("getvalues", () -> this.delegate.getValues(ref, keys));
    }

    @Override
    public Stream<Diff<VALUE>> getDiffs(Ref from, Ref to) throws ReferenceNotFoundException {
        return this.delegateStream1Ex("getdiffs", () -> this.delegate.getDiffs(from, to));
    }

    private void measure(String requestName, Timer.Sample sample, Exception failure) {
        Timer timer = Timer.builder((String)"nessie.versionstore.request").tags(this.commonTags).tag("request", requestName).tag("error", Boolean.toString(failure != null)).publishPercentileHistogram().register(this.registry);
        sample.stop(timer);
    }

    private <R> Stream<R> delegateStream(String requestName, Delegate<Stream<R>> delegate) {
        Timer.Sample sample = Timer.start((Clock)this.clock);
        try {
            return (Stream)delegate.handle().onClose(() -> this.measure(requestName, sample, null));
        }
        catch (IllegalArgumentException e) {
            this.measure(requestName, sample, null);
            throw e;
        }
        catch (RuntimeException e) {
            this.measure(requestName, sample, e);
            throw e;
        }
    }

    private <R> Stream<R> delegateStream1Ex(String requestName, DelegateWith1<Stream<R>, ReferenceNotFoundException> delegate) throws ReferenceNotFoundException {
        Timer.Sample sample = Timer.start((Clock)this.clock);
        try {
            return (Stream)delegate.handle().onClose(() -> this.measure(requestName, sample, null));
        }
        catch (IllegalArgumentException | ReferenceNotFoundException e) {
            this.measure(requestName, sample, null);
            throw e;
        }
        catch (RuntimeException e) {
            this.measure(requestName, sample, e);
            throw e;
        }
    }

    private <R> R delegate(String requestName, Delegate<R> delegate) {
        Timer.Sample sample = Timer.start((Clock)this.clock);
        RuntimeException failure = null;
        try {
            R r = delegate.handle();
            return r;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            failure = e;
            throw e;
        }
        finally {
            this.measure(requestName, sample, failure);
        }
    }

    private <R, E1 extends VersionStoreException> R delegate1Ex(String requestName, DelegateWith1<R, E1> delegate) throws E1 {
        Timer.Sample sample = Timer.start((Clock)this.clock);
        RuntimeException failure = null;
        try {
            R r = delegate.handle();
            return r;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            failure = e;
            throw e;
        }
        finally {
            this.measure(requestName, sample, failure);
        }
    }

    private <E1 extends VersionStoreException, E2 extends VersionStoreException> void delegate2Ex(String requestName, DelegateWith2<E1, E2> delegate) throws E1, E2 {
        Timer.Sample sample = Timer.start((Clock)this.clock);
        RuntimeException failure = null;
        try {
            delegate.handle();
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            failure = e;
            throw e;
        }
        finally {
            this.measure(requestName, sample, failure);
        }
    }

    private <R, E1 extends VersionStoreException, E2 extends VersionStoreException> R delegate2ExR(String requestName, DelegateWith2R<R, E1, E2> delegate) throws E1, E2 {
        Timer.Sample sample = Timer.start((Clock)this.clock);
        RuntimeException failure = null;
        try {
            R r = delegate.handle();
            return r;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            failure = e;
            throw e;
        }
        finally {
            this.measure(requestName, sample, failure);
        }
    }

    @FunctionalInterface
    static interface DelegateWith2R<R, E1 extends VersionStoreException, E2 extends VersionStoreException> {
        public R handle() throws E1, E2;
    }

    @FunctionalInterface
    static interface DelegateWith2<E1 extends VersionStoreException, E2 extends VersionStoreException> {
        public void handle() throws E1, E2;
    }

    @FunctionalInterface
    static interface DelegateWith1<R, E1 extends VersionStoreException> {
        public R handle() throws E1;
    }

    @FunctionalInterface
    static interface Delegate<R> {
        public R handle();
    }
}

