/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.WithPayload;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="WithPayload", generator="Immutables")
@Immutable
public final class ImmutableWithPayload<T>
implements WithPayload<T> {
    @Nullable
    private final Byte payload;
    private final T value;

    private ImmutableWithPayload(@Nullable Byte payload, T value) {
        this.payload = payload;
        this.value = value;
    }

    @Override
    @Nullable
    public Byte getPayload() {
        return this.payload;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public final ImmutableWithPayload<T> withPayload(@Nullable Byte value) {
        if (Objects.equals(this.payload, value)) {
            return this;
        }
        return new ImmutableWithPayload<T>(value, this.value);
    }

    public final ImmutableWithPayload<T> withValue(T value) {
        if (this.value == value) {
            return this;
        }
        T newValue = Objects.requireNonNull(value, "value");
        return new ImmutableWithPayload<T>(this.payload, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWithPayload && this.equalTo((ImmutableWithPayload)another);
    }

    private boolean equalTo(ImmutableWithPayload<?> another) {
        return Objects.equals(this.payload, another.payload) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.payload);
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WithPayload").omitNullValues().add("payload", (Object)this.payload).add("value", this.value).toString();
    }

    public static <T> ImmutableWithPayload<T> copyOf(WithPayload<T> instance) {
        if (instance instanceof ImmutableWithPayload) {
            return (ImmutableWithPayload)instance;
        }
        return ImmutableWithPayload.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="WithPayload", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T> {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        @Nullable
        private Byte payload;
        @Nullable
        private T value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(WithPayload<T> instance) {
            Objects.requireNonNull(instance, "instance");
            Byte payloadValue = instance.getPayload();
            if (payloadValue != null) {
                this.payload(payloadValue);
            }
            this.value(instance.getValue());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> payload(@Nullable Byte payload) {
            this.payload = payload;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> value(T value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableWithPayload<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWithPayload(this.payload, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build WithPayload, some of required attributes are not set " + attributes;
        }
    }
}

