/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Put;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Put", generator="Immutables")
@Immutable
public final class ImmutablePut<V>
implements Put<V> {
    private final boolean shouldMatchHash;
    private final Key key;
    private final V value;
    @Nullable
    private final V expectedValue;

    private ImmutablePut(Builder<V> builder) {
        this.key = ((Builder)builder).key;
        this.value = ((Builder)builder).value;
        this.expectedValue = ((Builder)builder).expectedValue;
        this.shouldMatchHash = ((Builder)builder).shouldMatchHashIsSet() ? ((Builder)builder).shouldMatchHash : Put.super.shouldMatchHash();
    }

    private ImmutablePut(boolean shouldMatchHash, Key key, V value, @Nullable V expectedValue) {
        this.shouldMatchHash = shouldMatchHash;
        this.key = key;
        this.value = value;
        this.expectedValue = expectedValue;
    }

    @Override
    public boolean shouldMatchHash() {
        return this.shouldMatchHash;
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    @Nullable
    public V getExpectedValue() {
        return this.expectedValue;
    }

    public final ImmutablePut<V> withShouldMatchHash(boolean value) {
        if (this.shouldMatchHash == value) {
            return this;
        }
        return new ImmutablePut<V>(value, this.key, this.value, this.expectedValue);
    }

    public final ImmutablePut<V> withKey(Key value) {
        if (this.key == value) {
            return this;
        }
        Key newValue = Objects.requireNonNull(value, "key");
        return new ImmutablePut<V>(this.shouldMatchHash, newValue, this.value, this.expectedValue);
    }

    public final ImmutablePut<V> withValue(V value) {
        if (this.value == value) {
            return this;
        }
        V newValue = Objects.requireNonNull(value, "value");
        return new ImmutablePut<V>(this.shouldMatchHash, this.key, newValue, this.expectedValue);
    }

    public final ImmutablePut<V> withExpectedValue(@Nullable V value) {
        if (this.expectedValue == value) {
            return this;
        }
        return new ImmutablePut<V>(this.shouldMatchHash, this.key, this.value, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePut && this.equalTo((ImmutablePut)another);
    }

    private boolean equalTo(ImmutablePut<?> another) {
        return this.shouldMatchHash == another.shouldMatchHash && this.key.equals(another.key) && this.value.equals(another.value) && Objects.equals(this.expectedValue, another.expectedValue);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.shouldMatchHash);
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + Objects.hashCode(this.expectedValue);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Put").omitNullValues().add("shouldMatchHash", this.shouldMatchHash).add("key", (Object)this.key).add("value", this.value).add("expectedValue", this.expectedValue).toString();
    }

    public static <V> ImmutablePut<V> copyOf(Put<V> instance) {
        if (instance instanceof ImmutablePut) {
            return (ImmutablePut)instance;
        }
        return ImmutablePut.builder().from(instance).build();
    }

    public static <V> Builder<V> builder() {
        return new Builder();
    }

    @Generated(from="Put", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<V> {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private static final long OPT_BIT_SHOULD_MATCH_HASH = 1L;
        private long initBits = 3L;
        private long optBits;
        private boolean shouldMatchHash;
        @Nullable
        private Key key;
        @Nullable
        private V value;
        @Nullable
        private V expectedValue;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<V> from(Put<V> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<V> from(Operation<V> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Operation instance;
            if (object instanceof Put) {
                instance = (Put)object;
                Object expectedValueValue = instance.getExpectedValue();
                if (expectedValueValue != null) {
                    this.expectedValue(expectedValueValue);
                }
                this.value(instance.getValue());
            }
            if (object instanceof Operation) {
                instance = (Operation)object;
                this.shouldMatchHash(instance.shouldMatchHash());
                this.key(instance.getKey());
            }
        }

        @CanIgnoreReturnValue
        public final Builder<V> shouldMatchHash(boolean shouldMatchHash) {
            this.shouldMatchHash = shouldMatchHash;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<V> key(Key key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<V> value(V value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<V> expectedValue(@Nullable V expectedValue) {
            this.expectedValue = expectedValue;
            return this;
        }

        public ImmutablePut<V> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePut(this);
        }

        private boolean shouldMatchHashIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build Put, some of required attributes are not set " + attributes;
        }
    }
}

