/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.Key;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Diff", generator="Immutables")
@Immutable
public final class ImmutableDiff<VALUE>
implements Diff<VALUE> {
    private final Key key;
    @Nullable
    private final VALUE fromValue;
    @Nullable
    private final VALUE toValue;

    private ImmutableDiff(Key key, @Nullable VALUE fromValue, @Nullable VALUE toValue) {
        this.key = key;
        this.fromValue = fromValue;
        this.toValue = toValue;
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public Optional<VALUE> getFromValue() {
        return Optional.ofNullable(this.fromValue);
    }

    @Override
    public Optional<VALUE> getToValue() {
        return Optional.ofNullable(this.toValue);
    }

    public final ImmutableDiff<VALUE> withKey(Key value) {
        if (this.key == value) {
            return this;
        }
        Key newValue = Objects.requireNonNull(value, "key");
        return new ImmutableDiff<VALUE>(newValue, this.fromValue, this.toValue);
    }

    public final ImmutableDiff<VALUE> withFromValue(VALUE value) {
        VALUE newValue = Objects.requireNonNull(value, "fromValue");
        if (this.fromValue == newValue) {
            return this;
        }
        return new ImmutableDiff<VALUE>(this.key, newValue, this.toValue);
    }

    public final ImmutableDiff<VALUE> withFromValue(Optional<? extends VALUE> optional) {
        VALUE value = optional.orElse(null);
        if (this.fromValue == value) {
            return this;
        }
        return new ImmutableDiff<Object>(this.key, value, this.toValue);
    }

    public final ImmutableDiff<VALUE> withToValue(VALUE value) {
        VALUE newValue = Objects.requireNonNull(value, "toValue");
        if (this.toValue == newValue) {
            return this;
        }
        return new ImmutableDiff<VALUE>(this.key, this.fromValue, newValue);
    }

    public final ImmutableDiff<VALUE> withToValue(Optional<? extends VALUE> optional) {
        VALUE value = optional.orElse(null);
        if (this.toValue == value) {
            return this;
        }
        return new ImmutableDiff<Object>(this.key, this.fromValue, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDiff && this.equalTo((ImmutableDiff)another);
    }

    private boolean equalTo(ImmutableDiff<?> another) {
        return this.key.equals(another.key) && Objects.equals(this.fromValue, another.fromValue) && Objects.equals(this.toValue, another.toValue);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + Objects.hashCode(this.fromValue);
        h += (h << 5) + Objects.hashCode(this.toValue);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Diff").omitNullValues().add("key", (Object)this.key).add("fromValue", this.fromValue).add("toValue", this.toValue).toString();
    }

    public static <VALUE> ImmutableDiff<VALUE> copyOf(Diff<VALUE> instance) {
        if (instance instanceof ImmutableDiff) {
            return (ImmutableDiff)instance;
        }
        return ImmutableDiff.builder().from(instance).build();
    }

    public static <VALUE> Builder<VALUE> builder() {
        return new Builder();
    }

    @Generated(from="Diff", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<VALUE> {
        private static final long INIT_BIT_KEY = 1L;
        private long initBits = 1L;
        @Nullable
        private Key key;
        @Nullable
        private VALUE fromValue;
        @Nullable
        private VALUE toValue;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<VALUE> from(Diff<VALUE> instance) {
            Optional<VALUE> toValueOptional;
            Objects.requireNonNull(instance, "instance");
            this.key(instance.getKey());
            Optional<VALUE> fromValueOptional = instance.getFromValue();
            if (fromValueOptional.isPresent()) {
                this.fromValue(fromValueOptional);
            }
            if ((toValueOptional = instance.getToValue()).isPresent()) {
                this.toValue(toValueOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<VALUE> key(Key key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<VALUE> fromValue(VALUE fromValue) {
            this.fromValue = Objects.requireNonNull(fromValue, "fromValue");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<VALUE> fromValue(Optional<? extends VALUE> fromValue) {
            this.fromValue = fromValue.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<VALUE> toValue(VALUE toValue) {
            this.toValue = Objects.requireNonNull(toValue, "toValue");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<VALUE> toValue(Optional<? extends VALUE> toValue) {
            this.toValue = toValue.orElse(null);
            return this;
        }

        public ImmutableDiff<VALUE> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDiff(this.key, this.fromValue, this.toValue);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build Diff, some of required attributes are not set " + attributes;
        }
    }
}

