/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.projectnessie.versioned.Ref;

public final class Hash
implements Ref {
    private static final BaseEncoding ENCODING = BaseEncoding.base16().lowerCase();
    private final ByteString bytes;

    private Hash(ByteString bytes) {
        this.bytes = Objects.requireNonNull(bytes);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String asString() {
        int maxSize = 2 * this.bytes.size();
        try (StringWriter sw = new StringWriter(maxSize);){
            String string;
            block13: {
                OutputStream os = ENCODING.encodingStream((Writer)sw);
                try {
                    this.bytes.writeTo(os);
                    string = sw.toString();
                    if (os == null) break block13;
                }
                catch (Throwable throwable) {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                os.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ByteString asBytes() {
        return this.bytes;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Hash of(@Nonnull String hash) {
        Objects.requireNonNull(hash);
        Preconditions.checkArgument((hash.length() % 2 == 0 ? 1 : 0) != 0, (String)"hash length needs to be a multiple of two, was %s", (int)hash.length());
        int maxSize = hash.length() / 2;
        try (StringReader sr = new StringReader(hash);){
            Hash hash2;
            block14: {
                InputStream is = ENCODING.decodingStream((Reader)sr);
                try {
                    ByteString bytes = ByteString.readFrom((InputStream)is, (int)maxSize);
                    hash2 = Hash.of(bytes);
                    if (is == null) break block14;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return hash2;
        }
        catch (BaseEncoding.DecodingException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Hash of(@Nonnull ByteString bytes) {
        return new Hash(bytes);
    }

    public int hashCode() {
        return this.bytes.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Hash)) {
            return false;
        }
        Hash that = (Hash)obj;
        return Objects.equals(this.bytes, that.bytes);
    }

    public String toString() {
        return "Hash " + this.asString();
    }
}

