/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.rocks;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterFactory;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapterConfig;
import org.projectnessie.versioned.persist.rocks.ImmutableRocksDbConfig;
import org.projectnessie.versioned.persist.rocks.RocksDatabaseAdapterFactory;
import org.projectnessie.versioned.persist.rocks.RocksDbConfig;
import org.projectnessie.versioned.persist.rocks.RocksDbInstance;
import org.projectnessie.versioned.persist.tests.extension.AbstractTestConnectionProviderSource;

public class RocksTestConnectionProviderSource
extends AbstractTestConnectionProviderSource<RocksDbConfig> {
    private Path rocksDir;

    public boolean isCompatibleWith(DatabaseAdapterConfig adapterConfig, DatabaseAdapterFactory<?, ?, ?> databaseAdapterFactory) {
        return adapterConfig instanceof NonTransactionalDatabaseAdapterConfig && databaseAdapterFactory instanceof RocksDatabaseAdapterFactory;
    }

    public RocksDbConfig createDefaultConnectionProviderConfig() {
        return ImmutableRocksDbConfig.builder().build();
    }

    public RocksDbInstance createConnectionProvider() {
        return new RocksDbInstance();
    }

    public void start() throws Exception {
        this.rocksDir = Files.createTempDirectory("junit-rocks", new FileAttribute[0]);
        this.configureConnectionProviderConfigFromDefaults(c -> c.withDbPath(this.rocksDir.toString()));
        super.start();
    }

    public void stop() throws Exception {
        try {
            super.stop();
        }
        finally {
            if (this.rocksDir != null) {
                RocksTestConnectionProviderSource.deleteTempDir(this.rocksDir);
            }
        }
    }

    private static void deleteTempDir(Path dir) throws IOException {
        if (Files.notExists(dir, new LinkOption[0])) {
            return;
        }
        final ArrayList failures = new ArrayList();
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                return this.tryDelete(file);
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                return this.tryDelete(dir);
            }

            private FileVisitResult tryDelete(Path path) {
                try {
                    Files.delete(path);
                }
                catch (NoSuchFileException noSuchFileException) {
                }
                catch (IOException e) {
                    failures.add(e);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        if (!failures.isEmpty()) {
            IOException e = new IOException("Could not delete temp-directory " + dir);
            failures.forEach(e::addSuppressed);
            throw e;
        }
    }
}

