/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.style;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StreamUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaStyle;
import org.openrewrite.java.style.Deserializer;
import org.openrewrite.java.style.Serializer;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public class ImportLayoutStyle
implements JavaStyle {
    private final int classCountToUseStarImport;
    private final int nameCountToUseStarImport;
    private final List<Block> layout;
    private final List<Block> blocksNoCatchalls;
    private final List<Block> blocksOnlyCatchalls;

    public ImportLayoutStyle(int classCountToUseStarImport, int nameCountToUseStarImport, List<Block> layout) {
        this.classCountToUseStarImport = classCountToUseStarImport;
        this.nameCountToUseStarImport = nameCountToUseStarImport;
        this.layout = layout;
        Map<Boolean, List<Block>> blockGroups = layout.stream().collect(Collectors.partitioningBy(block -> block instanceof Block.AllOthers));
        this.blocksNoCatchalls = blockGroups.get(false);
        this.blocksOnlyCatchalls = blockGroups.get(true);
    }

    /*
     * WARNING - void declaration
     */
    public List<JRightPadded<J.Import>> addImport(List<JRightPadded<J.Import>> originalImports, J.Import toAdd, @Nullable J.Package pkg) {
        JRightPadded<J.Import> anImport2;
        JRightPadded<J.Import> anImport22;
        void var9_18;
        JRightPadded<J.Import> paddedToAdd = new JRightPadded<J.Import>(toAdd, Space.EMPTY, Markers.EMPTY);
        if (originalImports.isEmpty()) {
            return Collections.singletonList(pkg == null ? paddedToAdd : paddedToAdd.withElement(paddedToAdd.getElement().withPrefix(Space.format("\n\n"))));
        }
        List<JRightPadded<J.Import>> ideallyOrdered = new ImportLayoutStyle(Integer.MAX_VALUE, Integer.MAX_VALUE, this.layout).orderImports(ListUtils.concat(originalImports, paddedToAdd));
        if (ideallyOrdered.size() == originalImports.size()) {
            HashSet<String> originalPaths = new HashSet<String>();
            for (JRightPadded<J.Import> jRightPadded : originalImports) {
                originalPaths.add(jRightPadded.getElement().getQualid().toString());
            }
            int sharedImports = 0;
            for (JRightPadded<J.Import> jRightPadded : ideallyOrdered) {
                if (!originalPaths.contains(jRightPadded.getElement().getQualid().toString())) continue;
                ++sharedImports;
            }
            if (sharedImports == originalImports.size()) {
                return originalImports;
            }
        }
        JRightPadded<J.Import> before = null;
        JRightPadded<J.Import> after = null;
        Block block = this.block(paddedToAdd);
        boolean bl = false;
        block2: for (int i3 = 0; i3 < ideallyOrdered.size(); ++i3) {
            int j;
            JRightPadded<J.Import> anImport3 = ideallyOrdered.get(i3);
            if (!anImport3.getElement().isScope(paddedToAdd.getElement())) continue;
            before = i3 > 0 ? ideallyOrdered.get(i3 - 1) : null;
            JRightPadded<J.Import> jRightPadded = after = i3 + 1 < ideallyOrdered.size() ? ideallyOrdered.get(i3 + 1) : null;
            if (before != null) {
                for (j = 0; j < originalImports.size(); ++j) {
                    if (!before.getElement().equals(originalImports.get(j).getElement())) continue;
                    int n = j + 1;
                    after = n < originalImports.size() ? originalImports.get(n) : null;
                    break block2;
                }
            } else {
                if (after == null) break;
                for (j = 0; j < originalImports.size(); ++j) {
                    if (!after.getElement().equals(originalImports.get(j).getElement())) continue;
                    int n = j;
                    before = j > 0 ? originalImports.get(n - 1) : null;
                    break block2;
                }
            }
            break;
        }
        if (before == null) {
            if (pkg != null) {
                Space prefix = originalImports.get(0).getElement().getPrefix();
                paddedToAdd = paddedToAdd.withElement(paddedToAdd.getElement().withPrefix(prefix));
            }
        } else if (this.block(before) != block) {
            for (void j = var9_17; j < originalImports.size(); ++j) {
                if (this.block(originalImports.get((int)j)) != block) continue;
                var9_18 = j;
                after = originalImports.get((int)j);
                break;
            }
            paddedToAdd = paddedToAdd.withElement(paddedToAdd.getElement().withPrefix(Space.format("\n\n")));
        } else {
            paddedToAdd = paddedToAdd.withElement(paddedToAdd.getElement().withPrefix(Space.format("\n")));
        }
        AtomicInteger starFoldFrom = new AtomicInteger((int)var9_18);
        AtomicInteger starFoldTo = new AtomicInteger((int)var9_18);
        AtomicBoolean starFold = new AtomicBoolean(false);
        int sameCount = 1;
        for (void i2 = var9_18; i2 < originalImports.size() && this.block(anImport22 = originalImports.get((int)i2)) == block && ImportLayoutStyle.packageOrOuterClassName(anImport22).equals(ImportLayoutStyle.packageOrOuterClassName(paddedToAdd)); ++i2) {
            starFoldTo.set((int)(i2 + true));
            ++sameCount;
        }
        for (void i2 = var9_18 - true; i2 >= 0 && this.block(anImport2 = originalImports.get((int)i2)) == block && ImportLayoutStyle.packageOrOuterClassName(anImport2).equals(ImportLayoutStyle.packageOrOuterClassName(paddedToAdd)); --i2) {
            starFoldFrom.set((int)i2);
            ++sameCount;
        }
        if (paddedToAdd.getElement().isStatic() && this.nameCountToUseStarImport <= sameCount || !paddedToAdd.getElement().isStatic() && this.classCountToUseStarImport <= sameCount) {
            starFold.set(true);
            if (var9_18 != starFoldFrom.get()) {
                paddedToAdd = paddedToAdd.withElement(paddedToAdd.getElement().withPrefix(originalImports.get(starFoldFrom.get()).getElement().getPrefix()));
            }
        }
        if (starFold.get()) {
            paddedToAdd = paddedToAdd.withElement(paddedToAdd.getElement().withQualid(paddedToAdd.getElement().getQualid().withName(paddedToAdd.getElement().getQualid().getName().withName("*"))));
            JRightPadded<J.Import> jRightPadded = after = starFoldTo.get() < originalImports.size() ? originalImports.get(starFoldTo.get()) : null;
        }
        if (after != null) {
            if (this.block(after) == block) {
                after = after.withElement(after.getElement().withPrefix(Space.format("\n")));
            } else if (after.getElement().getPrefix().getLastWhitespace().chars().filter(c -> c == 10).count() < 2L) {
                after = after.withElement(after.getElement().withPrefix(Space.format("\n\n")));
            }
        }
        JRightPadded<J.Import> finalToAdd = paddedToAdd;
        JRightPadded<J.Import> finalAfter = after;
        return ListUtils.flatMap(originalImports, (i, anImport) -> {
            if (starFold.get() && i >= starFoldFrom.get() && i < starFoldTo.get()) {
                return i.intValue() == starFoldFrom.get() ? finalToAdd : null;
            }
            if (finalAfter != null && ((J.Import)anImport.getElement()).isScope((Tree)finalAfter.getElement())) {
                return starFold.get() ? finalAfter : Arrays.asList(finalToAdd, finalAfter);
            }
            if (i == originalImports.size() - 1 && finalAfter == null) {
                return Arrays.asList(anImport, finalToAdd);
            }
            return anImport;
        });
    }

    private Block block(JRightPadded<J.Import> anImport) {
        for (Block block : this.layout) {
            if (!block.accept(anImport)) continue;
            return block;
        }
        throw new IllegalStateException("Expected to find a block to fit import into.");
    }

    public List<JRightPadded<J.Import>> orderImports(List<JRightPadded<J.Import>> originalImports) {
        LayoutState layoutState = new LayoutState();
        ArrayList<JRightPadded<J.Import>> orderedImports = new ArrayList<JRightPadded<J.Import>>();
        block0: for (JRightPadded<J.Import> anImport : originalImports) {
            for (Block block : this.blocksNoCatchalls) {
                if (!block.accept(anImport)) continue;
                layoutState.claimImport(block, anImport);
                continue block0;
            }
            for (Block block : this.blocksOnlyCatchalls) {
                if (!block.accept(anImport)) continue;
                layoutState.claimImport(block, anImport);
                continue block0;
            }
        }
        int importIndex = 0;
        int extraLineSpaceCount = 0;
        String prevWhitespace = "";
        for (Block block : this.layout) {
            if (block instanceof Block.BlankLines) {
                extraLineSpaceCount = 0;
                for (int i = 0; i < ((Block.BlankLines)block).getCount(); ++i) {
                    ++extraLineSpaceCount;
                }
                continue;
            }
            for (JRightPadded<J.Import> orderedImport : block.orderedImports(layoutState, this.classCountToUseStarImport, this.nameCountToUseStarImport)) {
                Space prefix;
                boolean whitespaceContainsCRLF = orderedImport.getElement().getPrefix().getWhitespace().contains("\r\n");
                if (importIndex == 0) {
                    prefix = originalImports.get(0).getElement().getPrefix();
                } else {
                    String newLineCharacters = whitespaceContainsCRLF || StringUtils.isNullOrEmpty((String)orderedImport.getElement().getPrefix().getWhitespace()) && prevWhitespace.equals("\r\n") ? "\r\n" : "\n";
                    StringBuilder newWhitespace = new StringBuilder(newLineCharacters);
                    for (int i = 0; i < extraLineSpaceCount; ++i) {
                        newWhitespace.append(newLineCharacters);
                    }
                    prefix = orderedImport.getElement().getPrefix().withWhitespace(newWhitespace.toString());
                }
                if (!orderedImport.getElement().getPrefix().equals(prefix)) {
                    orderedImports.add(orderedImport.withElement(orderedImport.getElement().withPrefix(prefix)));
                } else {
                    orderedImports.add(orderedImport);
                }
                prevWhitespace = whitespaceContainsCRLF ? "\r\n" : "\n";
                extraLineSpaceCount = 0;
                ++importIndex;
            }
        }
        return orderedImports;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("classWildcards=").append(this.classCountToUseStarImport).append(", staticWildcards=").append(this.nameCountToUseStarImport).append('\n');
        for (Block block : this.layout) {
            s.append(block).append("\n");
        }
        return s.toString();
    }

    private static String packageOrOuterClassName(JRightPadded<J.Import> anImport) {
        String typeName = anImport.getElement().getTypeName();
        if (anImport.getElement().isStatic()) {
            return typeName;
        }
        String className = anImport.getElement().getClassName();
        if (className.contains(".")) {
            return anImport.getElement().getPackageName() + className.substring(0, className.lastIndexOf(46));
        }
        return anImport.getElement().getPackageName();
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImportLayoutStyle)) {
            return false;
        }
        ImportLayoutStyle other = (ImportLayoutStyle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getClassCountToUseStarImport() != other.getClassCountToUseStarImport()) {
            return false;
        }
        if (this.getNameCountToUseStarImport() != other.getNameCountToUseStarImport()) {
            return false;
        }
        List<Block> this$layout = this.getLayout();
        List<Block> other$layout = other.getLayout();
        return !(this$layout == null ? other$layout != null : !((Object)this$layout).equals(other$layout));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ImportLayoutStyle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getClassCountToUseStarImport();
        result = result * 59 + this.getNameCountToUseStarImport();
        List<Block> $layout = this.getLayout();
        result = result * 59 + ($layout == null ? 43 : ((Object)$layout).hashCode());
        return result;
    }

    public int getClassCountToUseStarImport() {
        return this.classCountToUseStarImport;
    }

    public int getNameCountToUseStarImport() {
        return this.nameCountToUseStarImport;
    }

    public List<Block> getLayout() {
        return this.layout;
    }

    public List<Block> getBlocksNoCatchalls() {
        return this.blocksNoCatchalls;
    }

    public List<Block> getBlocksOnlyCatchalls() {
        return this.blocksOnlyCatchalls;
    }

    public static interface Block {
        public boolean accept(JRightPadded<J.Import> var1);

        public List<JRightPadded<J.Import>> orderedImports(LayoutState var1, int var2, int var3);

        public static class AllOthers
        extends ImportPackage {
            private final boolean statik;
            private Collection<ImportPackage> packageImports = Collections.emptyList();

            public AllOthers(boolean statik) {
                super(statik, "*", true);
                this.statik = statik;
            }

            public void setPackageImports(Collection<ImportPackage> packageImports) {
                this.packageImports = packageImports;
            }

            @Override
            public boolean isStatic() {
                return this.statik;
            }

            @Override
            public boolean accept(JRightPadded<J.Import> anImport) {
                for (ImportPackage pi : this.packageImports) {
                    if (!pi.accept(anImport)) continue;
                    return false;
                }
                return anImport.getElement().isStatic() == this.statik;
            }

            @Override
            public String toString() {
                return "import " + (this.statik ? "static " : "") + "all other imports";
            }
        }

        public static class ImportPackage
        implements Block {
            static final Comparator<JRightPadded<J.Import>> IMPORT_SORTING = (i1, i2) -> {
                String[] import1 = ((J.Import)i1.getElement()).getQualid().printTrimmed().split("\\.");
                String[] import2 = ((J.Import)i2.getElement()).getQualid().printTrimmed().split("\\.");
                for (int i = 0; i < Math.min(import1.length, import2.length); ++i) {
                    int diff = import1[i].compareTo(import2[i]);
                    if (diff == 0) continue;
                    return diff;
                }
                if (import1.length == import2.length) {
                    return 0;
                }
                return import1.length > import2.length ? 1 : -1;
            };
            private final Boolean statik;
            private final Pattern packageWildcard;

            public ImportPackage(Boolean statik, String packageWildcard, boolean withSubpackages) {
                this.statik = statik;
                this.packageWildcard = Pattern.compile(packageWildcard.replace(".", "\\.").replace("*", withSubpackages ? ".+" : "[^.]+"));
            }

            public boolean isStatic() {
                return this.statik;
            }

            public Pattern getPackageWildcard() {
                return this.packageWildcard;
            }

            @Override
            public boolean accept(JRightPadded<J.Import> anImport) {
                return anImport.getElement().isStatic() == this.statik.booleanValue() && this.packageWildcard.matcher(anImport.getElement().getQualid().printTrimmed()).matches();
            }

            @Override
            public List<JRightPadded<J.Import>> orderedImports(LayoutState layoutState, int classCountToUseStarImport, int nameCountToUseStarImport) {
                List<JRightPadded<J.Import>> imports = layoutState.getImports(this);
                Map groupedImports = imports.stream().sorted(IMPORT_SORTING).collect(Collectors.groupingBy(x$0 -> ImportLayoutStyle.packageOrOuterClassName(x$0), LinkedHashMap::new, Collectors.toList()));
                ArrayList<JRightPadded<J.Import>> ordered = new ArrayList<JRightPadded<J.Import>>(imports.size());
                for (List importGroup : groupedImports.values()) {
                    JRightPadded toStar = (JRightPadded)importGroup.get(0);
                    boolean statik1 = ((J.Import)toStar.getElement()).isStatic();
                    int threshold = statik1 ? nameCountToUseStarImport : classCountToUseStarImport;
                    boolean starImportExists = importGroup.stream().anyMatch(it -> ((J.Import)it.getElement()).getQualid().getSimpleName().equals("*"));
                    if (importGroup.size() >= threshold || starImportExists && importGroup.size() > 1) {
                        J.FieldAccess qualid = ((J.Import)toStar.getElement()).getQualid();
                        J.Identifier name = qualid.getName();
                        Set typeNamesInThisGroup = importGroup.stream().map(im -> ((J.Import)im.getElement()).getClassName()).collect(Collectors.toSet());
                        Optional<String> oneOfTheTypesIsInAnotherGroupToo = groupedImports.values().stream().filter(group -> group != importGroup).flatMap(group -> group.stream().filter(im -> typeNamesInThisGroup.contains(((J.Import)im.getElement()).getClassName()))).map(im -> ((J.Import)im.getElement()).getTypeName()).findAny();
                        if (starImportExists || !oneOfTheTypesIsInAnotherGroupToo.isPresent()) {
                            ordered.add(toStar.withElement(((J.Import)toStar.getElement()).withQualid(qualid.withName(name.withName("*")))));
                            continue;
                        }
                    }
                    Predicate predicate = StreamUtils.distinctBy(t -> ((J.Import)t.getElement()).printTrimmed());
                    for (JRightPadded importJRightPadded : importGroup) {
                        if (!predicate.test(importJRightPadded)) continue;
                        ordered.add(importJRightPadded);
                    }
                }
                ordered.sort(IMPORT_SORTING);
                return ordered;
            }

            public String toString() {
                return "import " + (this.statik != false ? "static " : "") + this.packageWildcard;
            }
        }

        public static class BlankLines
        implements Block {
            private int count = 1;

            private int getCount() {
                return this.count;
            }

            @Override
            public boolean accept(JRightPadded<J.Import> anImport) {
                return false;
            }

            @Override
            public List<JRightPadded<J.Import>> orderedImports(LayoutState layoutState, int classCountToUseStarImport, int nameCountToUseStartImport) {
                return Collections.emptyList();
            }

            public String toString() {
                return "<blank line>" + (this.count > 1 ? " (x" + this.count + ")" : "");
            }
        }
    }

    private static class LayoutState {
        Map<Block, List<JRightPadded<J.Import>>> imports = new HashMap<Block, List<JRightPadded<J.Import>>>();

        private LayoutState() {
        }

        public void claimImport(Block block, JRightPadded<J.Import> impoort) {
            this.imports.computeIfAbsent(block, b -> new ArrayList()).add(impoort);
        }

        public List<JRightPadded<J.Import>> getImports(Block block) {
            return this.imports.getOrDefault(block, Collections.emptyList());
        }
    }

    public static class Builder {
        private final List<Block> blocks = new ArrayList<Block>();
        private int classCountToUseStarImport = 5;
        private int nameCountToUseStarImport = 3;

        public Builder importAllOthers() {
            this.blocks.add(new Block.AllOthers(false));
            return this;
        }

        public Builder importStaticAllOthers() {
            this.blocks.add(new Block.AllOthers(true));
            return this;
        }

        public Builder blankLine() {
            if (!this.blocks.isEmpty() && this.blocks.get(this.blocks.size() - 1) instanceof Block.BlankLines) {
                ((Block.BlankLines)this.blocks.get(this.blocks.size() - 1)).count++;
            } else {
                this.blocks.add(new Block.BlankLines());
            }
            return this;
        }

        public Builder importPackage(String packageWildcard, Boolean withSubpackages) {
            this.blocks.add(new Block.ImportPackage(false, packageWildcard, withSubpackages));
            return this;
        }

        public Builder importPackage(String packageWildcard) {
            return this.importPackage(packageWildcard, true);
        }

        public Builder staticImportPackage(String packageWildcard, Boolean withSubpackages) {
            this.blocks.add(new Block.ImportPackage(true, packageWildcard, withSubpackages));
            return this;
        }

        public Builder staticImportPackage(String packageWildcard) {
            return this.staticImportPackage(packageWildcard, true);
        }

        public Builder classCountToUseStarImport(int classCountToUseStarImport) {
            this.classCountToUseStarImport = classCountToUseStarImport;
            return this;
        }

        public Builder nameCountToUseStarImport(int nameCountToUseStarImport) {
            this.nameCountToUseStarImport = nameCountToUseStarImport;
            return this;
        }

        public ImportLayoutStyle build() {
            assert (this.blocks.stream().anyMatch(it -> it instanceof Block.AllOthers && ((Block.AllOthers)it).isStatic())) : "There must be at least one block that accepts all static imports, but no such block was found in the specified layout";
            assert (this.blocks.stream().anyMatch(it -> it instanceof Block.AllOthers && !((Block.AllOthers)it).isStatic())) : "There must be at least one block that accepts all non-static imports, but no such block was found in the specified layout";
            for (Block block : this.blocks) {
                if (!(block instanceof Block.AllOthers)) continue;
                ((Block.AllOthers)block).setPackageImports(this.blocks.stream().filter(b -> b.getClass().equals(Block.ImportPackage.class)).map(Block.ImportPackage.class::cast).collect(Collectors.toList()));
            }
            return new ImportLayoutStyle(this.classCountToUseStarImport, this.nameCountToUseStarImport, this.blocks);
        }
    }
}

