/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.openrewrite.gradle.RewriteReflectiveFacade;

public class RecipeDescriptorTree
implements Comparable<RecipeDescriptorTree> {
    private static final Pattern PATH_SEPARATOR = Pattern.compile("\\.");
    private String displayName;
    private RecipeDescriptorTree parent;
    private final List<RecipeDescriptorTree> children = new ArrayList<RecipeDescriptorTree>();
    private RewriteReflectiveFacade.RecipeDescriptor recipeDescriptor = null;

    public RecipeDescriptorTree() {
        this(null);
    }

    public RecipeDescriptorTree(String displayName) {
        this.displayName = displayName;
        this.parent = null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public RecipeDescriptorTree addChild(RecipeDescriptorTree child) {
        child.parent = this;
        this.children.add(child);
        return child;
    }

    public RecipeDescriptorTree addChild(String displayName) {
        return this.addChild(new RecipeDescriptorTree(displayName));
    }

    public List<RecipeDescriptorTree> getChildren() {
        return this.children;
    }

    public RecipeDescriptorTree getParent() {
        return this.parent;
    }

    public RewriteReflectiveFacade.RecipeDescriptor getRecipeDescriptor() {
        return this.recipeDescriptor;
    }

    public void setRecipeDescriptor(RewriteReflectiveFacade.RecipeDescriptor recipeDescriptor) {
        this.recipeDescriptor = recipeDescriptor;
        this.displayName = recipeDescriptor.getDisplayName();
    }

    public void addPath(RewriteReflectiveFacade.RecipeDescriptor path) {
        String[] names = PATH_SEPARATOR.split(path.getName());
        RecipeDescriptorTree tree = this;
        for (String name : names) {
            tree = tree.children.stream().anyMatch(r -> r.displayName.equalsIgnoreCase(name)) ? tree.children.stream().filter(r -> r.displayName.equalsIgnoreCase(name)).findFirst().get() : tree.addChild(name);
        }
        tree.setRecipeDescriptor(path);
    }

    public void addPath(Iterable<RewriteReflectiveFacade.RecipeDescriptor> path) {
        for (RewriteReflectiveFacade.RecipeDescriptor rd : path) {
            this.addPath(rd);
        }
    }

    @Override
    public int compareTo(RecipeDescriptorTree o) {
        return this.children.size() - o.children.size();
    }
}

