/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.inject.Inject;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.TaskAction;
import org.openrewrite.gradle.AbstractRewriteTask;
import org.openrewrite.gradle.RewriteReflectiveFacade;

public class RewriteRunTask
extends AbstractRewriteTask {
    private static final Logger log = Logging.getLogger(RewriteRunTask.class);

    @Inject
    public RewriteRunTask() {
        this.setGroup("rewrite");
        this.setDescription("Apply the active refactoring recipes");
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @TaskAction
    public void run() {
        AbstractRewriteTask.ResultsContainer results = this.listResults();
        if (results.isNotEmpty()) {
            for (RewriteReflectiveFacade.Result result : results.generated) {
                assert (result.getAfter() != null);
                this.getLog().lifecycle("Generated new file " + result.getAfter().getSourcePath() + " by:");
                this.logRecipesThatMadeChanges(result);
            }
            for (RewriteReflectiveFacade.Result result : results.deleted) {
                assert (result.getBefore() != null);
                this.getLog().lifecycle("Deleted file " + result.getBefore().getSourcePath() + " by:");
                this.logRecipesThatMadeChanges(result);
            }
            for (RewriteReflectiveFacade.Result result : results.moved) {
                assert (result.getAfter() != null);
                assert (result.getBefore() != null);
                this.getLog().lifecycle("File has been moved from " + result.getBefore().getSourcePath() + " to " + result.getAfter().getSourcePath() + " by:");
                this.logRecipesThatMadeChanges(result);
            }
            for (RewriteReflectiveFacade.Result result : results.refactoredInPlace) {
                assert (result.getBefore() != null);
                this.getLog().lifecycle("Changes have been made to " + result.getBefore().getSourcePath() + " by:");
                this.logRecipesThatMadeChanges(result);
            }
            this.getLog().lifecycle("Please review and commit the results.");
            try {
                Path originalLocation;
                BufferedWriter sourceFileWriter;
                for (RewriteReflectiveFacade.Result result : results.generated) {
                    assert (result.getAfter() != null);
                    sourceFileWriter = Files.newBufferedWriter(results.getProjectRoot().resolve(result.getAfter().getSourcePath()), new OpenOption[0]);
                    try {
                        sourceFileWriter.write(result.getAfter().print());
                    }
                    finally {
                        if (sourceFileWriter == null) continue;
                        sourceFileWriter.close();
                    }
                }
                for (RewriteReflectiveFacade.Result result : results.deleted) {
                    assert (result.getBefore() != null);
                    originalLocation = results.getProjectRoot().resolve(result.getBefore().getSourcePath());
                    boolean deleteSucceeded = originalLocation.toFile().delete();
                    if (deleteSucceeded) continue;
                    throw new IOException("Unable to delete file " + originalLocation.toAbsolutePath());
                }
                for (RewriteReflectiveFacade.Result result : results.moved) {
                    assert (result.getBefore() != null);
                    originalLocation = results.getProjectRoot().resolve(result.getBefore().getSourcePath());
                    originalLocation.toFile().delete();
                    assert (result.getAfter() != null);
                    Path afterLocation = results.getProjectRoot().resolve(result.getAfter().getSourcePath());
                    File parentDir = afterLocation.toFile().getParentFile();
                    parentDir.mkdirs();
                    BufferedWriter sourceFileWriter2 = Files.newBufferedWriter(afterLocation, new OpenOption[0]);
                    try {
                        sourceFileWriter2.write(result.getAfter().print());
                    }
                    finally {
                        if (sourceFileWriter2 == null) continue;
                        sourceFileWriter2.close();
                    }
                }
                for (RewriteReflectiveFacade.Result result : results.refactoredInPlace) {
                    assert (result.getBefore() != null);
                    sourceFileWriter = Files.newBufferedWriter(results.getProjectRoot().resolve(result.getBefore().getSourcePath()), new OpenOption[0]);
                    try {
                        assert (result.getAfter() != null);
                        sourceFileWriter.write(result.getAfter().print());
                    }
                    finally {
                        if (sourceFileWriter == null) continue;
                        sourceFileWriter.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to rewrite source files", e);
            }
        }
    }
}

