/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.openrewrite.gradle.RewriteExtension;

public class RewriteReflectiveFacade {
    private final Configuration configuration;
    private final RewriteExtension extension;
    private final Task task;
    private URLClassLoader classLoader;
    private Method sourceFileGetMarkers = null;
    private Method sourceFileWithMarkers = null;
    private Method markersAddIfAbsent = null;

    public RewriteReflectiveFacade(Configuration configuration, RewriteExtension extension, Task task) {
        this.configuration = configuration;
        this.extension = extension;
        this.task = task;
    }

    private URLClassLoader getClassLoader() {
        if (this.classLoader == null) {
            DependencyHandler dependencies = this.task.getProject().getDependencies();
            String rewriteVersion = this.extension.getRewriteVersion();
            Dependency[] deps = (Dependency[])Stream.concat(this.configuration.getDependencies().stream(), Stream.of(dependencies.create((Object)("org.openrewrite:rewrite-core:" + rewriteVersion)), dependencies.create((Object)("org.openrewrite:rewrite-java:" + rewriteVersion)), dependencies.create((Object)("org.openrewrite:rewrite-java-11:" + rewriteVersion)), dependencies.create((Object)("org.openrewrite:rewrite-java-8:" + rewriteVersion)), dependencies.create((Object)("org.openrewrite:rewrite-xml:" + rewriteVersion)), dependencies.create((Object)("org.openrewrite:rewrite-yaml:" + rewriteVersion)), dependencies.create((Object)("org.openrewrite:rewrite-properties:" + rewriteVersion)), dependencies.create((Object)"org.slf4j:slf4j-simple:1.7.30"), dependencies.create((Object)("com.puppycrawl.tools:checkstyle:" + this.extension.getCheckstyleToolsVersion())))).toArray(Dependency[]::new);
            Configuration confWithRewrite = this.task.getProject().getConfigurations().detachedConfiguration(deps);
            URL[] jars = (URL[])confWithRewrite.getFiles().stream().map(File::toURI).map(uri -> {
                try {
                    return uri.toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).toArray(URL[]::new);
            this.classLoader = new URLClassLoader(jars);
        }
        return this.classLoader;
    }

    private List<SourceFile> parseBase(Object real, Iterable<Path> sourcePaths, Path baseDir, InMemoryExecutionContext ctx) {
        try {
            Class<?> executionContextClass = this.getClassLoader().loadClass("org.openrewrite.ExecutionContext");
            List results = (List)real.getClass().getMethod("parse", Iterable.class, Path.class, executionContextClass).invoke(real, sourcePaths, baseDir, ctx.real);
            return results.stream().map(x$0 -> new SourceFile(x$0)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JavaProvenanceBuilder javaProvenanceBuilder() {
        return new JavaProvenanceBuilder();
    }

    public JavaProvenanceBuilder javaProvenanceBuilder(JavaProvenanceBuilder other) {
        return new JavaProvenanceBuilder().buildToolVersion(other.buildToolVersion).projectName(other.projectName).publicationArtifactId(other.publicationArtifactId).publicationGroupId(other.publicationGroupId).publicationVersion(other.publicationVersion).sourceCompatibility(other.sourceCompatibility).sourceSetName(other.sourceSetName).targetCompatibility(other.targetCompatibility).vmRuntimeVersion(other.vmRuntimeVersion).vmVendor(other.vmVendor);
    }

    public NamedStyles loadCheckstyleConfig(Path checkstyleConf, Map<String, Object> properties) {
        try {
            Class<?> checkstyleClass = this.classLoader.loadClass("org.openrewrite.java.style.CheckstyleConfigLoader");
            Method method = checkstyleClass.getMethod("loadCheckstyleConfig", Path.class, Map.class);
            return new NamedStyles(method.invoke(null, checkstyleConf, properties));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public EnvironmentBuilder environmentBuilder(Properties properties) {
        try {
            return new EnvironmentBuilder(this.getClassLoader().loadClass("org.openrewrite.config.Environment").getMethod("builder", Properties.class).invoke(null, properties));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public YamlResourceLoader yamlResourceLoader(InputStream yamlInput, URI source, Properties properties) {
        try {
            return new YamlResourceLoader(this.getClassLoader().loadClass("org.openrewrite.config.YamlResourceLoader").getConstructor(InputStream.class, URI.class, Properties.class).newInstance(yamlInput, source, properties));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public InMemoryExecutionContext inMemoryExecutionContext(Consumer<Throwable> onError) {
        try {
            return new InMemoryExecutionContext(this.getClassLoader().loadClass("org.openrewrite.InMemoryExecutionContext").getConstructor(Consumer.class).newInstance(onError));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JavaParserBuilder javaParserFromJavaVersion() {
        try {
            if (System.getProperty("java.version").startsWith("1.8")) {
                return new JavaParserBuilder(this.getClassLoader().loadClass("org.openrewrite.java.Java8Parser").getMethod("builder", new Class[0]).invoke(null, new Object[0]));
            }
            return new JavaParserBuilder(this.getClassLoader().loadClass("org.openrewrite.java.Java11Parser").getMethod("builder", new Class[0]).invoke(null, new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public YamlParser yamlParser() {
        try {
            return new YamlParser(this.getClassLoader().loadClass("org.openrewrite.yaml.YamlParser").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PropertiesParser propertiesParser() {
        try {
            return new PropertiesParser(this.getClassLoader().loadClass("org.openrewrite.properties.PropertiesParser").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public XmlParser xmlParser() {
        try {
            return new XmlParser(this.getClassLoader().loadClass("org.openrewrite.xml.XmlParser").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public class XmlParser {
        private final Object real;

        private XmlParser(Object real) {
            this.real = real;
        }

        public List<SourceFile> parse(Iterable<Path> sourcePaths, Path baseDir, InMemoryExecutionContext ctx) {
            return RewriteReflectiveFacade.this.parseBase(this.real, sourcePaths, baseDir, ctx);
        }
    }

    public class PropertiesParser {
        private final Object real;

        private PropertiesParser(Object real) {
            this.real = real;
        }

        public List<SourceFile> parse(Iterable<Path> sourcePaths, Path baseDir, InMemoryExecutionContext ctx) {
            return RewriteReflectiveFacade.this.parseBase(this.real, sourcePaths, baseDir, ctx);
        }
    }

    public class YamlParser {
        private final Object real;

        private YamlParser(Object real) {
            this.real = real;
        }

        public List<SourceFile> parse(Iterable<Path> sourcePaths, Path baseDir, InMemoryExecutionContext ctx) {
            return RewriteReflectiveFacade.this.parseBase(this.real, sourcePaths, baseDir, ctx);
        }
    }

    public class JavaParser {
        private final Object real;

        private JavaParser(Object real) {
            this.real = real;
        }

        public List<SourceFile> parse(Iterable<Path> sourcePaths, Path baseDir, InMemoryExecutionContext ctx) {
            return RewriteReflectiveFacade.this.parseBase(this.real, sourcePaths, baseDir, ctx);
        }
    }

    public class JavaParserBuilder {
        private final Object real;

        private JavaParserBuilder(Object real) {
            this.real = real;
        }

        public JavaParserBuilder styles(List<NamedStyles> styles) {
            try {
                List unwrappedStyles = styles.stream().map(it -> ((NamedStyles)it).real).collect(Collectors.toList());
                this.real.getClass().getMethod("styles", Iterable.class).invoke(this.real, unwrappedStyles);
                return this;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public JavaParserBuilder classpath(Collection<Path> classpath) {
            try {
                this.real.getClass().getMethod("classpath", Collection.class).invoke(this.real, classpath);
                return this;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public JavaParserBuilder logCompilationWarningsAndErrors(boolean logCompilationWarningsAndErrors) {
            try {
                this.real.getClass().getMethod("logCompilationWarningsAndErrors", Boolean.TYPE).invoke(this.real, logCompilationWarningsAndErrors);
                return this;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public JavaParserBuilder relaxedClassTypeMatching(boolean relaxedClassTypeMatching) {
            try {
                this.real.getClass().getMethod("relaxedClassTypeMatching", Boolean.TYPE).invoke(this.real, relaxedClassTypeMatching);
                return this;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public JavaParser build() {
            try {
                return new JavaParser(this.real.getClass().getMethod("build", new Class[0]).invoke(this.real, new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class InMemoryExecutionContext {
        private final Object real;

        private InMemoryExecutionContext(Object real) {
            this.real = real;
        }
    }

    public class YamlResourceLoader {
        private final Object real;

        private YamlResourceLoader(Object real) {
            this.real = real;
        }
    }

    public class OptionDescriptor {
        private final Object real;

        private OptionDescriptor(Object real) {
            this.real = real;
        }

        public String getName() {
            try {
                return (String)this.real.getClass().getMethod("getName", new Class[0]).invoke(this.real, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String getDisplayName() {
            try {
                return (String)this.real.getClass().getMethod("getDisplayName", new Class[0]).invoke(this.real, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String getDescription() {
            try {
                return (String)this.real.getClass().getMethod("getDescription", new Class[0]).invoke(this.real, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String getType() {
            try {
                return (String)this.real.getClass().getMethod("getType", new Class[0]).invoke(this.real, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String getExample() {
            try {
                return (String)this.real.getClass().getMethod("getExample", new Class[0]).invoke(this.real, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public boolean isRequired() {
            try {
                return (Boolean)this.real.getClass().getMethod("isRequired", new Class[0]).invoke(this.real, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class RecipeDescriptor {
        private final Object real;

        private RecipeDescriptor(Object real) {
            this.real = real;
        }

        public String getName() {
            try {
                return (String)this.real.getClass().getMethod("getName", new Class[0]).invoke(this.real, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String getDisplayName() {
            try {
                return (String)this.real.getClass().getMethod("getDisplayName", new Class[0]).invoke(this.real, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String getDescription() {
            try {
                return (String)this.real.getClass().getMethod("getDescription", new Class[0]).invoke(this.real, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public List<OptionDescriptor> getOptions() {
            try {
                List results = (List)this.real.getClass().getMethod("getOptions", new Class[0]).invoke(this.real, new Object[0]);
                return results.stream().map(x$0 -> new OptionDescriptor(x$0)).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class Environment {
        private final Object real;

        private Environment(Object real) {
            this.real = real;
        }

        public List<NamedStyles> activateStyles(Iterable<String> activeStyles) {
            try {
                List raw = (List)this.real.getClass().getMethod("activateStyles", Iterable.class).invoke(this.real, activeStyles);
                return raw.stream().map(x$0 -> new NamedStyles(x$0)).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Recipe activateRecipes(Iterable<String> activeRecipes) {
            try {
                return new Recipe(this.real.getClass().getMethod("activateRecipes", Iterable.class).invoke(this.real, activeRecipes));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Collection<RecipeDescriptor> listRecipeDescriptors() {
            try {
                Collection result = (Collection)this.real.getClass().getMethod("listRecipeDescriptors", new Class[0]).invoke(this.real, new Object[0]);
                return result.stream().map(x$0 -> new RecipeDescriptor(x$0)).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Collection<NamedStyles> listStyles() {
            try {
                List raw = (List)this.real.getClass().getMethod("listStyles", new Class[0]).invoke(this.real, new Object[0]);
                return raw.stream().map(x$0 -> new NamedStyles(x$0)).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class NamedStyles {
        private final Object real;

        private NamedStyles(Object real) {
            this.real = real;
        }

        public String getName() {
            try {
                return (String)this.real.getClass().getMethod("getName", new Class[0]).invoke(this.real, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface Validated {
        public Object getReal();

        default public List<Invalid> failures() {
            try {
                Object real = this.getReal();
                List results = (List)real.getClass().getMethod("failures", new Class[0]).invoke(real, new Object[0]);
                return results.stream().map(Invalid::new).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public static class Both
        implements Validated {
            private final Object real;

            public Both(Object real) {
                this.real = real;
            }

            @Override
            public Object getReal() {
                return this.real;
            }
        }

        public static class Invalid
        implements Validated {
            private final Object real;

            public Invalid(Object real) {
                this.real = real;
            }

            @Override
            public Object getReal() {
                return this.real;
            }

            public String getProperty() {
                try {
                    return (String)this.real.getClass().getMethod("getProperty", new Class[0]).invoke(this.real, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public String getMessage() {
                try {
                    return (String)this.real.getClass().getMethod("getMessage", new Class[0]).invoke(this.real, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public Throwable getException() {
                try {
                    return (Throwable)this.real.getClass().getMethod("getException", new Class[0]).invoke(this.real, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public class Recipe {
        private final Object real;

        private Recipe(Object real) {
            this.real = real;
        }

        public List<Result> run(List<SourceFile> sources) {
            try {
                List unwrappedSources = sources.stream().map(it -> ((SourceFile)it).real).collect(Collectors.toList());
                List result = (List)this.real.getClass().getMethod("run", List.class).invoke(this.real, unwrappedSources);
                return result.stream().map(x$0 -> new Result(x$0)).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public List<Result> run(List<SourceFile> sources, InMemoryExecutionContext ctx) {
            try {
                Class<?> executionContextClass = RewriteReflectiveFacade.this.getClassLoader().loadClass("org.openrewrite.ExecutionContext");
                List unwrappedSources = sources.stream().map(it -> ((SourceFile)it).real).collect(Collectors.toList());
                List result = (List)this.real.getClass().getMethod("run", List.class, executionContextClass).invoke(this.real, unwrappedSources, ctx.real);
                return result.stream().map(x$0 -> new Result(x$0)).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String getName() {
            try {
                return (String)this.real.getClass().getMethod("getName", new Class[0]).invoke(this.real, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Collection<Validated> validateAll() {
            try {
                List results = (List)this.real.getClass().getMethod("validateAll", new Class[0]).invoke(this.real, new Object[0]);
                return results.stream().map(r -> {
                    String canonicalName = r.getClass().getCanonicalName();
                    if (canonicalName.equals("org.openrewrite.Validated.Invalid")) {
                        return new Validated.Invalid(r);
                    }
                    if (canonicalName.equals("org.openrewrite.Validated.Both")) {
                        return new Validated.Both(r);
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class Result {
        private final Object real;

        private Result(Object real) {
            this.real = real;
        }

        @Nullable
        public SourceFile getBefore() {
            try {
                return new SourceFile(this.real.getClass().getMethod("getBefore", new Class[0]).invoke(this.real, new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Nullable
        public SourceFile getAfter() {
            try {
                return new SourceFile(this.real.getClass().getMethod("getAfter", new Class[0]).invoke(this.real, new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public List<Recipe> getRecipesThatMadeChanges() {
            try {
                Set result = (Set)this.real.getClass().getMethod("getRecipesThatMadeChanges", new Class[0]).invoke(this.real, new Object[0]);
                return result.stream().map(x$0 -> new Recipe(x$0)).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String diff() {
            try {
                return (String)this.real.getClass().getMethod("diff", new Class[0]).invoke(this.real, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class JavaProvenanceBuilder {
        private String projectName;
        private String sourceSetName;
        private String buildToolVersion;
        private String vmRuntimeVersion;
        private String vmVendor;
        private String sourceCompatibility;
        private String targetCompatibility;
        private Iterable<Path> classpath;
        private String publicationGroupId;
        private String publicationArtifactId;
        private String publicationVersion;

        public JavaProvenanceBuilder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public JavaProvenanceBuilder sourceSetName(String sourceSetName) {
            this.sourceSetName = sourceSetName;
            return this;
        }

        public JavaProvenanceBuilder buildToolVersion(String buildToolVersion) {
            this.buildToolVersion = buildToolVersion;
            return this;
        }

        public JavaProvenanceBuilder vmRuntimeVersion(String vmRuntimeVersion) {
            this.vmRuntimeVersion = vmRuntimeVersion;
            return this;
        }

        public JavaProvenanceBuilder vmVendor(String vmVendor) {
            this.vmVendor = vmVendor;
            return this;
        }

        public JavaProvenanceBuilder sourceCompatibility(String sourceCompatibility) {
            this.sourceCompatibility = sourceCompatibility;
            return this;
        }

        public JavaProvenanceBuilder targetCompatibility(String targetCompatibility) {
            this.targetCompatibility = targetCompatibility;
            return this;
        }

        public JavaProvenanceBuilder classpath(Iterable<Path> classpath) {
            this.classpath = classpath;
            return this;
        }

        public JavaProvenanceBuilder publicationGroupId(String publicationGroupId) {
            this.publicationGroupId = publicationGroupId;
            return this;
        }

        public JavaProvenanceBuilder publicationArtifactId(String publicationArtifactId) {
            this.publicationArtifactId = publicationArtifactId;
            return this;
        }

        public JavaProvenanceBuilder publicationVersion(String publicationVersion) {
            this.publicationVersion = publicationVersion;
            return this;
        }

        public JavaProvenance build() {
            try {
                Object gradleType = Enum.valueOf(RewriteReflectiveFacade.this.getClassLoader().loadClass("org.openrewrite.java.marker.JavaProvenance$BuildTool$Type"), "Gradle");
                Object buildTool = RewriteReflectiveFacade.this.getClassLoader().loadClass("org.openrewrite.java.marker.JavaProvenance$BuildTool").getConstructor(gradleType.getClass(), String.class).newInstance(gradleType, this.buildToolVersion);
                Object javaVersion = RewriteReflectiveFacade.this.getClassLoader().loadClass("org.openrewrite.java.marker.JavaProvenance$JavaVersion").getConstructor(String.class, String.class, String.class, String.class).newInstance(this.vmRuntimeVersion, this.vmVendor, this.sourceCompatibility, this.targetCompatibility);
                Object publication = RewriteReflectiveFacade.this.getClassLoader().loadClass("org.openrewrite.java.marker.JavaProvenance$Publication").getConstructor(String.class, String.class, String.class).newInstance(this.publicationGroupId, this.publicationArtifactId, this.publicationVersion);
                Class<?> c = RewriteReflectiveFacade.this.getClassLoader().loadClass("org.openrewrite.java.marker.JavaProvenance");
                Method javaProvenanceBuilder = c.getMethod("build", String.class, String.class, buildTool.getClass(), javaVersion.getClass(), Iterable.class, publication.getClass());
                return new JavaProvenance(javaProvenanceBuilder.invoke((Object)c.getName(), this.projectName, this.sourceSetName, buildTool, javaVersion, this.classpath, publication));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class JavaProvenance
    implements Marker {
        private final Object real;

        private JavaProvenance(Object real) {
            this.real = real;
        }

        @Override
        public Object getReal() {
            return this.real;
        }
    }

    public class SourceFile {
        private final Object real;

        private SourceFile(Object real) {
            this.real = real;
        }

        public Path getSourcePath() {
            try {
                return (Path)this.real.getClass().getMethod("getSourcePath", new Class[0]).invoke(this.real, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String print() {
            try {
                return (String)this.real.getClass().getMethod("print", new Class[0]).invoke(this.real, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Markers getMarkers() {
            try {
                return new Markers(this.sourceFileGetMarkersMethod().invoke(this.real, new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public SourceFile withMarkers(Markers markers) {
            try {
                return new SourceFile(this.sourceFileWithMarkersMethod().invoke(this.real, markers.real));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private Method sourceFileGetMarkersMethod() {
            if (RewriteReflectiveFacade.this.sourceFileGetMarkers == null) {
                try {
                    Class<?> sourceFileClass = RewriteReflectiveFacade.this.getClassLoader().loadClass("org.openrewrite.SourceFile");
                    RewriteReflectiveFacade.this.sourceFileGetMarkers = sourceFileClass.getMethod("getMarkers", new Class[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return RewriteReflectiveFacade.this.sourceFileGetMarkers;
        }

        private Method sourceFileWithMarkersMethod() {
            if (RewriteReflectiveFacade.this.sourceFileWithMarkers == null) {
                try {
                    Class<?> sourceFileClass = RewriteReflectiveFacade.this.getClassLoader().loadClass("org.openrewrite.SourceFile");
                    RewriteReflectiveFacade.this.sourceFileWithMarkers = sourceFileClass.getMethod("withMarkers", RewriteReflectiveFacade.this.getClassLoader().loadClass("org.openrewrite.marker.Markers"));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return RewriteReflectiveFacade.this.sourceFileWithMarkers;
        }
    }

    public class Markers {
        final Object real;

        public Markers(Object real) {
            this.real = real;
        }

        public <M extends Marker> Markers addIfAbsent(M m) {
            try {
                Object newReal = this.markersAddIfAbsentMethod().invoke(this.real, m.getReal());
                return newReal == this.real ? this : new Markers(newReal);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private Method markersAddIfAbsentMethod() {
            if (RewriteReflectiveFacade.this.markersAddIfAbsent == null) {
                try {
                    Class<?> sourceFileClass = RewriteReflectiveFacade.this.getClassLoader().loadClass("org.openrewrite.marker.Markers");
                    RewriteReflectiveFacade.this.markersAddIfAbsent = sourceFileClass.getMethod("addIfAbsent", RewriteReflectiveFacade.this.getClassLoader().loadClass("org.openrewrite.marker.Marker"));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return RewriteReflectiveFacade.this.markersAddIfAbsent;
        }
    }

    public static interface Marker {
        public Object getReal();
    }

    public class EnvironmentBuilder {
        private final Object real;

        private EnvironmentBuilder(Object real) {
            this.real = real;
        }

        public EnvironmentBuilder scanRuntimeClasspath(String ... acceptPackages) {
            try {
                this.real.getClass().getMethod("scanRuntimeClasspath", String[].class).invoke(this.real, new Object[]{acceptPackages});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public EnvironmentBuilder scanJar(Path jar, ClassLoader classLoader) {
            try {
                this.real.getClass().getMethod("scanJar", Path.class, ClassLoader.class).invoke(this.real, jar, classLoader);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public EnvironmentBuilder scanJar(Path jar) {
            try {
                this.real.getClass().getMethod("scanJar", Path.class, ClassLoader.class).invoke(this.real, jar, RewriteReflectiveFacade.this.classLoader);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public EnvironmentBuilder scanUserHome() {
            try {
                this.real.getClass().getMethod("scanUserHome", new Class[0]).invoke(this.real, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public EnvironmentBuilder load(YamlResourceLoader yamlResourceLoader) {
            try {
                Class<?> resourceLoaderClass = RewriteReflectiveFacade.this.getClassLoader().loadClass("org.openrewrite.config.ResourceLoader");
                this.real.getClass().getMethod("load", resourceLoaderClass).invoke(this.real, yamlResourceLoader.real);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Environment build() {
            try {
                return new Environment(this.real.getClass().getMethod("build", new Class[0]).invoke(this.real, new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

