/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.gradle.api.Project;
import org.gradle.api.plugins.quality.CodeQualityExtension;

public class RewriteExtension
extends CodeQualityExtension {
    private static final String magicalMetricsLogString = "LOG";
    private final List<String> activeRecipes = new ArrayList<String>();
    private final List<String> activeStyles = new ArrayList<String>();
    private boolean configFileSetDeliberately = false;
    private final Project project;
    private File configFile;
    Provider<File> checkstyleConfigProvider;
    Provider<Map<String, Object>> checkstylePropertiesProvider;
    private File checkstyleConfigFile;
    private String metricsUri = "LOG";
    @Nullable
    private String rewriteVersion;
    @Nullable
    private Properties versionProps;
    private boolean logCompilationWarningsAndErrors;
    private boolean failOnInvalidActiveRecipes = false;
    private boolean failOnDryRunResults = false;

    public RewriteExtension(Project project) {
        this.project = project;
        this.configFile = project.getRootProject().file((Object)"rewrite.yml");
    }

    public void setConfigFile(File configFile) {
        this.configFileSetDeliberately = true;
        this.configFile = configFile;
    }

    public void setConfigFile(String configFilePath) {
        this.configFileSetDeliberately = true;
        this.configFile = this.project.file((Object)configFilePath);
    }

    public void setCheckstyleConfigFile(File configFile) {
        this.checkstyleConfigFile = configFile;
    }

    @Nullable
    public File getCheckstyleConfigFile() {
        if (this.checkstyleConfigFile == null && this.checkstyleConfigProvider != null) {
            return (File)this.checkstyleConfigProvider.get();
        }
        return this.checkstyleConfigFile;
    }

    public Map<String, Object> getCheckstyleProperties() {
        if (this.checkstyleConfigProvider == null) {
            return Collections.emptyMap();
        }
        return (Map)this.checkstylePropertiesProvider.get();
    }

    boolean getConfigFileSetDeliberately() {
        return this.configFileSetDeliberately;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void enableRouteMetricsToLog() {
        this.metricsUri = magicalMetricsLogString;
    }

    public boolean isRouteMetricsToLog() {
        return this.metricsUri.equals(magicalMetricsLogString);
    }

    public String getMetricsUri() {
        return this.metricsUri;
    }

    public void setMetricsUri(String value) {
        this.metricsUri = value;
    }

    public void activeRecipe(String ... recipes) {
        this.activeRecipes.addAll(Arrays.asList(recipes));
    }

    public void clearActiveRecipes() {
        this.activeRecipes.clear();
    }

    public void setActiveRecipes(List<String> activeRecipes) {
        this.activeRecipes.clear();
        this.activeRecipes.addAll(activeRecipes);
    }

    public void activeStyle(String ... styles) {
        this.activeStyles.addAll(Arrays.asList(styles));
    }

    public void clearActiveStyles() {
        this.activeStyles.clear();
    }

    public void setActiveStyles(List<String> activeStyles) {
        this.activeRecipes.clear();
        this.activeRecipes.addAll(activeStyles);
    }

    public List<String> getActiveStyles() {
        return this.activeStyles;
    }

    public List<String> getActiveRecipes() {
        return this.activeRecipes;
    }

    private Properties getVersionProps() {
        if (this.versionProps == null) {
            try (InputStream is = RewriteExtension.class.getResourceAsStream("/versions.properties");){
                this.versionProps = new Properties();
                this.versionProps.load(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.versionProps;
    }

    public String getRewriteVersion() {
        if (this.rewriteVersion == null) {
            return this.getVersionProps().getProperty("org.openrewrite:rewrite-core");
        }
        return this.rewriteVersion;
    }

    public String getCheckstyleToolsVersion() {
        return this.getVersionProps().getProperty("com.puppycrawl.tools:checkstyle");
    }

    public void setRewriteVersion(String value) {
        this.rewriteVersion = value;
    }

    public boolean getFailOnInvalidActiveRecipes() {
        return this.failOnInvalidActiveRecipes;
    }

    public void setFailOnInvalidActiveRecipes(boolean failOnInvalidActiveRecipes) {
        this.failOnInvalidActiveRecipes = failOnInvalidActiveRecipes;
    }

    public boolean getFailOnDryRunResults() {
        return this.failOnDryRunResults;
    }

    public void setFailOnDryRunResults(boolean failOnDryRunResults) {
        this.failOnDryRunResults = failOnDryRunResults;
    }

    public boolean getLogCompilationWarningsAndErrors() {
        return this.logCompilationWarningsAndErrors;
    }

    public void setLogCompilationWarningsAndErrors(boolean logCompilationWarningsAndErrors) {
        this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
    }
}

