/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.util.GradleVersion;
import org.openrewrite.gradle.RewriteExtension;
import org.openrewrite.gradle.RewriteReflectiveFacade;
import org.openrewrite.gradle.RewriteTask;

public abstract class AbstractRewriteTask
extends DefaultTask
implements RewriteTask {
    private Configuration configuration;
    private List<Project> projects;
    private RewriteExtension extension;
    private RewriteReflectiveFacade rewrite;
    private static final String LOG_INDENT_INCREMENT = "    ";
    private static final int HOURS_PER_DAY = 24;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;

    AbstractRewriteTask setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    AbstractRewriteTask setProjects(List<Project> projects) {
        this.projects = projects;
        return this;
    }

    AbstractRewriteTask setExtension(RewriteExtension extension) {
        this.extension = extension;
        return this;
    }

    @Internal
    RewriteExtension getExtension() {
        return this.extension;
    }

    @Internal
    RewriteReflectiveFacade getRewrite() {
        if (this.rewrite == null) {
            this.rewrite = new RewriteReflectiveFacade(this.configuration, this.extension, this);
        }
        return this.rewrite;
    }

    @Internal
    protected abstract Logger getLog();

    @Input
    public SortedSet<String> getActiveRecipes() {
        String activeRecipeProp = System.getProperty("activeRecipe");
        if (activeRecipeProp == null) {
            return new TreeSet<String>(this.extension.getActiveRecipes());
        }
        return new TreeSet<String>(Collections.singleton(activeRecipeProp));
    }

    @Input
    public SortedSet<String> getActiveStyles() {
        return new TreeSet<String>(this.extension.getActiveStyles());
    }

    protected RewriteReflectiveFacade.Environment environment() {
        RewriteReflectiveFacade.EnvironmentBuilder env;
        block10: {
            Map<Object, Object> gradleProps = this.getProject().getProperties().entrySet().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Properties properties = new Properties();
            properties.putAll(gradleProps);
            env = this.getRewrite().environmentBuilder(properties).scanRuntimeClasspath(new String[0]).scanUserHome();
            List recipeJars = this.configuration.getFiles().stream().map(File::toPath).collect(Collectors.toList());
            for (Path rewriteJar : recipeJars) {
                env.scanJar(rewriteJar);
            }
            File rewriteConfig = this.extension.getConfigFile();
            if (rewriteConfig.exists()) {
                try (FileInputStream is = new FileInputStream(rewriteConfig);){
                    RewriteReflectiveFacade.YamlResourceLoader resourceLoader = this.getRewrite().yamlResourceLoader(is, rewriteConfig.toURI(), properties);
                    env.load(resourceLoader);
                    break block10;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to load rewrite configuration", e);
                }
            }
            if (this.extension.getConfigFileSetDeliberately()) {
                this.getLog().warn("Rewrite configuration file " + rewriteConfig + " does not exist.");
            }
        }
        return env.build();
    }

    protected RewriteReflectiveFacade.InMemoryExecutionContext executionContext() {
        return this.getRewrite().inMemoryExecutionContext(t -> this.getLog().warn(t.getMessage(), t));
    }

    protected ResultsContainer listResults() {
        Path baseDir = this.getProject().getRootProject().getRootDir().toPath();
        RewriteReflectiveFacade.Environment env = this.environment();
        SortedSet<String> activeRecipes = this.getActiveRecipes();
        SortedSet<String> activeStyles = this.getActiveStyles();
        this.getLog().lifecycle(String.format("Using active recipe(s) %s", activeRecipes));
        this.getLog().lifecycle(String.format("Using active styles(s) %s", activeStyles));
        if (activeRecipes.isEmpty()) {
            return new ResultsContainer(baseDir, Collections.emptyList());
        }
        List<RewriteReflectiveFacade.NamedStyles> styles = env.activateStyles(activeStyles);
        File checkstyleConfig = this.extension.getCheckstyleConfigFile();
        if (checkstyleConfig != null && checkstyleConfig.exists()) {
            RewriteReflectiveFacade.NamedStyles checkstyle = this.getRewrite().loadCheckstyleConfig(checkstyleConfig.toPath(), this.extension.getCheckstyleProperties());
            styles.add(checkstyle);
        }
        RewriteReflectiveFacade.Recipe recipe = env.activateRecipes(activeRecipes);
        this.getLog().lifecycle("Validating active recipes");
        Collection<RewriteReflectiveFacade.Validated> validated = recipe.validateAll();
        List<RewriteReflectiveFacade.Validated.Invalid> failedValidations = validated.stream().map(RewriteReflectiveFacade.Validated::failures).flatMap(Collection::stream).collect(Collectors.toList());
        if (!failedValidations.isEmpty()) {
            failedValidations.forEach(failedValidation -> this.getLog().error("Recipe validation error in " + failedValidation.getProperty() + ": " + failedValidation.getMessage(), failedValidation.getException()));
            if (this.getExtension().getFailOnInvalidActiveRecipes()) {
                throw new RuntimeException("Recipe validation errors detected as part of one or more activeRecipe(s). Please check error logs.");
            }
            this.getLog().error("Recipe validation errors detected as part of one or more activeRecipe(s). Execution will continue regardless.");
        }
        RewriteReflectiveFacade.InMemoryExecutionContext ctx = this.executionContext();
        List<RewriteReflectiveFacade.SourceFile> sourceFiles = this.projects.stream().flatMap(p -> this.parse((Project)p, styles, ctx).stream()).collect(Collectors.toList());
        this.getLog().lifecycle("Running recipe(s)...");
        List<RewriteReflectiveFacade.Result> results = recipe.run(sourceFiles);
        return new ResultsContainer(baseDir, results);
    }

    protected List<RewriteReflectiveFacade.SourceFile> parse(Project subproject, List<RewriteReflectiveFacade.NamedStyles> styles, RewriteReflectiveFacade.InMemoryExecutionContext ctx) {
        try {
            Duration duration;
            Instant end;
            Instant start;
            SourceSetContainer sourceSets;
            Path baseDir = this.getProject().getRootProject().getRootDir().toPath();
            JavaPluginConvention javaConvention = (JavaPluginConvention)subproject.getConvention().findPlugin(JavaPluginConvention.class);
            RewriteReflectiveFacade.JavaProvenanceBuilder sharedProvenance = this.getRewrite().javaProvenanceBuilder().projectName(this.getProject().getName()).buildToolVersion(GradleVersion.current().getVersion()).vmRuntimeVersion(System.getProperty("java.runtime.version")).vmVendor(System.getProperty("java.vm.vendor")).classpath(new HashSet<Path>());
            if (javaConvention == null) {
                sourceSets = Collections.emptySet();
            } else {
                sourceSets = javaConvention.getSourceSets();
                sharedProvenance.sourceCompatibility(javaConvention.getSourceCompatibility().toString()).targetCompatibility(javaConvention.getTargetCompatibility().toString());
            }
            ArrayList<RewriteReflectiveFacade.SourceFile> sourceFiles = new ArrayList<RewriteReflectiveFacade.SourceFile>();
            for (SourceSet sourceSet : sourceSets) {
                List<Path> javaPaths = sourceSet.getAllJava().getFiles().stream().filter(it -> it.isFile() && it.getName().endsWith(".java")).map(File::toPath).map(AbstractRewriteTask::toRealPath).collect(Collectors.toList());
                List<Path> dependencyPaths = sourceSet.getCompileClasspath().getFiles().stream().map(File::toPath).map(AbstractRewriteTask::toRealPath).collect(Collectors.toList());
                RewriteReflectiveFacade.JavaProvenance javaProvenance = this.getRewrite().javaProvenanceBuilder(sharedProvenance).sourceSetName(sourceSet.getName()).classpath(dependencyPaths).build();
                if (javaPaths.size() <= 0) continue;
                this.getLog().lifecycle("Parsing " + javaPaths.size() + " Java files from " + sourceSet.getAllJava().getSourceDirectories().getAsPath());
                Instant start2 = Instant.now();
                sourceFiles.addAll(AbstractRewriteTask.map(this.getRewrite().javaParserFromJavaVersion().relaxedClassTypeMatching(true).styles(styles).classpath(dependencyPaths).logCompilationWarningsAndErrors(this.extension.getLogCompilationWarningsAndErrors()).build().parse(javaPaths, baseDir, ctx), s -> s.withMarkers(s.getMarkers().addIfAbsent(javaProvenance))));
                Instant end2 = Instant.now();
                Duration duration2 = Duration.between(start2, end2);
                this.getLog().lifecycle("Parsed " + javaPaths.size() + " Java files in " + AbstractRewriteTask.prettyPrint(duration2) + " (" + AbstractRewriteTask.prettyPrint(duration2.dividedBy(javaPaths.size())) + " per file)");
            }
            RewriteReflectiveFacade.JavaProvenance sourceSetAgnosticProvenance = sharedProvenance.build();
            ArrayList<Path> yamlPaths = new ArrayList<Path>();
            ArrayList<Path> propertiesPaths = new ArrayList<Path>();
            ArrayList xmlPaths = new ArrayList();
            Files.walk(subproject.getProjectDir().toPath(), new FileVisitOption[0]).forEach(file -> {
                String fileName = file.toString().toLowerCase();
                if (fileName.endsWith(".yml") || fileName.endsWith(".yaml")) {
                    yamlPaths.add((Path)file);
                } else if (fileName.endsWith(".properties")) {
                    propertiesPaths.add((Path)file);
                } else if (fileName.endsWith(".xml")) {
                    xmlPaths.add(file);
                }
            });
            if (yamlPaths.size() > 0) {
                this.getLog().lifecycle("Parsing " + yamlPaths.size() + " YAML files from " + subproject.getProjectDir());
                start = Instant.now();
                sourceFiles.addAll(AbstractRewriteTask.map(this.getRewrite().yamlParser().parse(yamlPaths, baseDir, ctx), s -> s.withMarkers(s.getMarkers().addIfAbsent(sourceSetAgnosticProvenance))));
                end = Instant.now();
                duration = Duration.between(start, end);
                this.getLog().lifecycle("Parsed " + yamlPaths.size() + " YAML files in " + AbstractRewriteTask.prettyPrint(duration) + " (" + AbstractRewriteTask.prettyPrint(duration.dividedBy(yamlPaths.size())) + " per file)");
            }
            if (propertiesPaths.size() > 0) {
                this.getLog().lifecycle("Parsing " + propertiesPaths.size() + " properties files from " + subproject.getProjectDir());
                start = Instant.now();
                sourceFiles.addAll(AbstractRewriteTask.map(this.getRewrite().propertiesParser().parse(propertiesPaths, baseDir, ctx), s -> s.withMarkers(s.getMarkers().addIfAbsent(sourceSetAgnosticProvenance))));
                end = Instant.now();
                duration = Duration.between(start, end);
                this.getLog().lifecycle("Parsed " + propertiesPaths.size() + " properties files in " + AbstractRewriteTask.prettyPrint(duration) + " (" + AbstractRewriteTask.prettyPrint(duration.dividedBy(propertiesPaths.size())) + " per file)");
            }
            if (xmlPaths.size() > 0) {
                this.getLog().lifecycle("Parsing " + xmlPaths.size() + " XML files from " + subproject.getProjectDir());
                start = Instant.now();
                sourceFiles.addAll(AbstractRewriteTask.map(this.getRewrite().yamlParser().parse(yamlPaths, baseDir, ctx), s -> s.withMarkers(s.getMarkers().addIfAbsent(sourceSetAgnosticProvenance))));
                end = Instant.now();
                duration = Duration.between(start, end);
                this.getLog().lifecycle("Parsed " + xmlPaths.size() + " XML files in " + AbstractRewriteTask.prettyPrint(duration) + " (" + AbstractRewriteTask.prettyPrint(duration.dividedBy(xmlPaths.size())) + " per file)");
            }
            return sourceFiles;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void logRecipesThatMadeChanges(RewriteReflectiveFacade.Result result) {
        for (RewriteReflectiveFacade.Recipe recipe : result.getRecipesThatMadeChanges()) {
            this.getLog().warn(AbstractRewriteTask.indent(1, recipe.getName()));
        }
    }

    private static Path toRealPath(Path path) {
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return path;
        }
    }

    protected static String indent(int indent, CharSequence content) {
        StringBuilder prefix = AbstractRewriteTask.repeat(indent, LOG_INDENT_INCREMENT);
        return prefix.append(content).toString();
    }

    private static StringBuilder repeat(int repeat, String str) {
        StringBuilder buffer = new StringBuilder(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer;
    }

    private static String prettyPrint(Duration duration) {
        StringBuilder result = new StringBuilder();
        long days = duration.getSeconds() / 86400L;
        boolean startedPrinting = false;
        if (days > 0L) {
            startedPrinting = true;
            result.append(days);
            result.append(" day");
            if (days != 1L) {
                result.append("s");
            }
            result.append(" ");
        }
        long hours = duration.toHours() % 24L;
        if (startedPrinting || hours > 0L) {
            startedPrinting = true;
            result.append(hours);
            result.append(" hour");
            if (hours != 1L) {
                result.append("s");
            }
            result.append(" ");
        }
        long minutes = duration.getSeconds() / 60L % 60L;
        if (startedPrinting || minutes > 0L) {
            result.append(minutes);
            result.append(" minute");
            if (minutes != 1L) {
                result.append("s");
            }
            result.append(" ");
        }
        long seconds = duration.getSeconds() % 60L;
        if (startedPrinting || seconds > 0L) {
            result.append(seconds);
            result.append(" second");
            if (seconds != 1L) {
                result.append("s");
            }
            result.append(" ");
        }
        long millis = duration.getNano() / 1000000;
        result.append(millis);
        result.append(" millisecond");
        if (millis != 1L) {
            result.append("s");
        }
        return result.toString();
    }

    public static <T> List<T> map(List<T> ls, UnaryOperator<T> map) {
        if (ls == null || ls.isEmpty()) {
            return ls;
        }
        List<T> newLs = ls;
        for (int i = 0; i < ls.size(); ++i) {
            T tree = ls.get(i);
            Object newTree = map.apply(tree);
            if (newTree == tree) continue;
            if (newLs == ls) {
                newLs = new ArrayList<T>(ls);
            }
            newLs.set(i, newTree);
        }
        if (newLs != ls) {
            while (newLs.remove(null)) {
            }
        }
        return newLs;
    }

    public static class ResultsContainer {
        final Path projectRoot;
        final List<RewriteReflectiveFacade.Result> generated = new ArrayList<RewriteReflectiveFacade.Result>();
        final List<RewriteReflectiveFacade.Result> deleted = new ArrayList<RewriteReflectiveFacade.Result>();
        final List<RewriteReflectiveFacade.Result> moved = new ArrayList<RewriteReflectiveFacade.Result>();
        final List<RewriteReflectiveFacade.Result> refactoredInPlace = new ArrayList<RewriteReflectiveFacade.Result>();

        public ResultsContainer(Path projectRoot, Collection<RewriteReflectiveFacade.Result> results) {
            this.projectRoot = projectRoot;
            for (RewriteReflectiveFacade.Result result : results) {
                if (result.getBefore() == null && result.getAfter() == null) continue;
                if (result.getBefore() == null && result.getAfter() != null) {
                    this.generated.add(result);
                    continue;
                }
                if (result.getBefore() != null && result.getAfter() == null) {
                    this.deleted.add(result);
                    continue;
                }
                if (result.getBefore() != null && !result.getBefore().getSourcePath().equals(result.getAfter().getSourcePath())) {
                    this.moved.add(result);
                    continue;
                }
                this.refactoredInPlace.add(result);
            }
        }

        public Path getProjectRoot() {
            return this.projectRoot;
        }

        public boolean isNotEmpty() {
            return !this.generated.isEmpty() || !this.deleted.isEmpty() || !this.moved.isEmpty() || !this.refactoredInPlace.isEmpty();
        }
    }
}

