/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.sync;

import org.jupnp.UpnpService;
import org.jupnp.model.gena.LocalGENASubscription;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.gena.IncomingUnsubscribeRequestMessage;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.resource.ServiceEventSubscriptionResource;
import org.jupnp.protocol.ReceivingSync;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingUnsubscribe
extends ReceivingSync<StreamRequestMessage, StreamResponseMessage> {
    private final Logger log = LoggerFactory.getLogger(ReceivingUnsubscribe.class);

    public ReceivingUnsubscribe(UpnpService upnpService, StreamRequestMessage inputMessage) {
        super(upnpService, inputMessage);
    }

    @Override
    protected StreamResponseMessage executeSync() throws RouterException {
        ServiceEventSubscriptionResource resource = this.getUpnpService().getRegistry().getResource(ServiceEventSubscriptionResource.class, ((StreamRequestMessage)this.getInputMessage()).getUri());
        if (resource == null) {
            this.log.trace("No local resource found: " + this.getInputMessage());
            return null;
        }
        this.log.trace("Found local event subscription matching relative request URI: " + ((StreamRequestMessage)this.getInputMessage()).getUri());
        IncomingUnsubscribeRequestMessage requestMessage = new IncomingUnsubscribeRequestMessage((StreamRequestMessage)this.getInputMessage(), (LocalService)resource.getModel());
        if (requestMessage.getSubscriptionId() != null && (requestMessage.hasNotificationHeader() || requestMessage.hasCallbackHeader())) {
            this.log.trace("Subscription ID and NT or Callback in unsubcribe request: " + this.getInputMessage());
            return new StreamResponseMessage(UpnpResponse.Status.BAD_REQUEST);
        }
        LocalGENASubscription subscription = this.getUpnpService().getRegistry().getLocalSubscription(requestMessage.getSubscriptionId());
        if (subscription == null) {
            this.log.trace("Invalid subscription ID for unsubscribe request: " + this.getInputMessage());
            return new StreamResponseMessage(UpnpResponse.Status.PRECONDITION_FAILED);
        }
        this.log.trace("Unregistering subscription: " + subscription);
        if (this.getUpnpService().getRegistry().removeLocalSubscription(subscription)) {
            subscription.end(null);
        } else {
            this.log.trace("Subscription was already removed from registry");
        }
        return new StreamResponseMessage(UpnpResponse.Status.OK);
    }
}

