/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.dlna;

import java.util.EnumSet;
import java.util.Locale;
import org.jupnp.support.model.dlna.DLNAAttribute;
import org.jupnp.support.model.dlna.DLNAFlags;
import org.jupnp.support.model.dlna.InvalidDLNAProtocolAttributeException;

public class DLNAFlagsAttribute
extends DLNAAttribute<EnumSet<DLNAFlags>> {
    public DLNAFlagsAttribute() {
        this.setValue(EnumSet.noneOf(DLNAFlags.class));
    }

    public DLNAFlagsAttribute(DLNAFlags ... flags) {
        if (flags != null && flags.length > 0) {
            DLNAFlags first = flags[0];
            if (flags.length > 1) {
                System.arraycopy(flags, 1, flags, 0, flags.length - 1);
                this.setValue(EnumSet.of(first, flags));
            } else {
                this.setValue(EnumSet.of(first));
            }
        }
    }

    @Override
    public void setString(String s, String cf) {
        EnumSet<DLNAFlags> value = EnumSet.noneOf(DLNAFlags.class);
        try {
            int parseInt = Integer.parseInt(s.substring(0, s.length() - 24), 16);
            DLNAFlags[] dLNAFlagsArray = DLNAFlags.values();
            int n = dLNAFlagsArray.length;
            int n2 = 0;
            while (n2 < n) {
                DLNAFlags op = dLNAFlagsArray[n2];
                int code = op.getCode() & parseInt;
                if (op.getCode() == code) {
                    value.add(op);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value.isEmpty()) {
            throw new InvalidDLNAProtocolAttributeException("Can't parse DLNA flags integer from: " + s);
        }
        this.setValue(value);
    }

    @Override
    public String getString() {
        int code = 0;
        for (DLNAFlags op : (EnumSet)this.getValue()) {
            code |= op.getCode();
        }
        return String.format(Locale.ROOT, "%08x%024x", code, 0);
    }
}

