/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model;

import java.util.ArrayList;
import org.jupnp.model.ModelUtil;

public enum RecordQualityMode {
    EP("0:EP"),
    LP("1:LP"),
    SP("2:SP"),
    BASIC("0:BASIC"),
    MEDIUM("1:MEDIUM"),
    HIGH("2:HIGH"),
    NOT_IMPLEMENTED("NOT_IMPLEMENTED");

    private String protocolString;

    private RecordQualityMode(String protocolString) {
        this.protocolString = protocolString;
    }

    public String toString() {
        return this.protocolString;
    }

    public static RecordQualityMode valueOrExceptionOf(String s) {
        RecordQualityMode[] recordQualityModeArray = RecordQualityMode.values();
        int n = recordQualityModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RecordQualityMode recordQualityMode = recordQualityModeArray[n2];
            if (recordQualityMode.protocolString.equals(s)) {
                return recordQualityMode;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Invalid record quality mode string: " + s);
    }

    public static RecordQualityMode[] valueOfCommaSeparatedList(String s) {
        String[] strings = ModelUtil.fromCommaSeparatedList((String)s);
        if (strings == null) {
            return new RecordQualityMode[0];
        }
        ArrayList<RecordQualityMode> result = new ArrayList<RecordQualityMode>();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String rqm = stringArray[n2];
            RecordQualityMode[] recordQualityModeArray = RecordQualityMode.values();
            int n3 = recordQualityModeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                RecordQualityMode recordQualityMode = recordQualityModeArray[n4];
                if (recordQualityMode.protocolString.equals(rqm)) {
                    result.add(recordQualityMode);
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new RecordQualityMode[result.size()]);
    }
}

