/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.task.helper;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.tools.ant.util.FileUtils;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.MavenPluginConvention;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.Upload;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.gradle.plugin.artifactory.ArtifactoryPluginUtil;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleDeployDetails;
import org.jfrog.gradle.plugin.artifactory.extractor.PublishArtifactInfo;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;
import org.jfrog.gradle.plugin.artifactory.task.helper.TaskHelper;

public class TaskHelperConfigurations
extends TaskHelper {
    private static final Logger log = Logging.getLogger(TaskHelperConfigurations.class);
    public static final String ARCHIVES_BASE_NAME = "archivesBaseName";
    private Set<Configuration> publishConfigurations;
    private boolean publishConfigsSpecified;
    private Set<Object> configurations = new HashSet<Object>();

    public TaskHelperConfigurations(ArtifactoryTask artifactoryTask) {
        super(artifactoryTask);
        this.publishConfigurations = artifactoryTask.publishConfigs;
    }

    @Override
    public void addCollection(Object ... objects) {
        Collections.addAll(this.configurations, objects);
    }

    private void publishConfigs() {
        if (this.configurations == null || this.configurations.size() == 0) {
            return;
        }
        for (Object conf : this.configurations) {
            if (conf instanceof CharSequence) {
                Configuration projectConfig = (Configuration)this.getProject().getConfigurations().findByName(conf.toString());
                if (projectConfig != null) {
                    this.publishConfigurations.add(projectConfig);
                    continue;
                }
                this.logConfigurationNotFound(conf.toString());
                continue;
            }
            if (conf instanceof Configuration) {
                this.publishConfigurations.add((Configuration)conf);
                continue;
            }
            log.error("Configuration type '{}' not supported in task '{}'.", new Object[]{conf.getClass().getName(), this.getPath()});
        }
        this.publishConfigsSpecified = true;
    }

    private void logConfigurationNotFound(String configName) {
        log.debug("Configuration named '{}' does not exist for project '{}' in task '{}'.", new Object[]{configName, this.getProject().getPath(), this.getPath()});
    }

    public Set<Configuration> getPublishConfigurations() {
        return this.publishConfigurations;
    }

    public boolean hasConfigurations() {
        return !this.publishConfigurations.isEmpty();
    }

    public void collectDescriptorsAndArtifactsForUpload() throws IOException {
        Set<GradleDeployDetails> deployDetailsFromProject = this.getArtifactDeployDetails();
        this.artifactoryTask.deployDetails.addAll(deployDetailsFromProject);
        if (this.isPublishIvy().booleanValue() && this.artifactoryTask.ivyDescriptor != null && this.artifactoryTask.ivyDescriptor.exists()) {
            this.artifactoryTask.deployDetails.add(this.getIvyDescriptorDeployDetails());
        }
        if (this.isPublishMaven().booleanValue() && this.artifactoryTask.mavenDescriptor != null && this.artifactoryTask.mavenDescriptor.exists()) {
            this.artifactoryTask.deployDetails.add(this.getMavenDeployDetails());
        }
    }

    public void checkDependsOnArtifactsToPublish() {
        this.publishConfigs();
        if (!this.hasConfigurations()) {
            return;
        }
        for (Configuration publishConfiguration : this.publishConfigurations) {
            this.dependsOn(publishConfiguration.getArtifacts());
        }
        if (this.isPublishIvy().booleanValue()) {
            if (this.artifactoryTask.ivyDescriptor == null) {
                this.setDefaultIvyDescriptor();
            }
        } else {
            this.artifactoryTask.ivyDescriptor = null;
        }
        if (this.isPublishMaven().booleanValue()) {
            if (this.artifactoryTask.mavenDescriptor == null) {
                this.setDefaultMavenDescriptor();
            }
        } else {
            this.artifactoryTask.mavenDescriptor = null;
        }
    }

    public boolean hasModules() {
        return this.hasConfigurations();
    }

    protected void setDefaultIvyDescriptor() {
        Project project = this.getProject();
        TaskContainer tasks = project.getTasks();
        Configuration archiveConfig = (Configuration)project.getConfigurations().findByName("archives");
        if (archiveConfig == null) {
            log.warn("Cannot publish Ivy descriptor if ivyDescriptor not set in task '{}' and no '{}' configuration exists in project '{}'.", (Object)"archives", (Object)project.getPath());
        } else {
            Task candidateUploadTask = (Task)tasks.findByName(archiveConfig.getUploadTaskName());
            if (candidateUploadTask == null) {
                log.warn("Cannot publish Ivy descriptor if ivyDescriptor not set in task '{}' and task '{}' does not exist.\nAdding \"apply plugin: 'java'\" or any other plugin extending the 'base' pluginwill solve this issue.", new Object[]{this.getPath(), archiveConfig.getUploadTaskName()});
            } else if (!(candidateUploadTask instanceof Upload)) {
                log.warn("Cannot publish Ivy descriptor if ivyDescriptor not set in task '{}' and task '{}' is not an Upload task.\nYou'll need to set publishIvy=false or provide a path to the ivy file to publish to solve this issue.", new Object[]{this.getPath(), archiveConfig.getUploadTaskName()});
            } else {
                Upload uploadTask = (Upload)candidateUploadTask;
                if (!uploadTask.isUploadDescriptor()) {
                    log.info("Forcing task '{}' to upload its Ivy descriptor (uploadDescriptor was false).", (Object)uploadTask.getPath());
                    uploadTask.setUploadDescriptor(true);
                }
                this.artifactoryTask.ivyDescriptor = uploadTask.getDescriptorDestination();
                this.dependsOn(candidateUploadTask);
            }
        }
    }

    protected void setDefaultMavenDescriptor() {
        Project project = this.getProject();
        TaskContainer tasks = project.getTasks();
        Upload installTask = (Upload)tasks.withType(Upload.class).findByName("install");
        if (installTask == null) {
            log.warn("Cannot publish pom for project '{}' since it does not contain the Maven plugin install task and task '{}' does not specify a custom pom path.", new Object[]{project.getPath(), this.getPath()});
            this.artifactoryTask.mavenDescriptor = null;
        } else {
            this.artifactoryTask.mavenDescriptor = new File(((MavenPluginConvention)project.getConvention().getPlugin(MavenPluginConvention.class)).getMavenPomDir(), "pom-default.xml");
            this.dependsOn(installTask);
        }
    }

    protected Set<GradleDeployDetails> getArtifactDeployDetails() {
        LinkedHashSet deployDetails = Sets.newLinkedHashSet();
        if (!this.hasConfigurations()) {
            log.info("No configurations to publish for project '{}'.", (Object)this.getProject().getPath());
            return deployDetails;
        }
        HashSet processedFiles = Sets.newHashSet();
        for (Configuration configuration : this.publishConfigurations) {
            PublishArtifactSet artifacts = configuration.getAllArtifacts();
            for (PublishArtifact artifact : artifacts) {
                GradleDeployDetails gdd = this.gradleDeployDetails(artifact, configuration.getName(), processedFiles);
                if (gdd == null) continue;
                deployDetails.add(gdd);
            }
        }
        return deployDetails;
    }

    public boolean AddDefaultArchiveConfiguration(Project project) {
        if (!this.hasConfigurations()) {
            if (this.publishConfigsSpecified) {
                log.warn("None of the specified publish configurations matched for project '{}' - nothing to publish.", (Object)project.getPath());
                return true;
            }
            Configuration archiveConfig = (Configuration)project.getConfigurations().findByName("archives");
            if (archiveConfig != null) {
                log.info("No publish configurations specified for project '{}' - using the default '{}' configuration.", (Object)project.getPath(), (Object)"archives");
                this.publishConfigurations.add(archiveConfig);
                this.checkDependsOnArtifactsToPublish();
            } else {
                log.warn("No publish configurations specified for project '{}' and the default '{}' configuration does not exist.", (Object)project.getPath(), (Object)"archives");
                return true;
            }
        }
        return false;
    }

    private GradleDeployDetails getIvyDescriptorDeployDetails() {
        ArtifactoryClientConfiguration.PublisherHandler publisher = ArtifactoryPluginUtil.getPublisherHandler(this.getProject());
        DeployDetails.Builder artifactBuilder = new DeployDetails.Builder().file(this.artifactoryTask.ivyDescriptor);
        try {
            Map checksums = FileChecksumCalculator.calculateChecksums((File)this.artifactoryTask.ivyDescriptor, (String[])new String[]{"MD5", "SHA1"});
            artifactBuilder.md5((String)checksums.get("MD5")).sha1((String)checksums.get("SHA1"));
        }
        catch (Exception e) {
            throw new GradleException("Failed to calculate checksums for artifact: " + this.artifactoryTask.ivyDescriptor.getAbsolutePath(), (Throwable)e);
        }
        String gid = this.getProject().getGroup().toString();
        if (publisher.isM2Compatible()) {
            gid = gid.replace(".", "/");
        }
        artifactBuilder.artifactPath(IvyPatternHelper.substitute((String)publisher.getIvyPattern(), (String)gid, (String)this.getModuleName(), (String)this.getProject().getVersion().toString(), null, (String)"ivy", (String)"xml"));
        artifactBuilder.targetRepository(publisher.getRepoKey());
        PublishArtifactInfo artifactInfo = new PublishArtifactInfo(this.artifactoryTask.ivyDescriptor.getName(), "xml", "ivy", null, this.artifactoryTask.ivyDescriptor);
        Map<String, String> propsToAdd = this.getPropsToAdd(artifactInfo, null);
        artifactBuilder.addProperties(propsToAdd);
        return new GradleDeployDetails(artifactInfo, artifactBuilder.build(), this.getProject());
    }

    private GradleDeployDetails getMavenDeployDetails() {
        ArtifactoryClientConfiguration.PublisherHandler publisher = ArtifactoryPluginUtil.getPublisherHandler(this.getProject());
        DeployDetails.Builder artifactBuilder = new DeployDetails.Builder().file(this.artifactoryTask.mavenDescriptor);
        try {
            Map checksums = FileChecksumCalculator.calculateChecksums((File)this.artifactoryTask.mavenDescriptor, (String[])new String[]{"MD5", "SHA1"});
            artifactBuilder.md5((String)checksums.get("MD5")).sha1((String)checksums.get("SHA1"));
        }
        catch (Exception e) {
            throw new GradleException("Failed to calculate checksums for artifact: " + this.artifactoryTask.mavenDescriptor.getAbsolutePath(), (Throwable)e);
        }
        artifactBuilder.artifactPath(IvyPatternHelper.substitute((String)"[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]", (String)this.getProject().getGroup().toString().replace(".", "/"), (String)this.getModuleName(), (String)this.getProject().getVersion().toString(), null, (String)"pom", (String)"pom"));
        artifactBuilder.targetRepository(publisher.getRepoKey());
        PublishArtifactInfo artifactInfo = new PublishArtifactInfo(this.artifactoryTask.mavenDescriptor.getName(), "pom", "pom", null, this.artifactoryTask.mavenDescriptor);
        Map<String, String> propsToAdd = this.getPropsToAdd(artifactInfo, null);
        artifactBuilder.addProperties(propsToAdd);
        return new GradleDeployDetails(artifactInfo, artifactBuilder.build(), this.getProject());
    }

    public GradleDeployDetails gradleDeployDetails(PublishArtifact artifact, String configuration) {
        return this.gradleDeployDetails(artifact, configuration, null, null);
    }

    public GradleDeployDetails gradleDeployDetails(PublishArtifact artifact, String configuration, @Nullable String artifactPath) {
        return this.gradleDeployDetails(artifact, configuration, artifactPath, null);
    }

    public void setIvyDescriptor(Object ivyDescriptor) {
        if (ivyDescriptor != null) {
            if (ivyDescriptor instanceof File) {
                this.artifactoryTask.ivyDescriptor = (File)ivyDescriptor;
            } else if (ivyDescriptor instanceof CharSequence) {
                this.artifactoryTask.ivyDescriptor = FileUtils.isAbsolutePath((String)ivyDescriptor.toString()) ? new File(ivyDescriptor.toString()) : new File(this.getProject().getProjectDir(), ivyDescriptor.toString());
            } else {
                log.warn("Unknown type '{}' for ivy descriptor in task '{}'", new Object[]{ivyDescriptor.getClass().getName(), this.getPath()});
            }
        } else {
            this.artifactoryTask.ivyDescriptor = null;
        }
    }

    public void setMavenDescriptor(Object mavenDescriptor) {
        if (mavenDescriptor != null) {
            if (mavenDescriptor instanceof File) {
                this.artifactoryTask.mavenDescriptor = (File)mavenDescriptor;
            } else if (mavenDescriptor instanceof CharSequence) {
                this.artifactoryTask.mavenDescriptor = FileUtils.isAbsolutePath((String)mavenDescriptor.toString()) ? new File(mavenDescriptor.toString()) : new File(this.getProject().getProjectDir(), mavenDescriptor.toString());
            } else {
                log.warn("Unknown type '{}' for maven descriptor in task '{}'", new Object[]{mavenDescriptor.getClass().getName(), this.getPath()});
            }
        } else {
            this.artifactoryTask.mavenDescriptor = null;
        }
    }

    protected String getModuleName() {
        Project project = this.getProject();
        if (project.hasProperty(ARCHIVES_BASE_NAME)) {
            return project.property(ARCHIVES_BASE_NAME).toString();
        }
        return project.getName();
    }

    private GradleDeployDetails gradleDeployDetails(PublishArtifact artifact, String configuration, Set<String> files) {
        return this.gradleDeployDetails(artifact, configuration, null, files);
    }

    private GradleDeployDetails gradleDeployDetails(PublishArtifact artifact, String configuration, @Nullable String artifactPath, @Nullable Set<String> processedFiles) {
        ArtifactoryClientConfiguration.PublisherHandler publisher = ArtifactoryPluginUtil.getPublisherHandler(this.getProject());
        if (publisher == null) {
            return null;
        }
        File file = artifact.getFile();
        if (processedFiles != null && processedFiles.contains(file.getAbsolutePath())) {
            return null;
        }
        if (!file.exists()) {
            throw new GradleException("File '" + file.getAbsolutePath() + "' does not exists, and need to be published!");
        }
        if (processedFiles != null) {
            processedFiles.add(file.getAbsolutePath());
        }
        String revision = this.getProject().getVersion().toString();
        HashMap extraTokens = Maps.newHashMap();
        if (StringUtils.isNotBlank((String)artifact.getClassifier())) {
            extraTokens.put("classifier", artifact.getClassifier());
        }
        String pattern = publisher.getIvyArtifactPattern();
        String gid = this.getProject().getGroup().toString();
        if (publisher.isM2Compatible()) {
            gid = gid.replace(".", "/");
        }
        DeployDetails.Builder deployDetailsBuilder = new DeployDetails.Builder().file(file);
        try {
            Map checksums = FileChecksumCalculator.calculateChecksums((File)file, (String[])new String[]{"MD5", "SHA1"});
            deployDetailsBuilder.md5((String)checksums.get("MD5")).sha1((String)checksums.get("SHA1"));
        }
        catch (Exception e) {
            throw new GradleException("Failed to calculate checksums for artifact: " + file.getAbsolutePath(), (Throwable)e);
        }
        if (artifactPath != null) {
            deployDetailsBuilder.artifactPath(artifactPath);
        } else {
            deployDetailsBuilder.artifactPath(IvyPatternHelper.substitute((String)pattern, (String)gid, (String)this.getModuleName(), (String)revision, (String)artifact.getName(), (String)artifact.getType(), (String)artifact.getExtension(), (String)configuration, (Map)extraTokens, null));
        }
        deployDetailsBuilder.targetRepository(publisher.getRepoKey());
        PublishArtifactInfo artifactInfo = new PublishArtifactInfo(artifact);
        Map<String, String> propsToAdd = this.getPropsToAdd(artifactInfo, configuration);
        deployDetailsBuilder.addProperties(propsToAdd);
        DeployDetails details = deployDetailsBuilder.build();
        return new GradleDeployDetails(artifactInfo, details, this.getProject());
    }
}

