/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.task;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.TaskAction;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployableArtifactsUtils;
import org.jfrog.build.extractor.retention.Utils;
import org.jfrog.gradle.plugin.artifactory.ArtifactoryPluginUtil;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleArtifactoryClientConfigUpdater;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleBuildInfoExtractor;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleClientLogger;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleDeployDetails;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;

public class DeployTask
extends DefaultTask {
    private static final Logger log = Logging.getLogger(DeployTask.class);

    @TaskAction
    public void taskAction() throws IOException {
        log.debug("Task '{}' activated", (Object)this.getPath());
        this.collectProjectBuildInfo();
    }

    private void collectProjectBuildInfo() throws IOException {
        File file;
        log.debug("Starting build info extraction for project '{}' using last task in graph '{}'", new Object[]{this.getProject().getPath(), this.getPath()});
        this.prepareAndDeploy();
        String propertyFilePath = System.getenv("buildInfoConfig.propertiesFile");
        if (StringUtils.isBlank((String)propertyFilePath)) {
            propertyFilePath = System.getenv("BUILDINFO_PROPFILE");
        }
        if (StringUtils.isNotBlank((String)propertyFilePath) && (file = new File(propertyFilePath)).exists()) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAndDeploy() throws IOException {
        block25: {
            ArtifactoryClientConfiguration accRoot = ArtifactoryPluginUtil.getArtifactoryConvention(this.getProject()).getClientConfig();
            Map propsRoot = accRoot.publisher.getProps();
            GradleArtifactoryClientConfigUpdater.setMissingBuildAttributes(accRoot, this.getProject().getRootProject());
            TreeSet allDeployDetails = Sets.newTreeSet();
            List<ArtifactoryTask> orderedTasks = this.findArtifactoryPublishTasks(this.getProject().getGradle().getTaskGraph());
            for (ArtifactoryTask artifactoryTask : orderedTasks) {
                if (artifactoryTask.getDidWork()) {
                    ArtifactoryClientConfiguration.PublisherHandler publisher = ArtifactoryPluginUtil.getPublisherHandler(artifactoryTask.getProject());
                    if (publisher == null || publisher.getContextUrl() == null) continue;
                    HashMap moduleProps = new HashMap(propsRoot);
                    moduleProps.putAll(publisher.getProps());
                    publisher.getProps().putAll(moduleProps);
                    String contextUrl = publisher.getContextUrl();
                    String username = publisher.getUsername();
                    String password = publisher.getPassword();
                    if (StringUtils.isBlank((String)username)) {
                        username = "";
                    }
                    if (StringUtils.isBlank((String)password)) {
                        password = "";
                    }
                    artifactoryTask.collectDescriptorsAndArtifactsForUpload();
                    if (publisher.isPublishArtifacts().booleanValue()) {
                        try (ArtifactoryBuildInfoClient client = null;){
                            client = new ArtifactoryBuildInfoClient(contextUrl, username, password, (Log)new GradleClientLogger(log));
                            log.debug("Uploading artifacts to Artifactory at '{}'", (Object)contextUrl);
                            IncludeExcludePatterns patterns = new IncludeExcludePatterns(publisher.getIncludePatterns(), publisher.getExcludePatterns());
                            this.configureProxy(accRoot, client);
                            this.configConnectionTimeout(accRoot, client);
                            this.configRetriesParams(accRoot, client);
                            this.deployArtifacts(artifactoryTask.deployDetails, client, patterns);
                        }
                    }
                    allDeployDetails.addAll(artifactoryTask.deployDetails);
                    continue;
                }
                log.debug("Task '{}' did no work", (Object)artifactoryTask.getPath());
            }
            ArtifactoryBuildInfoClient client = null;
            String contextUrl = accRoot.publisher.getContextUrl();
            String username = accRoot.publisher.getUsername();
            String password = accRoot.publisher.getPassword();
            if (contextUrl != null) {
                if (StringUtils.isBlank((String)username)) {
                    username = "";
                }
                if (StringUtils.isBlank((String)password)) {
                    password = "";
                }
                try {
                    client = new ArtifactoryBuildInfoClient(accRoot.publisher.getContextUrl(), accRoot.publisher.getUsername(), accRoot.publisher.getPassword(), (Log)new GradleClientLogger(log));
                    this.configureProxy(accRoot, client);
                    this.configConnectionTimeout(accRoot, client);
                    this.configRetriesParams(accRoot, client);
                    GradleBuildInfoExtractor gbie = new GradleBuildInfoExtractor(accRoot, allDeployDetails);
                    Build build = gbie.extract(this.getProject().getRootProject());
                    this.exportBuildInfo(build, this.getExportFile(accRoot));
                    if (this.isPublishBuildInfo(accRoot).booleanValue()) {
                        this.exportBuildInfo(build, this.getExportFile(accRoot));
                        if (accRoot.info.isIncremental().booleanValue()) {
                            log.debug("Publishing build info modules to artifactory at: '{}'", (Object)contextUrl);
                            client.sendModuleInfo(build);
                        } else {
                            log.debug("Publishing build info to artifactory at: '{}'", (Object)contextUrl);
                            Utils.sendBuildAndBuildRetention((ArtifactoryBuildInfoClient)client, (Build)build, (ArtifactoryClientConfiguration)accRoot);
                        }
                    }
                    if (this.isGenerateBuildInfoToFile(accRoot).booleanValue()) {
                        try {
                            this.exportBuildInfo(build, new File(accRoot.info.getGeneratedBuildInfoFilePath()));
                        }
                        catch (Exception e) {
                            log.error("Failed writing build info to file: ", (Throwable)e);
                            throw new IOException("Failed writing build info to file", e);
                        }
                    }
                    if (!this.isGenerateDeployableArtifactsToFile(accRoot).booleanValue()) break block25;
                    try {
                        this.exportDeployableArtifacts(allDeployDetails, new File(accRoot.info.getDeployableArtifactsFilePath()));
                    }
                    catch (Exception e) {
                        log.error("Failed writing deployable artifacts to file: ", (Throwable)e);
                        throw new RuntimeException("Failed writing deployable artifacts to file", e);
                    }
                }
                finally {
                    if (client != null) {
                        client.close();
                    }
                }
            }
        }
    }

    private void configureProxy(ArtifactoryClientConfiguration clientConf, ArtifactoryBuildInfoClient client) {
        ArtifactoryClientConfiguration.ProxyHandler proxy = clientConf.proxy;
        String proxyHost = proxy.getHost();
        if (StringUtils.isNotBlank((String)proxyHost) && proxy.getPort() != null) {
            log.debug("Found proxy host '{}'", (Object)proxyHost);
            String proxyUserName = proxy.getUsername();
            if (StringUtils.isNotBlank((String)proxyUserName)) {
                log.debug("Found proxy user name '{}'", (Object)proxyUserName);
                client.setProxyConfiguration(proxyHost, proxy.getPort().intValue(), proxyUserName, proxy.getPassword());
            } else {
                log.debug("No proxy user name and password found, using anonymous proxy");
                client.setProxyConfiguration(proxyHost, proxy.getPort().intValue());
            }
        }
    }

    private void configConnectionTimeout(ArtifactoryClientConfiguration clientConf, ArtifactoryBuildInfoClient client) {
        if (clientConf.getTimeout() != null) {
            client.setConnectionTimeout(clientConf.getTimeout().intValue());
        }
    }

    private void configRetriesParams(ArtifactoryClientConfiguration clientConf, ArtifactoryBuildInfoClient client) {
        if (clientConf.getConnectionRetries() != null) {
            client.setConnectionRetries(clientConf.getConnectionRetries().intValue());
        }
    }

    private void exportBuildInfo(Build build, File toFile) throws IOException {
        log.debug("Exporting generated build info to '{}'", (Object)toFile.getAbsolutePath());
        BuildInfoExtractorUtils.saveBuildInfoToFile((Build)build, (File)toFile);
    }

    private void exportDeployableArtifacts(Set<GradleDeployDetails> allDeployDetails, File toFile) throws IOException {
        log.debug("Exporting deployable artifacts to '{}'", (Object)toFile.getAbsolutePath());
        LinkedHashSet deploySet = Sets.newLinkedHashSet();
        for (GradleDeployDetails details : allDeployDetails) {
            deploySet.add(details.getDeployDetails());
        }
        DeployableArtifactsUtils.saveDeployableArtifactsToFile((Set)deploySet, (File)toFile);
    }

    private File getExportFile(ArtifactoryClientConfiguration clientConf) {
        String fileExportPath = clientConf.getExportFile();
        if (StringUtils.isNotBlank((String)fileExportPath)) {
            return new File(fileExportPath);
        }
        Project rootProject = this.getProject().getRootProject();
        return new File(rootProject.getBuildDir(), "build-info.json");
    }

    @Nonnull
    private Boolean isPublishBuildInfo(ArtifactoryClientConfiguration acc) {
        return acc.publisher.isPublishBuildInfo();
    }

    @Nonnull
    private Boolean isGenerateBuildInfoToFile(ArtifactoryClientConfiguration acc) {
        return !StringUtils.isEmpty((String)acc.info.getGeneratedBuildInfoFilePath());
    }

    @Nonnull
    private Boolean isGenerateDeployableArtifactsToFile(ArtifactoryClientConfiguration acc) {
        return !StringUtils.isEmpty((String)acc.info.getDeployableArtifactsFilePath());
    }

    private void deployArtifacts(Set<GradleDeployDetails> allDeployDetails, ArtifactoryBuildInfoClient client, IncludeExcludePatterns patterns) throws IOException {
        for (GradleDeployDetails detail : allDeployDetails) {
            DeployDetails deployDetails = detail.getDeployDetails();
            String artifactPath = deployDetails.getArtifactPath();
            if (PatternMatcher.pathConflicts((String)artifactPath, (IncludeExcludePatterns)patterns)) {
                log.log(LogLevel.LIFECYCLE, "Skipping the deployment of '" + artifactPath + "' due to the defined include-exclude patterns.");
                continue;
            }
            client.deployArtifact(deployDetails);
        }
    }

    private List<ArtifactoryTask> findArtifactoryPublishTasks(TaskExecutionGraph graph) {
        ArrayList<ArtifactoryTask> tasks = new ArrayList<ArtifactoryTask>();
        for (Task task : graph.getAllTasks()) {
            if (!(task instanceof ArtifactoryTask)) continue;
            tasks.add((ArtifactoryTask)task);
        }
        return tasks;
    }
}

