/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.task.helper;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.ivy.core.IvyPatternHelper;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyArtifactSet;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.api.publish.ivy.internal.publisher.IvyNormalizedPublication;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenArtifactSet;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.gradle.plugin.artifactory.ArtifactoryPluginUtil;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleDeployDetails;
import org.jfrog.gradle.plugin.artifactory.extractor.PublishArtifactInfo;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;
import org.jfrog.gradle.plugin.artifactory.task.helper.TaskHelper;

public class TaskHelperPublications
extends TaskHelper {
    private static final Logger log = Logging.getLogger(TaskHelperPublications.class);
    private Set<IvyPublication> ivyPublications = new HashSet<IvyPublication>();
    private Set<MavenPublication> mavenPublications = new HashSet<MavenPublication>();
    private Set<Object> publications = new HashSet<Object>();
    private boolean publishPublicationsSpecified;

    public TaskHelperPublications(ArtifactoryTask artifactoryTask) {
        super(artifactoryTask);
        this.ivyPublications = artifactoryTask.ivyPublications;
        this.mavenPublications = artifactoryTask.mavenPublications;
    }

    public void publications() {
        if (this.publications == null || this.publications.size() == 0) {
            return;
        }
        for (Object publication : this.publications) {
            if (publication instanceof CharSequence) {
                Publication publicationObj = (Publication)((PublishingExtension)this.getProject().getExtensions().getByType(PublishingExtension.class)).getPublications().findByName(publication.toString());
                if (publicationObj != null) {
                    this.addPublication(publicationObj);
                    continue;
                }
                this.logPublicationNotFound(publication);
                continue;
            }
            if (publication instanceof Publication) {
                this.addPublication((Publication)publication);
                continue;
            }
            log.error("Publication type '{}' not supported in task '{}'.", new Object[]{publication.getClass().getName(), this.getPath()});
        }
        this.publishPublicationsSpecified = true;
    }

    @Override
    public void addCollection(Object ... publications) {
        Collections.addAll(this.publications, publications);
    }

    private void logPublicationNotFound(Object publication) {
        log.debug("Publication named '{}' does not exist for project '{}' in task '{}'.", new Object[]{publication, this.getProject().getPath(), this.getPath()});
    }

    public Set<IvyPublication> getIvyPublications() {
        return this.ivyPublications;
    }

    public Set<MavenPublication> getMavenPublications() {
        return this.mavenPublications;
    }

    public boolean hasPublications() {
        return !this.ivyPublications.isEmpty() || !this.mavenPublications.isEmpty();
    }

    public void checkDependsOnArtifactsToPublish() {
        String capitalizedPublicationName;
        this.publications();
        if (!this.hasPublications()) {
            return;
        }
        if (!this.hasPublications()) {
            if (this.publishPublicationsSpecified) {
                log.warn("None of the specified publications matched for project '{}' - nothing to publish.", (Object)this.getProject().getPath());
            } else {
                log.debug("No publications specified for project '{}'", (Object)this.getProject().getPath());
            }
            return;
        }
        for (IvyPublication ivyPublication : this.ivyPublications) {
            if (!(ivyPublication instanceof IvyPublicationInternal)) {
                log.warn("Ivy publication name '{}' is of unsupported type '{}'!", (Object)ivyPublication.getName(), ivyPublication.getClass());
                continue;
            }
            this.dependsOn(((IvyPublicationInternal)ivyPublication).getPublishableFiles());
            capitalizedPublicationName = ivyPublication.getName().substring(0, 1).toUpperCase() + ivyPublication.getName().substring(1);
            this.dependsOn(String.format("%s:generateDescriptorFileFor%sPublication", this.getProject().getPath(), capitalizedPublicationName));
        }
        for (MavenPublication mavenPublication : this.mavenPublications) {
            if (!(mavenPublication instanceof MavenPublicationInternal)) {
                log.warn("Maven publication name '{}' is of unsupported type '{}'!", (Object)mavenPublication.getName(), mavenPublication.getClass());
                continue;
            }
            this.dependsOn(((MavenPublicationInternal)mavenPublication).getPublishableFiles());
            capitalizedPublicationName = mavenPublication.getName().substring(0, 1).toUpperCase() + mavenPublication.getName().substring(1);
            this.dependsOn(String.format("%s:generatePomFileFor%sPublication", this.getProject().getPath(), capitalizedPublicationName));
        }
    }

    public void collectDescriptorsAndArtifactsForUpload() throws IOException {
        Set<GradleDeployDetails> deployDetailsFromProject = this.getArtifactDeployDetails();
        this.artifactoryTask.deployDetails.addAll(deployDetailsFromProject);
    }

    public boolean hasModules() {
        return this.hasPublications();
    }

    public Set<GradleDeployDetails> getArtifactDeployDetails() {
        String publicationName;
        LinkedHashSet deployDetails = Sets.newLinkedHashSet();
        if (!this.hasPublications()) {
            log.info("No publications to publish for project '{}'.", (Object)this.getProject().getPath());
            return deployDetails;
        }
        for (IvyPublication ivyPublication : this.ivyPublications) {
            File file;
            Iterator builder;
            publicationName = ivyPublication.getName();
            if (!(ivyPublication instanceof IvyPublicationInternal)) {
                log.warn("Ivy publication name '{}' is of unsupported type '{}'!", (Object)publicationName, ivyPublication.getClass());
                continue;
            }
            IvyPublicationInternal ivyPublicationInternal = (IvyPublicationInternal)ivyPublication;
            IvyNormalizedPublication ivyNormalizedPublication = ivyPublicationInternal.asNormalisedPublication();
            IvyPublicationIdentity projectIdentity = ivyNormalizedPublication.getProjectIdentity();
            Map extraInfo = ivyPublication.getDescriptor().getExtraInfo().asMap();
            if (this.isPublishIvy().booleanValue() && (builder = this.createBuilder(file = this.getIvyDescriptorFile(ivyNormalizedPublication), publicationName)) != null) {
                PublishArtifactInfo artifactInfo = new PublishArtifactInfo(projectIdentity.getModule(), "xml", "ivy", null, extraInfo, file);
                this.addIvyArtifactToDeployDetails(deployDetails, publicationName, projectIdentity, (DeployDetails.Builder)builder, artifactInfo);
            }
            IvyArtifactSet artifacts = ivyPublication.getArtifacts();
            builder = artifacts.iterator();
            while (builder.hasNext()) {
                IvyArtifact artifact = (IvyArtifact)builder.next();
                File file2 = artifact.getFile();
                DeployDetails.Builder builder2 = this.createBuilder(file2, publicationName);
                if (builder2 == null) continue;
                PublishArtifactInfo artifactInfo = new PublishArtifactInfo(artifact.getName(), artifact.getExtension(), artifact.getType(), artifact.getClassifier(), extraInfo, file2);
                this.addIvyArtifactToDeployDetails(deployDetails, publicationName, projectIdentity, builder2, artifactInfo);
            }
        }
        for (MavenPublication mavenPublication : this.mavenPublications) {
            File file;
            DeployDetails.Builder builder;
            publicationName = mavenPublication.getName();
            if (!(mavenPublication instanceof MavenPublicationInternal)) {
                log.warn("Maven publication name '{}' is of unsupported type '{}'!", (Object)publicationName, mavenPublication.getClass());
                continue;
            }
            MavenPublicationInternal mavenPublicationInternal = (MavenPublicationInternal)mavenPublication;
            MavenNormalizedPublication mavenNormalizedPublication = mavenPublicationInternal.asNormalisedPublication();
            if (this.isPublishMaven().booleanValue() && (builder = this.createBuilder(file = mavenNormalizedPublication.getPomFile(), publicationName)) != null) {
                PublishArtifactInfo artifactInfo = new PublishArtifactInfo(mavenPublication.getArtifactId(), "pom", "pom", null, file);
                this.addMavenArtifactToDeployDetails(deployDetails, publicationName, builder, artifactInfo, mavenPublication);
            }
            MavenArtifactSet artifacts = mavenPublication.getArtifacts();
            for (MavenArtifact artifact : artifacts) {
                File file3 = artifact.getFile();
                DeployDetails.Builder builder3 = this.createBuilder(file3, publicationName);
                if (builder3 == null) continue;
                PublishArtifactInfo artifactInfo = new PublishArtifactInfo(mavenPublication.getArtifactId(), artifact.getExtension(), artifact.getExtension(), artifact.getClassifier(), file3);
                this.addMavenArtifactToDeployDetails(deployDetails, publicationName, builder3, artifactInfo, mavenPublication);
            }
        }
        return deployDetails;
    }

    private File getIvyDescriptorFile(IvyNormalizedPublication ivy) {
        try {
            return ivy.getIvyDescriptorFile();
        }
        catch (NoSuchMethodError error) {
            try {
                Method m = ivy.getClass().getMethod("getDescriptorFile", new Class[0]);
                return (File)m.invoke((Object)ivy, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void addPublication(Publication publicationObj) {
        if (publicationObj instanceof IvyPublication) {
            this.ivyPublications.add((IvyPublication)publicationObj);
        } else if (publicationObj instanceof MavenPublication) {
            this.mavenPublications.add((MavenPublication)publicationObj);
        } else {
            log.warn("Publication named '{}' in project '{}' is of unknown type '{}'", new Object[]{publicationObj.getName(), this.getProject().getPath(), publicationObj.getClass()});
        }
    }

    private DeployDetails.Builder createBuilder(File file, String publicationName) {
        if (!file.exists()) {
            throw new GradleException("File '" + file.getAbsolutePath() + "' does not exist, and need to be published from publication " + publicationName);
        }
        DeployDetails.Builder artifactBuilder = new DeployDetails.Builder().file(file);
        try {
            Map checksums = FileChecksumCalculator.calculateChecksums((File)file, (String[])new String[]{"MD5", "SHA1"});
            artifactBuilder.md5((String)checksums.get("MD5")).sha1((String)checksums.get("SHA1"));
        }
        catch (Exception e) {
            throw new GradleException("Failed to calculate checksums for artifact: " + file.getAbsolutePath(), (Throwable)e);
        }
        return artifactBuilder;
    }

    private Map<String, String> getExtraTokens(PublishArtifactInfo artifactInfo) {
        Map<QName, String> extraInfo;
        HashMap extraTokens = Maps.newHashMap();
        if (StringUtils.isNotBlank((String)artifactInfo.getClassifier())) {
            extraTokens.put("classifier", artifactInfo.getClassifier());
        }
        if ((extraInfo = artifactInfo.getExtraInfo()) != null) {
            for (Map.Entry<QName, String> extraToken : extraInfo.entrySet()) {
                String key = extraToken.getKey().getLocalPart();
                if (extraTokens.containsKey(key)) {
                    throw new GradleException("Duplicated extra info '" + key + "'.");
                }
                extraTokens.put(key, extraToken.getValue());
            }
        }
        return extraTokens;
    }

    private void addIvyArtifactToDeployDetails(Set<GradleDeployDetails> deployDetails, String publicationName, IvyPublicationIdentity projectIdentity, DeployDetails.Builder builder, PublishArtifactInfo artifactInfo) {
        ArtifactoryClientConfiguration.PublisherHandler publisher = ArtifactoryPluginUtil.getPublisherHandler(this.getProject());
        if (publisher == null) {
            return;
        }
        String pattern = "ivy".equals(artifactInfo.getType()) ? publisher.getIvyPattern() : publisher.getIvyArtifactPattern();
        String gid = projectIdentity.getOrganisation();
        if (publisher.isM2Compatible()) {
            gid = gid.replace(".", "/");
        }
        Map<String, String> extraTokens = this.getExtraTokens(artifactInfo);
        builder.artifactPath(IvyPatternHelper.substitute((String)pattern, (String)gid, (String)projectIdentity.getModule(), (String)projectIdentity.getRevision(), (String)artifactInfo.getName(), (String)artifactInfo.getType(), (String)artifactInfo.getExtension(), (String)publicationName, extraTokens, null));
        this.addArtifactInfoToDeployDetails(deployDetails, publicationName, builder, artifactInfo);
    }

    private void addMavenArtifactToDeployDetails(Set<GradleDeployDetails> deployDetails, String publicationName, DeployDetails.Builder builder, PublishArtifactInfo artifactInfo, MavenPublication mavenPublication) {
        Map<String, String> extraTokens = this.getExtraTokens(artifactInfo);
        builder.artifactPath(IvyPatternHelper.substitute((String)"[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]", (String)mavenPublication.getGroupId().replace(".", "/"), (String)mavenPublication.getArtifactId(), (String)mavenPublication.getVersion(), (String)artifactInfo.getName(), (String)artifactInfo.getType(), (String)artifactInfo.getExtension(), (String)publicationName, extraTokens, null));
        this.addArtifactInfoToDeployDetails(deployDetails, publicationName, builder, artifactInfo);
    }

    private void addArtifactInfoToDeployDetails(Set<GradleDeployDetails> deployDetails, String publicationName, DeployDetails.Builder builder, PublishArtifactInfo artifactInfo) {
        ArtifactoryClientConfiguration.PublisherHandler publisher = ArtifactoryPluginUtil.getPublisherHandler(this.getProject());
        if (publisher != null) {
            builder.targetRepository(publisher.getRepoKey());
            Map<String, String> propsToAdd = this.getPropsToAdd(artifactInfo, publicationName);
            builder.addProperties(propsToAdd);
            DeployDetails details = builder.build();
            deployDetails.add(new GradleDeployDetails(artifactInfo, details, this.getProject()));
        }
    }
}

