/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.task;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.jfrog.gradle.plugin.artifactory.task.BuildInfoBaseTask;
import org.jfrog.gradle.plugin.artifactory.task.helper.TaskHelperConfigurations;
import org.jfrog.gradle.plugin.artifactory.task.helper.TaskHelperPublications;

public class ArtifactoryTask
extends BuildInfoBaseTask {
    @InputFile
    @Optional
    public File ivyDescriptor;
    @InputFile
    @Optional
    public File mavenDescriptor;
    @InputFiles
    @Optional
    public Set<Configuration> publishConfigs = Sets.newHashSet();
    @Input
    @Optional
    public Set<IvyPublication> ivyPublications = Sets.newHashSet();
    @Input
    @Optional
    public Set<MavenPublication> mavenPublications = Sets.newHashSet();
    private boolean addArchivesConfigToTask = false;
    public TaskHelperConfigurations helperConfigurations = new TaskHelperConfigurations(this);
    public TaskHelperPublications helperPublications = new TaskHelperPublications(this);

    @Input
    Set<Publication> getPublications() {
        HashSet<Publication> publications = new HashSet<Publication>();
        publications.addAll(this.ivyPublications);
        publications.addAll(this.mavenPublications);
        return publications;
    }

    @Override
    public void checkDependsOnArtifactsToPublish() {
        if (this.addArchivesConfigToTask) {
            this.helperConfigurations.AddDefaultArchiveConfiguration(this.getProject());
        }
        if (this.helperConfigurations.hasConfigurations()) {
            this.helperConfigurations.checkDependsOnArtifactsToPublish();
        }
        if (this.helperPublications.hasPublications()) {
            this.helperPublications.checkDependsOnArtifactsToPublish();
        }
    }

    @Override
    public void collectDescriptorsAndArtifactsForUpload() throws IOException {
        if (this.helperConfigurations.hasConfigurations()) {
            this.helperConfigurations.collectDescriptorsAndArtifactsForUpload();
        }
        if (this.helperPublications.hasPublications()) {
            this.helperPublications.collectDescriptorsAndArtifactsForUpload();
        }
    }

    @Override
    public boolean hasModules() {
        return this.helperConfigurations.hasModules() || this.helperPublications.hasModules();
    }

    public boolean hasPublications() {
        return this.helperPublications.hasPublications();
    }

    public boolean hasConfigurations() {
        return this.helperConfigurations.hasConfigurations();
    }

    public void publishConfigs(Object ... confs) {
        this.helperConfigurations.publishConfigs(confs);
    }

    public void publications(Object ... publications) {
        this.helperPublications.publications(publications);
    }

    public Set<IvyPublication> getIvyPublications() {
        return this.ivyPublications;
    }

    public File getIvyDescriptor() {
        return this.ivyDescriptor;
    }

    public File getMavenDescriptor() {
        return this.mavenDescriptor;
    }

    public void setAddArchivesConfigToTask(boolean addArchivesConfigToTask) {
        this.addArchivesConfigToTask = addArchivesConfigToTask;
    }
}

