/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.task;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.ConfigureUtil;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.DeployDetails;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactSpecs;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.gradle.plugin.artifactory.ArtifactoryPluginUtil;
import org.jfrog.gradle.plugin.artifactory.dsl.ArtifactoryPluginConvention;
import org.jfrog.gradle.plugin.artifactory.dsl.PropertiesConfig;
import org.jfrog.gradle.plugin.artifactory.dsl.PublisherConfig;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleArtifactoryClientConfigUpdater;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleBuildInfoExtractor;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleClientLogger;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleDeployDetails;

public abstract class BuildInfoBaseTask
extends DefaultTask {
    public static final String BUILD_INFO_TASK_NAME = "artifactoryPublish";
    public static final String PUBLISH_ARTIFACTS = "publishArtifacts";
    public static final String PUBLISH_BUILD_INFO = "publishBuildInfo";
    public static final String PUBLISH_IVY = "publishIvy";
    public static final String PUBLISH_POM = "publishPom";
    private static final Logger log = Logging.getLogger(BuildInfoBaseTask.class);
    private final Map<String, Boolean> flags = Maps.newHashMap();
    public final Set<GradleDeployDetails> deployDetails = Sets.newTreeSet();
    List<BuildInfoBaseTask> artifactoryTasks = null;
    private final Multimap<String, CharSequence> properties = ArrayListMultimap.create();
    @Input
    public final ArtifactSpecs artifactSpecs = new ArtifactSpecs();
    @Input
    public boolean skip = false;

    public abstract void checkDependsOnArtifactsToPublish();

    public abstract void collectDescriptorsAndArtifactsForUpload() throws IOException;

    public abstract boolean hasModules();

    @Input
    public Multimap<String, CharSequence> getProperties() {
        return this.properties;
    }

    @Input
    @Optional
    @Nullable
    public Boolean getPublishBuildInfo() {
        return this.getFlag(PUBLISH_BUILD_INFO);
    }

    @Input
    @Optional
    @Nullable
    public Boolean getPublishArtifacts() {
        return this.getFlag(PUBLISH_ARTIFACTS);
    }

    @Input
    @Optional
    @Nullable
    public Boolean getPublishIvy() {
        return this.getFlag(PUBLISH_IVY);
    }

    @Input
    @Optional
    @Nullable
    public Boolean getPublishPom() {
        return this.getFlag(PUBLISH_POM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void collectProjectBuildInfo() throws IOException {
        try {
            log.debug("Task '{}' activated", (Object)this.getPath());
            List<BuildInfoBaseTask> orderedTasks = this.getAllArtifactoryTasks();
            if (orderedTasks.indexOf((Object)this) == -1) {
                log.error("Could not find my own task {} in the task graph!", (Object)this.getPath());
                return;
            }
            if (this.isLastTask()) {
                log.debug("Starting build info extraction for project '{}' using last task in graph '{}'", new Object[]{this.getProject().getPath(), this.getPath()});
                this.prepareAndDeploy();
            }
        }
        finally {
            File file;
            String propertyFilePath = System.getenv("buildInfoConfig.propertiesFile");
            if (StringUtils.isNotBlank((String)propertyFilePath) && (file = new File(propertyFilePath)).exists()) {
                file.delete();
            }
        }
    }

    private boolean isLastTask() {
        return this.getCurrentTaskIndex() == this.getAllArtifactoryTasks().size() - 1;
    }

    private int getCurrentTaskIndex() {
        List<BuildInfoBaseTask> tasks = this.getAllArtifactoryTasks();
        int currentTaskIndex = tasks.indexOf((Object)this);
        if (currentTaskIndex == -1) {
            throw new IllegalStateException(String.format("Could not find the current task %s in the task graph", this.getPath()));
        }
        return currentTaskIndex;
    }

    private List<BuildInfoBaseTask> getAllArtifactoryTasks() {
        if (this.artifactoryTasks == null) {
            ArrayList<BuildInfoBaseTask> tasks = new ArrayList<BuildInfoBaseTask>();
            for (Task task : this.getProject().getGradle().getTaskGraph().getAllTasks()) {
                if (!(task instanceof BuildInfoBaseTask)) continue;
                tasks.add((BuildInfoBaseTask)task);
            }
            this.artifactoryTasks = tasks;
        }
        return this.artifactoryTasks;
    }

    public void projectsEvaluated() {
        Project project = this.getProject();
        log.info("Configuring artifactoryPublish task '{}' for project '{}'.", (Object)this.getPath(), (Object)project.getName());
        if (this.isSkip()) {
            log.debug("artifactoryPublish task '{}' skipped for project '{}'.", (Object)this.getPath(), (Object)project.getName());
            return;
        }
        ArtifactoryPluginConvention convention = ArtifactoryPluginUtil.getPublisherConvention(project);
        if (convention != null) {
            ArtifactoryClientConfiguration acc = convention.getClientConfig();
            this.artifactSpecs.addAll((Collection)acc.publisher.getArtifactSpecs());
            PublisherConfig config = convention.getPublisherConfig();
            if (config != null) {
                Closure defaultsClosure = config.getDefaultsClosure();
                ConfigureUtil.configure((Closure)defaultsClosure, (Object)((Object)this));
            }
        }
        for (Project sub : project.getSubprojects()) {
            Task subBiTask = (Task)sub.getTasks().findByName(BUILD_INFO_TASK_NAME);
            if (subBiTask == null) continue;
            this.dependsOn(new Object[]{subBiTask});
        }
        this.checkDependsOnArtifactsToPublish();
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setProperties(Map<String, CharSequence> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        for (Map.Entry<String, CharSequence> entry : props.entrySet()) {
            CharSequence value;
            String key = entry.getKey();
            if (!StringUtils.isNotBlank((String)key) || (value = entry.getValue()) == null) continue;
            this.properties.put((Object)key, (Object)value);
        }
    }

    public Set<GradleDeployDetails> getDeployDetails() {
        return this.deployDetails;
    }

    public ArtifactSpecs getArtifactSpecs() {
        return this.artifactSpecs;
    }

    public void properties(Closure closure) {
        Project project = this.getProject();
        PropertiesConfig propertiesConfig = new PropertiesConfig(project);
        ConfigureUtil.configure((Closure)closure, (Object)propertiesConfig);
        this.artifactSpecs.addAll((Collection)propertiesConfig.getArtifactSpecs());
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setPublishIvy(Object publishIvy) {
        this.setFlag(PUBLISH_IVY, this.toBoolean(publishIvy));
    }

    public void setPublishPom(Object publishPom) {
        this.setFlag(PUBLISH_POM, this.toBoolean(publishPom));
    }

    public void setPublishBuildInfo(Object publishBuildInfo) {
        this.setFlag(PUBLISH_BUILD_INFO, this.toBoolean(publishBuildInfo));
    }

    public void setPublishArtifacts(Object publishArtifacts) {
        this.setFlag(PUBLISH_ARTIFACTS, this.toBoolean(publishArtifacts));
    }

    private void configureProxy(ArtifactoryClientConfiguration clientConf, ArtifactoryBuildInfoClient client) {
        ArtifactoryClientConfiguration.ProxyHandler proxy = clientConf.proxy;
        String proxyHost = proxy.getHost();
        if (StringUtils.isNotBlank((String)proxyHost) && proxy.getPort() != null) {
            log.debug("Found proxy host '{}'", (Object)proxyHost);
            String proxyUserName = proxy.getUsername();
            if (StringUtils.isNotBlank((String)proxyUserName)) {
                log.debug("Found proxy user name '{}'", (Object)proxyUserName);
                client.setProxyConfiguration(proxyHost, proxy.getPort().intValue(), proxyUserName, proxy.getPassword());
            } else {
                log.debug("No proxy user name and password found, using anonymous proxy");
                client.setProxyConfiguration(proxyHost, proxy.getPort().intValue());
            }
        }
    }

    protected void configConnectionTimeout(ArtifactoryClientConfiguration clientConf, ArtifactoryBuildInfoClient client) {
        if (clientConf.getTimeout() != null) {
            client.setConnectionTimeout(clientConf.getTimeout().intValue());
        }
    }

    private File getExportFile(ArtifactoryClientConfiguration clientConf) {
        String fileExportPath = clientConf.getExportFile();
        if (StringUtils.isNotBlank((String)fileExportPath)) {
            return new File(fileExportPath);
        }
        Project rootProject = this.getProject().getRootProject();
        return new File(rootProject.getBuildDir(), "build-info.json");
    }

    private void exportBuildInfo(Build build, File toFile) throws IOException {
        log.debug("Exporting generated build info to '{}'", (Object)toFile.getAbsolutePath());
        BuildInfoExtractorUtils.saveBuildInfoToFile((Build)build, (File)toFile);
    }

    @Nonnull
    private Boolean isPublishArtifacts(ArtifactoryClientConfiguration acc) {
        Boolean publishArtifacts = this.getPublishArtifacts();
        if (publishArtifacts == null) {
            return acc.publisher.isPublishArtifacts();
        }
        return publishArtifacts;
    }

    @Nonnull
    private Boolean isPublishBuildInfo(ArtifactoryClientConfiguration acc) {
        Boolean publishBuildInfo = this.getPublishBuildInfo();
        if (publishBuildInfo == null) {
            return acc.publisher.isPublishBuildInfo();
        }
        return publishBuildInfo;
    }

    @Nonnull
    private Boolean isGenerateBuildInfoToFile(ArtifactoryClientConfiguration acc) {
        return !StringUtils.isEmpty((String)acc.info.getGeneratedBuildInfoFilePath());
    }

    @Nullable
    private Boolean getFlag(String flagName) {
        return this.flags.get(flagName);
    }

    private Boolean toBoolean(Object o) {
        return Boolean.valueOf(o.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAndDeploy() throws IOException {
        block18: {
            ArtifactoryClientConfiguration accRoot = ArtifactoryPluginUtil.getArtifactoryConvention(this.getProject()).getClientConfig();
            Map propsRoot = accRoot.publisher.getProps();
            GradleArtifactoryClientConfigUpdater.setMissingBuildAttributes(accRoot, this.getProject().getRootProject());
            TreeSet allDeployDetails = Sets.newTreeSet();
            List<BuildInfoBaseTask> orderedTasks = this.getAllArtifactoryTasks();
            for (BuildInfoBaseTask bit : orderedTasks) {
                if (!bit.getDidWork()) continue;
                ArtifactoryClientConfiguration.PublisherHandler publisher = ArtifactoryPluginUtil.getPublisherHandler(bit.getProject());
                publisher.getProps().putAll(propsRoot);
                if (publisher == null || publisher.getContextUrl() == null) continue;
                String contextUrl = publisher.getContextUrl();
                String username = publisher.getUsername();
                String password = publisher.getPassword();
                if (StringUtils.isBlank((String)username)) {
                    username = "";
                }
                if (StringUtils.isBlank((String)password)) {
                    password = "";
                }
                if (!publisher.isPublishArtifacts().booleanValue()) continue;
                ArtifactoryBuildInfoClient client = null;
                try {
                    client = new ArtifactoryBuildInfoClient(contextUrl, username, password, (Log)new GradleClientLogger(log));
                    bit.collectDescriptorsAndArtifactsForUpload();
                    log.debug("Uploading artifacts to Artifactory at '{}'", (Object)contextUrl);
                    IncludeExcludePatterns patterns = new IncludeExcludePatterns(publisher.getIncludePatterns(), publisher.getExcludePatterns());
                    this.configureProxy(accRoot, client);
                    this.configConnectionTimeout(accRoot, client);
                    this.deployArtifacts(bit.deployDetails, client, patterns);
                    allDeployDetails.addAll(bit.deployDetails);
                }
                finally {
                    if (client == null) continue;
                    client.shutdown();
                }
            }
            ArtifactoryBuildInfoClient client = null;
            String contextUrl = accRoot.publisher.getContextUrl();
            String username = accRoot.publisher.getUsername();
            String password = accRoot.publisher.getPassword();
            if (contextUrl != null) {
                if (StringUtils.isBlank((String)username)) {
                    username = "";
                }
                if (StringUtils.isBlank((String)password)) {
                    password = "";
                }
                try {
                    client = new ArtifactoryBuildInfoClient(accRoot.publisher.getContextUrl(), accRoot.publisher.getUsername(), accRoot.publisher.getPassword(), (Log)new GradleClientLogger(log));
                    GradleBuildInfoExtractor gbie = new GradleBuildInfoExtractor(accRoot, allDeployDetails);
                    Build build = gbie.extract(this.getProject().getRootProject());
                    this.exportBuildInfo(build, this.getExportFile(accRoot));
                    if (this.isPublishBuildInfo(accRoot).booleanValue()) {
                        this.exportBuildInfo(build, this.getExportFile(accRoot));
                        if (accRoot.info.isIncremental().booleanValue()) {
                            log.debug("Publishing build info modules to artifactory at: '{}'", (Object)contextUrl);
                            client.sendModuleInfo(build);
                        } else {
                            log.debug("Publishing build info to artifactory at: '{}'", (Object)contextUrl);
                            client.sendBuildInfo(build);
                        }
                    }
                    if (!this.isGenerateBuildInfoToFile(accRoot).booleanValue()) break block18;
                    try {
                        this.exportBuildInfo(build, new File(accRoot.info.getGeneratedBuildInfoFilePath()));
                    }
                    catch (Exception e) {
                        log.error("Failed writing build info to file: ", (Throwable)e);
                        throw new IOException("Failed writing build info to file", e);
                    }
                }
                finally {
                    if (client != null) {
                        client.shutdown();
                    }
                }
            }
        }
    }

    private void deployArtifacts(Set<GradleDeployDetails> allDeployDetails, ArtifactoryBuildInfoClient client, IncludeExcludePatterns patterns) throws IOException {
        for (GradleDeployDetails detail : allDeployDetails) {
            DeployDetails deployDetails = detail.getDeployDetails();
            String artifactPath = deployDetails.getArtifactPath();
            if (PatternMatcher.pathConflicts((String)artifactPath, (IncludeExcludePatterns)patterns)) {
                log.log(LogLevel.LIFECYCLE, "Skipping the deployment of '" + artifactPath + "' due to the defined include-exclude patterns.");
                continue;
            }
            client.deployArtifact(deployDetails);
        }
    }

    private void setFlag(String flagName, Boolean newValue) {
        this.flags.put(flagName, newValue);
    }
}

