/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.extractor;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;

public class GradleArtifactoryClientConfigUpdater {
    public static void update(ArtifactoryClientConfiguration config, Project project) {
        Properties props = new Properties();
        GradleArtifactoryClientConfigUpdater.fillProperties(project, props);
        StartParameter startParameter = project.getGradle().getStartParameter();
        Map startProps = startParameter.getProjectProperties();
        props.putAll((Map<?, ?>)BuildInfoExtractorUtils.filterStringEntries((Map)startProps));
        Properties mergedProps = BuildInfoExtractorUtils.mergePropertiesWithSystemAndPropertyFile((Properties)props, (Log)config.info.getLog());
        Properties buildInfoProperties = BuildInfoExtractorUtils.filterDynamicProperties((Properties)mergedProps, (Predicate)BuildInfoExtractorUtils.BUILD_INFO_PROP_PREDICATE);
        buildInfoProperties = BuildInfoExtractorUtils.stripPrefixFromProperties((Properties)buildInfoProperties, (String)"buildInfo.property.");
        mergedProps.putAll((Map<?, ?>)buildInfoProperties);
        String prefix = "buildInfo.";
        HashSet excludeIfExist = Sets.newHashSet((Object[])new String[]{prefix + "build.number", prefix + "build.name", prefix + "build.started"});
        config.fillFromProperties(mergedProps, (Set)excludeIfExist);
        GradleArtifactoryClientConfigUpdater.setMissingBuildAttributes(config, project);
    }

    public static void setMissingBuildAttributes(ArtifactoryClientConfiguration config, Project project) {
        Date buildStartDate;
        String buildName = config.info.getBuildName();
        if (StringUtils.isBlank((String)buildName)) {
            buildName = project.getRootProject().getName();
            config.info.setBuildName(buildName);
        }
        config.publisher.addMatrixParam("build.name", buildName);
        String buildNumber = config.info.getBuildNumber();
        if (StringUtils.isBlank((String)buildNumber)) {
            buildNumber = new Date().getTime() + "";
            config.info.setBuildNumber(buildNumber);
        }
        config.publisher.addMatrixParam("build.number", buildNumber);
        String buildStartedIso = config.info.getBuildStarted();
        try {
            buildStartDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse(buildStartedIso);
        }
        catch (ParseException e) {
            throw new RuntimeException("Build start date format error: " + buildStartedIso, e);
        }
        config.publisher.addMatrixParam("build.timestamp", String.valueOf(buildStartDate.getTime()));
        String buildAgentName = config.info.getBuildAgentName();
        String buildAgentVersion = config.info.getBuildAgentVersion();
        if (StringUtils.isBlank((String)buildAgentName) && StringUtils.isBlank((String)buildAgentVersion)) {
            config.info.setBuildAgentName("Gradle");
            config.info.setBuildAgentVersion(project.getGradle().getGradleVersion());
        }
    }

    private static void fillProperties(Project project, Properties props) {
        Project parent = project.getParent();
        if (parent != null) {
            GradleArtifactoryClientConfigUpdater.fillProperties(parent, props);
        }
        Map projectProperties = project.getProperties();
        props.putAll((Map<?, ?>)BuildInfoExtractorUtils.filterStringEntries((Map)projectProperties));
    }
}

