/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.task;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.ivy.core.IvyPatternHelper;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyArtifactSet;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.api.publish.ivy.internal.publisher.IvyNormalizedPublication;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MavenProjectIdentity;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.client.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleDeployDetails;
import org.jfrog.gradle.plugin.artifactory.extractor.PublishArtifactInfo;
import org.jfrog.gradle.plugin.artifactory.task.BuildInfoBaseTask;

public class BuildInfoPublicationsTask
extends BuildInfoBaseTask {
    private static final Logger log = Logging.getLogger(BuildInfoPublicationsTask.class);
    @Input
    @Optional
    private Set<IvyPublication> ivyPublications = Sets.newHashSet();
    @Input
    @Optional
    private Set<MavenPublication> mavenPublications = Sets.newHashSet();
    private boolean publishPublicationsSpecified;

    public void publications(Object ... publications) {
        if (publications == null) {
            return;
        }
        for (Object publication : publications) {
            if (publication instanceof CharSequence) {
                Publication publicationObj = (Publication)((PublishingExtension)this.getProject().getExtensions().getByType(PublishingExtension.class)).getPublications().findByName(publication.toString());
                if (publicationObj != null) {
                    this.addPublication(publicationObj);
                    continue;
                }
                log.error("Publication named '{}' does not exist for project '{}' in task '{}'.", new Object[]{publication, this.getProject().getPath(), this.getPath()});
                continue;
            }
            if (publication instanceof Publication) {
                this.addPublication((Publication)publication);
                continue;
            }
            log.error("Publication type '{}' not supported in task '{}'.", new Object[]{publication.getClass().getName(), this.getPath()});
        }
        this.publishPublicationsSpecified = true;
    }

    private void addPublication(Publication publicationObj) {
        if (publicationObj instanceof IvyPublication) {
            this.ivyPublications.add((IvyPublication)publicationObj);
        } else if (publicationObj instanceof MavenPublication) {
            this.mavenPublications.add((MavenPublication)publicationObj);
        } else {
            log.warn("Publication named '{}' in project '{}' is of unknown type '{}'", new Object[]{publicationObj.getName(), this.getProject().getPath(), publicationObj.getClass()});
        }
    }

    public Set<IvyPublication> getIvyPublications() {
        return this.ivyPublications;
    }

    public Set<MavenPublication> getMavenPublications() {
        return this.mavenPublications;
    }

    public boolean hasPublications() {
        return !this.ivyPublications.isEmpty() || !this.mavenPublications.isEmpty();
    }

    @Override
    protected void checkDependsOnArtifactsToPublish(Project project) {
        String capitalizedPublicationName;
        if (!this.hasPublications()) {
            if (this.publishPublicationsSpecified) {
                log.warn("None of the specified publications matched for project '{}' - nothing to publish.", (Object)project.getPath());
            } else {
                log.debug("No publications specified for project '{}'", (Object)project.getPath());
            }
            return;
        }
        for (IvyPublication ivyPublication : this.ivyPublications) {
            if (!(ivyPublication instanceof IvyPublicationInternal)) {
                log.warn("Ivy publication name '{}' is of unsupported type '{}'!", (Object)ivyPublication.getName(), ivyPublication.getClass());
                continue;
            }
            this.dependsOn(new Object[]{((IvyPublicationInternal)ivyPublication).getPublishableFiles()});
            capitalizedPublicationName = ivyPublication.getName().substring(0, 1).toUpperCase() + ivyPublication.getName().substring(1);
            this.dependsOn(new Object[]{String.format("generateDescriptorFileFor%sPublication", capitalizedPublicationName)});
        }
        for (MavenPublication mavenPublication : this.mavenPublications) {
            if (!(mavenPublication instanceof MavenPublicationInternal)) {
                log.warn("Maven publication name '{}' is of unsupported type '{}'!", (Object)mavenPublication.getName(), mavenPublication.getClass());
                continue;
            }
            this.dependsOn(new Object[]{((MavenPublicationInternal)mavenPublication).getPublishableFiles()});
            capitalizedPublicationName = mavenPublication.getName().substring(0, 1).toUpperCase() + mavenPublication.getName().substring(1);
            this.dependsOn(new Object[]{String.format("generatePomFileFor%sPublication", capitalizedPublicationName)});
        }
    }

    @Override
    protected void collectDescriptorsAndArtifactsForUpload() throws IOException {
        Set<GradleDeployDetails> deployDetailsFromProject = this.getArtifactDeployDetails();
        this.deployDetails.addAll(deployDetailsFromProject);
    }

    @Override
    public boolean hasModules() {
        return this.hasPublications();
    }

    protected Set<GradleDeployDetails> getArtifactDeployDetails() {
        PublishArtifactInfo artifactInfo;
        DeployDetails.Builder builder;
        File file;
        IvyArtifactSet artifacts;
        PublishArtifactInfo artifactInfo2;
        File file2;
        DeployDetails.Builder builder2;
        IvyPublicationIdentity projectIdentity;
        String publicationName;
        LinkedHashSet deployDetails = Sets.newLinkedHashSet();
        if (!this.hasPublications()) {
            log.info("No publications to publish for project '{}'.", (Object)this.getProject().getPath());
            return deployDetails;
        }
        ArtifactoryClientConfiguration clientConf = this.getArtifactoryClientConfiguration();
        HashSet processedFiles = Sets.newHashSet();
        for (IvyPublication ivyPublication : this.ivyPublications) {
            publicationName = ivyPublication.getName();
            if (!(ivyPublication instanceof IvyPublicationInternal)) {
                log.warn("Ivy publication name '{}' is of unsupported type '{}'!", (Object)publicationName, ivyPublication.getClass());
                continue;
            }
            IvyPublicationInternal ivyPublicationInternal = (IvyPublicationInternal)ivyPublication;
            IvyNormalizedPublication ivyNormalizedPublication = ivyPublicationInternal.asNormalisedPublication();
            projectIdentity = ivyNormalizedPublication.getProjectIdentity();
            if (this.isPublishIvy().booleanValue() && (builder2 = this.createBuilder(processedFiles, file2 = ivyNormalizedPublication.getDescriptorFile(), publicationName)) != null) {
                artifactInfo2 = new PublishArtifactInfo(projectIdentity.getModule(), "xml", "ivy", null, file2);
                this.addIvyArtifactToDeployDetails(deployDetails, publicationName, projectIdentity, builder2, artifactInfo2);
            }
            artifacts = ivyPublication.getArtifacts();
            for (IvyArtifact artifact : artifacts) {
                file = artifact.getFile();
                builder = this.createBuilder(processedFiles, file, publicationName);
                if (builder == null) continue;
                artifactInfo = new PublishArtifactInfo(artifact.getName(), artifact.getExtension(), artifact.getType(), artifact.getClassifier(), file);
                this.addIvyArtifactToDeployDetails(deployDetails, publicationName, projectIdentity, builder, artifactInfo);
            }
        }
        for (MavenPublication mavenPublication : this.mavenPublications) {
            publicationName = mavenPublication.getName();
            if (!(mavenPublication instanceof MavenPublicationInternal)) {
                log.warn("Maven publication name '{}' is of unsupported type '{}'!", (Object)publicationName, mavenPublication.getClass());
                continue;
            }
            MavenPublicationInternal mavenPublicationInternal = (MavenPublicationInternal)mavenPublication;
            MavenNormalizedPublication mavenNormalizedPublication = mavenPublicationInternal.asNormalisedPublication();
            projectIdentity = mavenNormalizedPublication.getProjectIdentity();
            if (this.isPublishMaven().booleanValue() && (builder2 = this.createBuilder(processedFiles, file2 = mavenNormalizedPublication.getPomFile(), publicationName)) != null) {
                artifactInfo2 = new PublishArtifactInfo(projectIdentity.getArtifactId(), "pom", "pom", null, file2);
                this.addMavenArtifactToDeployDetails(deployDetails, publicationName, (MavenProjectIdentity)projectIdentity, builder2, artifactInfo2);
            }
            artifacts = mavenPublication.getArtifacts();
            for (IvyArtifact artifact : artifacts) {
                file = artifact.getFile();
                builder = this.createBuilder(processedFiles, file, publicationName);
                if (builder == null) continue;
                artifactInfo = new PublishArtifactInfo(projectIdentity.getArtifactId(), artifact.getExtension(), artifact.getExtension(), artifact.getClassifier(), file);
                this.addMavenArtifactToDeployDetails(deployDetails, publicationName, (MavenProjectIdentity)projectIdentity, builder, artifactInfo);
            }
        }
        return deployDetails;
    }

    private DeployDetails.Builder createBuilder(Set<String> processedFiles, File file, String publicationName) {
        if (processedFiles.contains(file.getAbsolutePath())) {
            return null;
        }
        if (!file.exists()) {
            throw new GradleException("File '" + file.getAbsolutePath() + "'" + " does not exist, and need to be published from publication " + publicationName);
        }
        processedFiles.add(file.getAbsolutePath());
        DeployDetails.Builder artifactBuilder = new DeployDetails.Builder().file(file);
        try {
            Map checksums = FileChecksumCalculator.calculateChecksums((File)file, (String[])new String[]{"MD5", "SHA1"});
            artifactBuilder.md5((String)checksums.get("MD5")).sha1((String)checksums.get("SHA1"));
        }
        catch (Exception e) {
            throw new GradleException("Failed to calculate checksums for artifact: " + file.getAbsolutePath(), (Throwable)e);
        }
        return artifactBuilder;
    }

    private Map<String, String> getExtraTokens(PublishArtifactInfo artifactInfo) {
        HashMap extraTokens = Maps.newHashMap();
        if (StringUtils.isNotBlank((String)artifactInfo.getClassifier())) {
            extraTokens.put("classifier", artifactInfo.getClassifier());
        }
        return extraTokens;
    }

    private void addIvyArtifactToDeployDetails(Set<GradleDeployDetails> deployDetails, String publicationName, IvyPublicationIdentity projectIdentity, DeployDetails.Builder builder, PublishArtifactInfo artifactInfo) {
        ArtifactoryClientConfiguration clientConf = this.getArtifactoryClientConfiguration();
        ArtifactoryClientConfiguration.PublisherHandler publisherConf = clientConf.publisher;
        String pattern = "ivy".equals(artifactInfo.getType()) ? publisherConf.getIvyPattern() : publisherConf.getIvyArtifactPattern();
        String gid = projectIdentity.getOrganisation();
        if (publisherConf.isM2Compatible()) {
            gid = gid.replace(".", "/");
        }
        Map<String, String> extraTokens = this.getExtraTokens(artifactInfo);
        builder.artifactPath(IvyPatternHelper.substitute((String)pattern, (String)gid, (String)projectIdentity.getModule(), (String)projectIdentity.getRevision(), (String)artifactInfo.getName(), (String)artifactInfo.getType(), (String)artifactInfo.getExtension(), (String)publicationName, extraTokens, null));
        this.addArtifactInfoToDeployDetails(deployDetails, publicationName, builder, artifactInfo);
    }

    private void addMavenArtifactToDeployDetails(Set<GradleDeployDetails> deployDetails, String publicationName, MavenProjectIdentity projectIdentity, DeployDetails.Builder builder, PublishArtifactInfo artifactInfo) {
        Map<String, String> extraTokens = this.getExtraTokens(artifactInfo);
        builder.artifactPath(IvyPatternHelper.substitute((String)"[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]", (String)projectIdentity.getGroupId().replace(".", "/"), (String)projectIdentity.getArtifactId(), (String)projectIdentity.getVersion(), (String)artifactInfo.getName(), (String)artifactInfo.getType(), (String)artifactInfo.getExtension(), (String)publicationName, extraTokens, null));
        this.addArtifactInfoToDeployDetails(deployDetails, publicationName, builder, artifactInfo);
    }

    private void addArtifactInfoToDeployDetails(Set<GradleDeployDetails> deployDetails, String publicationName, DeployDetails.Builder builder, PublishArtifactInfo artifactInfo) {
        builder.targetRepository(this.getArtifactoryClientConfiguration().publisher.getRepoKey());
        Map<String, String> propsToAdd = this.getPropsToAdd(artifactInfo, publicationName);
        builder.addProperties(propsToAdd);
        DeployDetails details = builder.build();
        deployDetails.add(new GradleDeployDetails(artifactInfo, details, this.getProject()));
    }
}

