/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.task;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.ConfigureUtil;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.DeployDetails;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactSpec;
import org.jfrog.build.extractor.clientConfiguration.ArtifactSpecs;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.gradle.plugin.artifactory.ArtifactoryPluginUtil;
import org.jfrog.gradle.plugin.artifactory.dsl.ArtifactoryPluginConvention;
import org.jfrog.gradle.plugin.artifactory.dsl.PropertiesConfig;
import org.jfrog.gradle.plugin.artifactory.dsl.PublisherConfig;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleArtifactoryClientConfigUpdater;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleBuildInfoExtractor;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleClientLogger;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleDeployDetails;
import org.jfrog.gradle.plugin.artifactory.extractor.PublishArtifactInfo;

public abstract class BuildInfoBaseTask
extends DefaultTask {
    public static final String BUILD_INFO_TASK_NAME = "artifactoryPublish";
    public static final String PUBLISH_ARTIFACTS = "publishArtifacts";
    public static final String PUBLISH_BUILD_INFO = "publishBuildInfo";
    public static final String ARCHIVES_BASE_NAME = "archivesBaseName";
    public static final String PUBLISH_IVY = "publishIvy";
    public static final String PUBLISH_POM = "publishPom";
    private static final Logger log = Logging.getLogger(BuildInfoBaseTask.class);
    @Input
    protected final Multimap<String, CharSequence> properties = ArrayListMultimap.create();
    @Input
    protected final ArtifactSpecs artifactSpecs = new ArtifactSpecs();
    protected final Set<GradleDeployDetails> deployDetails = Sets.newHashSet();
    private final Map<String, Boolean> flags = Maps.newHashMap();
    protected Map<String, String> defaultProps;
    @Input
    private boolean skip = false;

    @Input
    @Optional
    @Nullable
    public Boolean getPublishBuildInfo() {
        return this.getFlag(PUBLISH_BUILD_INFO);
    }

    public void setPublishBuildInfo(Object publishBuildInfo) {
        this.setFlag(PUBLISH_BUILD_INFO, this.toBoolean(publishBuildInfo));
    }

    @Input
    @Optional
    @Nullable
    public Boolean getPublishArtifacts() {
        return this.getFlag(PUBLISH_ARTIFACTS);
    }

    public void setPublishArtifacts(Object publishArtifacts) {
        this.setFlag(PUBLISH_ARTIFACTS, this.toBoolean(publishArtifacts));
    }

    protected Boolean toBoolean(Object o) {
        return Boolean.valueOf(o.toString());
    }

    @Nullable
    protected Boolean getFlag(String flagName) {
        return this.flags.get(flagName);
    }

    protected void setFlag(String flagName, Boolean newValue) {
        this.flags.put(flagName, newValue);
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public Set<GradleDeployDetails> getDeployDetails() {
        return this.deployDetails;
    }

    public void setProperties(Map<String, CharSequence> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        for (Map.Entry<String, CharSequence> entry : props.entrySet()) {
            CharSequence value;
            String key = entry.getKey();
            if (!StringUtils.isNotBlank((String)key) || (value = entry.getValue()) == null) continue;
            this.properties.put((Object)key, (Object)value);
        }
    }

    public ArtifactSpecs getArtifactSpecs() {
        return this.artifactSpecs;
    }

    public void projectsEvaluated() {
        Project project = this.getProject();
        if (this.isSkip()) {
            log.debug("Artifactory plugin artifactoryPublish task '{}' skipped for project '{}'.", (Object)this.getPath(), (Object)project.getName());
            return;
        }
        ArtifactoryPluginConvention convention = ArtifactoryPluginUtil.getArtifactoryConvention(project);
        ArtifactoryClientConfiguration acc = convention.getClientConfig();
        this.artifactSpecs.addAll((Collection)acc.publisher.getArtifactSpecs());
        PublisherConfig config = convention.getPublisherConfig();
        if (config != null) {
            Closure defaultsClosure = config.getDefaultsClosure();
            ConfigureUtil.configure((Closure)defaultsClosure, (Object)((Object)this));
        }
        for (Project sub : project.getSubprojects()) {
            Task subBiTask = (Task)sub.getTasks().findByName(BUILD_INFO_TASK_NAME);
            if (subBiTask == null) continue;
            this.dependsOn(new Object[]{subBiTask});
        }
        this.checkDependsOnArtifactsToPublish(project);
    }

    protected abstract void checkDependsOnArtifactsToPublish(Project var1);

    @Nonnull
    protected Boolean isPublishArtifacts(ArtifactoryClientConfiguration acc) {
        Boolean publishArtifacts = this.getPublishArtifacts();
        if (publishArtifacts == null) {
            return acc.publisher.isPublishArtifacts();
        }
        return publishArtifacts;
    }

    @Nonnull
    protected Boolean isPublishBuildInfo(ArtifactoryClientConfiguration acc) {
        Boolean publishBuildInfo = this.getPublishBuildInfo();
        if (publishBuildInfo == null) {
            return acc.publisher.isPublishBuildInfo();
        }
        return publishBuildInfo;
    }

    protected ArtifactoryClientConfiguration getArtifactoryClientConfiguration() {
        return ArtifactoryPluginUtil.getArtifactoryConvention(this.getProject()).getClientConfig();
    }

    protected Map<String, String> getPropsToAdd(PublishArtifactInfo artifact, String publicationName) {
        if (this.defaultProps == null) {
            this.defaultProps = Maps.newHashMap();
            this.addProps(this.defaultProps, this.properties);
            ArtifactoryClientConfiguration clientConf = this.getArtifactoryClientConfiguration();
            this.defaultProps.putAll((Map<String, String>)clientConf.publisher.getMatrixParams());
        }
        HashMap propsToAdd = Maps.newHashMap(this.defaultProps);
        Project project = this.getProject();
        ArtifactSpec spec = ArtifactSpec.builder().configuration(publicationName).group(project.getGroup().toString()).name(project.getName()).version(project.getVersion().toString()).classifier(artifact.getClassifier()).type(artifact.getType()).build();
        Multimap artifactSpecsProperties = this.artifactSpecs.getProperties(spec);
        this.addProps(propsToAdd, (Multimap<String, CharSequence>)artifactSpecsProperties);
        return propsToAdd;
    }

    private void addProps(Map<String, String> target, Multimap<String, CharSequence> props) {
        for (Map.Entry entry : props.entries()) {
            String key = (String)entry.getKey();
            String value = ((Object)((CharSequence)entry.getValue())).toString();
            if (!target.containsKey(key)) {
                target.put(key, value);
                continue;
            }
            value = target.get(key) + ", " + value;
            target.put(key, value);
        }
    }

    protected abstract void collectDescriptorsAndArtifactsForUpload() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareAndDeploy() throws IOException {
        ArtifactoryClientConfiguration acc = this.getArtifactoryClientConfiguration();
        GradleArtifactoryClientConfigUpdater.setMissingBuildAttributes(acc, this.getProject().getRootProject());
        String contextUrl = acc.publisher.getContextUrl();
        log.debug("Context URL for deployment '{}", (Object)contextUrl);
        String username = acc.publisher.getUsername();
        String password = acc.publisher.getPassword();
        if (StringUtils.isBlank((String)username)) {
            username = "";
        }
        if (StringUtils.isBlank((String)password)) {
            password = "";
        }
        HashSet allDeployDetails = Sets.newHashSet();
        List<BuildInfoBaseTask> orderedTasks = this.getAllBuildInfoTasks();
        for (BuildInfoBaseTask bit : orderedTasks) {
            if (!bit.getDidWork()) continue;
            bit.collectDescriptorsAndArtifactsForUpload();
            allDeployDetails.addAll(bit.deployDetails);
        }
        ArtifactoryBuildInfoClient client = new ArtifactoryBuildInfoClient(contextUrl, username, password, (Log)new GradleClientLogger(log));
        try {
            if (this.isPublishArtifacts(acc).booleanValue()) {
                log.debug("Uploading artifacts to Artifactory at '{}'", (Object)contextUrl);
                IncludeExcludePatterns patterns = new IncludeExcludePatterns(acc.publisher.getIncludePatterns(), acc.publisher.getExcludePatterns());
                this.configureProxy(acc, client);
                this.deployArtifacts(allDeployDetails, client, patterns);
            }
            GradleBuildInfoExtractor gbie = new GradleBuildInfoExtractor(acc, allDeployDetails);
            Build build = gbie.extract(this.getProject().getRootProject());
            this.exportBuildInfo(build, this.getExportFile(acc));
            if (this.isPublishBuildInfo(acc).booleanValue()) {
                this.exportBuildInfo(build, this.getExportFile(acc));
                if (acc.info.isIncremental().booleanValue()) {
                    log.debug("Publishing build info modules to artifactory at: '{}'", (Object)contextUrl);
                    client.sendModuleInfo(build);
                } else {
                    log.debug("Publishing build info to artifactory at: '{}'", (Object)contextUrl);
                    client.sendBuildInfo(build);
                }
            }
        }
        finally {
            client.shutdown();
        }
    }

    protected String getModuleName() {
        Project project = this.getProject();
        if (project.hasProperty(ARCHIVES_BASE_NAME)) {
            return project.property(ARCHIVES_BASE_NAME).toString();
        }
        return project.getName();
    }

    protected File getExportFile(ArtifactoryClientConfiguration clientConf) {
        String fileExportPath = clientConf.getExportFile();
        if (StringUtils.isNotBlank((String)fileExportPath)) {
            return new File(fileExportPath);
        }
        Project rootProject = this.getProject().getRootProject();
        return new File(rootProject.getBuildDir(), "build-info.json");
    }

    protected void configureProxy(ArtifactoryClientConfiguration clientConf, ArtifactoryBuildInfoClient client) {
        ArtifactoryClientConfiguration.ProxyHandler proxy = clientConf.proxy;
        String proxyHost = proxy.getHost();
        if (StringUtils.isNotBlank((String)proxyHost) && proxy.getPort() != null) {
            log.debug("Found proxy host '{}'", (Object)proxyHost);
            String proxyUserName = proxy.getUsername();
            if (StringUtils.isNotBlank((String)proxyUserName)) {
                log.debug("Found proxy user name '{}'", (Object)proxyUserName);
                client.setProxyConfiguration(proxyHost, proxy.getPort().intValue(), proxyUserName, proxy.getPassword());
            } else {
                log.debug("No proxy user name and password found, using anonymous proxy");
                client.setProxyConfiguration(proxyHost, proxy.getPort().intValue());
            }
        }
    }

    protected void exportBuildInfo(Build build, File toFile) throws IOException {
        log.debug("Exporting generated build info to '{}'", (Object)toFile.getAbsolutePath());
        BuildInfoExtractorUtils.saveBuildInfoToFile((Build)build, (File)toFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void collectProjectBuildInfo() throws IOException {
        try {
            log.debug("Task '{}' activated", (Object)this.getPath());
            List<BuildInfoBaseTask> orderedTasks = this.getAllBuildInfoTasks();
            int myIndex = orderedTasks.indexOf((Object)this);
            if (myIndex == -1) {
                log.error("Could not find my own task {} in the task graph!", (Object)this.getPath());
                return;
            }
            if (myIndex == orderedTasks.size() - 1) {
                log.debug("Starting build info extraction for project '{}' using last task in graph '{}'", new Object[]{this.getProject().getPath(), this.getPath()});
                this.prepareAndDeploy();
            }
        }
        finally {
            File file;
            String propertyFilePath = System.getenv("buildInfoConfig.propertiesFile");
            if (StringUtils.isNotBlank((String)propertyFilePath) && (file = new File(propertyFilePath)).exists()) {
                file.delete();
            }
        }
    }

    protected List<BuildInfoBaseTask> getAllBuildInfoTasks() {
        ArrayList<BuildInfoBaseTask> result = new ArrayList<BuildInfoBaseTask>();
        for (Task task : this.getProject().getGradle().getTaskGraph().getAllTasks()) {
            if (!(task instanceof BuildInfoBaseTask)) continue;
            result.add((BuildInfoBaseTask)task);
        }
        return result;
    }

    public void properties(Closure closure) {
        Project project = this.getProject();
        PropertiesConfig propertiesConfig = new PropertiesConfig(project);
        ConfigureUtil.configure((Closure)closure, (Object)propertiesConfig);
        this.artifactSpecs.addAll((Collection)propertiesConfig.getArtifactSpecs());
    }

    private void deployArtifacts(Set<GradleDeployDetails> allDeployDetails, ArtifactoryBuildInfoClient client, IncludeExcludePatterns patterns) throws IOException {
        for (GradleDeployDetails detail : allDeployDetails) {
            DeployDetails deployDetails = detail.getDeployDetails();
            String artifactPath = deployDetails.getArtifactPath();
            if (PatternMatcher.pathConflicts((String)artifactPath, (IncludeExcludePatterns)patterns)) {
                log.log(LogLevel.LIFECYCLE, "Skipping the deployment of '" + artifactPath + "' due to the defined include-exclude patterns.");
                continue;
            }
            client.deployArtifact(deployDetails);
        }
    }

    public abstract boolean hasModules();

    @Nonnull
    protected Boolean isPublishMaven() {
        ArtifactoryClientConfiguration acc = this.getArtifactoryClientConfiguration();
        Boolean publishPom = acc.publisher.isMaven();
        if (publishPom == null) {
            publishPom = this.getPublishPom();
        }
        return publishPom != null ? publishPom : true;
    }

    @Nonnull
    protected Boolean isPublishIvy() {
        ArtifactoryClientConfiguration acc = this.getArtifactoryClientConfiguration();
        Boolean publishIvy = acc.publisher.isIvy();
        if (publishIvy == null) {
            publishIvy = this.getPublishIvy();
        }
        return publishIvy != null ? publishIvy : true;
    }

    @Input
    @Optional
    @Nullable
    public Boolean getPublishIvy() {
        return this.getFlag(PUBLISH_IVY);
    }

    public void setPublishIvy(Object publishIvy) {
        this.setFlag(PUBLISH_IVY, this.toBoolean(publishIvy));
    }

    @Input
    @Optional
    @Nullable
    public Boolean getPublishPom() {
        return this.getFlag(PUBLISH_POM);
    }

    public void setPublishPom(Object publishPom) {
        this.setFlag(PUBLISH_POM, this.toBoolean(publishPom));
    }
}

