/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.extractor;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jfrog.build.api.Agent;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.BlackDuckProperties;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.BuildAgent;
import org.jfrog.build.api.BuildRetention;
import org.jfrog.build.api.BuildType;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.Governance;
import org.jfrog.build.api.IssueTracker;
import org.jfrog.build.api.Issues;
import org.jfrog.build.api.LicenseControl;
import org.jfrog.build.api.MatrixParameter;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.builder.ArtifactBuilder;
import org.jfrog.build.api.builder.BuildInfoBuilder;
import org.jfrog.build.api.builder.DependencyBuilder;
import org.jfrog.build.api.builder.ModuleBuilder;
import org.jfrog.build.api.builder.PromotionStatusBuilder;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.DeployDetails;
import org.jfrog.build.extractor.BuildInfoExtractor;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.gradle.plugin.artifactory.ArtifactoryPluginUtil;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleDeployDetails;
import org.jfrog.gradle.plugin.artifactory.extractor.PublishArtifactInfo;
import org.jfrog.gradle.plugin.artifactory.task.BuildInfoBaseTask;

public class GradleBuildInfoExtractor
implements BuildInfoExtractor<Project, Build> {
    private static final Logger log = Logging.getLogger(GradleBuildInfoExtractor.class);
    private static final String SHA1 = "sha1";
    private static final String MD5 = "md5";
    private final ArtifactoryClientConfiguration clientConf;
    private final Set<GradleDeployDetails> gradleDeployDetails;

    public GradleBuildInfoExtractor(ArtifactoryClientConfiguration clientConf, Set<GradleDeployDetails> gradleDeployDetails) {
        this.clientConf = clientConf;
        this.gradleDeployDetails = gradleDeployDetails;
    }

    public Build extract(Project rootProject) {
        String issueTrackerName;
        String[] notToDelete;
        int minimumDays;
        String buildRetentionMinimumDays;
        String vcsUrl;
        String vcsRevision;
        String principal;
        String buildName = this.clientConf.info.getBuildName();
        BuildInfoBuilder bib = new BuildInfoBuilder(buildName);
        bib.type(BuildType.GRADLE);
        String buildNumber = this.clientConf.info.getBuildNumber();
        bib.number(buildNumber);
        String buildStartedIso = this.clientConf.info.getBuildStarted();
        Date buildStartDate = null;
        try {
            buildStartDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse(buildStartedIso);
        }
        catch (ParseException e) {
            log.error("Build start date format error: " + buildStartedIso, (Throwable)e);
        }
        bib.started(buildStartedIso);
        BuildAgent buildAgent = new BuildAgent(this.clientConf.info.getBuildAgentName(), this.clientConf.info.getBuildAgentVersion());
        bib.buildAgent(buildAgent);
        String agentName = this.clientConf.info.getAgentName();
        String agentVersion = this.clientConf.info.getAgentVersion();
        if (StringUtils.isNotBlank((String)agentName) && StringUtils.isNotBlank((String)agentVersion)) {
            bib.agent(new Agent(agentName, agentVersion));
        } else {
            bib.agent(new Agent(buildAgent.getName(), buildAgent.getVersion()));
        }
        long durationMillis = buildStartDate != null ? System.currentTimeMillis() - buildStartDate.getTime() : 0L;
        bib.durationMillis(durationMillis);
        Set allProjects = rootProject.getAllprojects();
        for (Project project : allProjects) {
            BuildInfoBaseTask buildInfoTask = this.getBuildInfoTask(project);
            if (buildInfoTask == null || !buildInfoTask.hasModules()) continue;
            bib.addModule(this.extractModule(project));
        }
        String parentName = this.clientConf.info.getParentBuildName();
        String parentNumber = this.clientConf.info.getParentBuildNumber();
        if (parentName != null && parentNumber != null) {
            bib.parentName(parentName);
            bib.parentNumber(parentNumber);
        }
        if (StringUtils.isBlank((String)(principal = this.clientConf.info.getPrincipal()))) {
            principal = System.getProperty("user.name");
        }
        bib.principal(principal);
        String artifactoryPrincipal = this.clientConf.publisher.getUsername();
        if (StringUtils.isBlank((String)artifactoryPrincipal)) {
            artifactoryPrincipal = System.getProperty("user.name");
        }
        bib.artifactoryPrincipal(artifactoryPrincipal);
        String buildUrl = this.clientConf.info.getBuildUrl();
        if (StringUtils.isNotBlank((String)buildUrl)) {
            bib.url(buildUrl);
        }
        if (StringUtils.isNotBlank((String)(vcsRevision = this.clientConf.info.getVcsRevision()))) {
            bib.vcsRevision(vcsRevision);
        }
        if (StringUtils.isNotBlank((String)(vcsUrl = this.clientConf.info.getVcsUrl()))) {
            bib.vcsUrl(vcsUrl);
        }
        LicenseControl licenseControl = new LicenseControl(this.clientConf.info.licenseControl.isRunChecks().booleanValue());
        String notificationRecipients = this.clientConf.info.licenseControl.getViolationRecipients();
        if (StringUtils.isNotBlank((String)notificationRecipients)) {
            licenseControl.setLicenseViolationsRecipientsList(notificationRecipients);
        }
        licenseControl.setIncludePublishedArtifacts(this.clientConf.info.licenseControl.isIncludePublishedArtifacts().booleanValue());
        String scopes = this.clientConf.info.licenseControl.getScopes();
        if (StringUtils.isNotBlank((String)scopes)) {
            licenseControl.setScopesList(scopes);
        }
        licenseControl.setAutoDiscover(this.clientConf.info.licenseControl.isAutoDiscover().booleanValue());
        bib.licenseControl(licenseControl);
        BlackDuckProperties blackDuckProperties = this.clientConf.info.blackDuckProperties.isRunChecks() ? this.clientConf.info.blackDuckProperties.copyBlackDuckProperties() : new BlackDuckProperties();
        Governance governance = new Governance();
        governance.setBlackDuckProperties(blackDuckProperties);
        bib.governance(governance);
        BuildRetention buildRetention = new BuildRetention(this.clientConf.info.isDeleteBuildArtifacts().booleanValue());
        Integer count = this.clientConf.info.getBuildRetentionCount();
        if (count != null) {
            buildRetention.setCount(count.intValue());
        }
        if (StringUtils.isNotBlank((String)(buildRetentionMinimumDays = this.clientConf.info.getBuildRetentionMinimumDate())) && (minimumDays = Integer.parseInt(buildRetentionMinimumDays)) > -1) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, -minimumDays);
            buildRetention.setMinimumBuildDate(calendar.getTime());
        }
        for (String notToDel : notToDelete = this.clientConf.info.getBuildNumbersNotToDelete()) {
            buildRetention.addBuildNotToBeDiscarded(notToDel);
        }
        bib.buildRetention(buildRetention);
        if (this.clientConf.info.isReleaseEnabled().booleanValue()) {
            String stagingRepository = this.clientConf.publisher.getRepoKey();
            String comment = this.clientConf.info.getReleaseComment();
            if (comment == null) {
                comment = "";
            }
            bib.addStatus(new PromotionStatusBuilder("Staged").timestampDate(buildStartDate).comment(comment).repository(stagingRepository).ciUser(principal).user(artifactoryPrincipal).build());
        }
        if (StringUtils.isNotBlank((String)(issueTrackerName = this.clientConf.info.issues.getIssueTrackerName()))) {
            Issues issues = new Issues();
            issues.setAggregateBuildIssues(this.clientConf.info.issues.getAggregateBuildIssues());
            issues.setAggregationBuildStatus(this.clientConf.info.issues.getAggregationBuildStatus());
            issues.setTracker(new IssueTracker(issueTrackerName, this.clientConf.info.issues.getIssueTrackerVersion()));
            Set affectedIssuesSet = this.clientConf.info.issues.getAffectedIssuesSet();
            if (!affectedIssuesSet.isEmpty()) {
                issues.setAffectedIssues(affectedIssuesSet);
            }
            bib.issues(issues);
        }
        for (Map.Entry runParam : this.clientConf.info.getRunParameters().entrySet()) {
            MatrixParameter matrixParameter = new MatrixParameter((String)runParam.getKey(), (String)runParam.getValue());
            bib.addRunParameters(matrixParameter);
        }
        if (this.clientConf.isIncludeEnvVars().booleanValue()) {
            Properties envProperties = new Properties();
            envProperties.putAll((Map<?, ?>)this.clientConf.getAllProperties());
            envProperties = BuildInfoExtractorUtils.getEnvProperties((Properties)envProperties, (Log)this.clientConf.getLog());
            for (Map.Entry<Object, Object> envProp : envProperties.entrySet()) {
                bib.addProperty(envProp.getKey(), envProp.getValue());
            }
        }
        log.debug("buildInfoBuilder = " + bib);
        Build build = bib.build();
        if (parentName != null && parentNumber != null) {
            build.setParentBuildId(parentName);
        }
        return build;
    }

    private BuildInfoBaseTask getBuildInfoTask(Project project) {
        Set tasks = project.getTasksByName("artifactoryPublish", false);
        if (tasks.isEmpty()) {
            return null;
        }
        BuildInfoBaseTask buildInfoTask = (BuildInfoBaseTask)((Object)tasks.iterator().next());
        if (buildInfoTask.getState().getDidWork()) {
            return buildInfoTask;
        }
        return null;
    }

    public Module extractModule(Project project) {
        String artifactName = project.getName();
        BuildInfoBaseTask task = this.getBuildInfoTask(project);
        if (task != null) {
            artifactName = project.getName();
        }
        ModuleBuilder builder = new ModuleBuilder().id(BuildInfoExtractorUtils.getModuleIdString((String)project.getGroup().toString(), (String)artifactName, (String)project.getVersion().toString()));
        try {
            ArtifactoryClientConfiguration.PublisherHandler publisher = ArtifactoryPluginUtil.getArtifactoryConvention((Project)project).getClientConfig().publisher;
            boolean excludeArtifactsFromBuild = publisher.isFilterExcludedArtifactsFromBuild();
            IncludeExcludePatterns patterns = new IncludeExcludePatterns(publisher.getIncludePatterns(), publisher.getExcludePatterns());
            Iterable<GradleDeployDetails> deployExcludeDetails = null;
            Iterable deployIncludeDetails = null;
            if (excludeArtifactsFromBuild) {
                deployIncludeDetails = Iterables.filter(this.gradleDeployDetails, (Predicate)new IncludeExcludePredicate(project, patterns, true));
                deployExcludeDetails = Iterables.filter(this.gradleDeployDetails, (Predicate)new IncludeExcludePredicate(project, patterns, false));
            } else {
                deployIncludeDetails = Iterables.filter(this.gradleDeployDetails, (Predicate)new ProjectPredicate(project));
                deployExcludeDetails = new ArrayList<GradleDeployDetails>();
            }
            builder.artifacts(this.calculateArtifacts(deployIncludeDetails)).excludedArtifacts(this.calculateArtifacts(deployExcludeDetails)).dependencies(this.calculateDependencies(project));
        }
        catch (Exception e) {
            log.error("Error during extraction: ", (Throwable)e);
        }
        return builder.build();
    }

    private List<Artifact> calculateArtifacts(Iterable<GradleDeployDetails> deployDetails) throws Exception {
        ArrayList artifacts = Lists.newArrayList((Iterable)Iterables.transform(deployDetails, (Function)new Function<GradleDeployDetails, Artifact>(){

            public Artifact apply(GradleDeployDetails from) {
                PublishArtifactInfo publishArtifact = from.getPublishArtifact();
                DeployDetails deployDetails = from.getDeployDetails();
                String artifactPath = deployDetails.getArtifactPath();
                int index = artifactPath.lastIndexOf(47);
                return new ArtifactBuilder(artifactPath.substring(index + 1)).type(BuildInfoExtractorUtils.getTypeString((String)publishArtifact.getType(), (String)publishArtifact.getClassifier(), (String)publishArtifact.getExtension())).md5(deployDetails.getMd5()).sha1(deployDetails.getSha1()).build();
            }
        }));
        return artifacts;
    }

    private List<Dependency> calculateDependencies(Project project) throws Exception {
        ConfigurationContainer configurationSet = project.getConfigurations();
        ArrayList dependencies = Lists.newArrayList();
        for (Configuration configuration : configurationSet) {
            if (configuration.getState() != Configuration.State.RESOLVED) {
                log.info("Artifacts for configuration '{}' were not all resolved, skipping", (Object)configuration.getName());
                continue;
            }
            ResolvedConfiguration resolvedConfiguration = configuration.getResolvedConfiguration();
            Set resolvedArtifactSet = resolvedConfiguration.getResolvedArtifacts();
            for (ResolvedArtifact artifact : resolvedArtifactSet) {
                File file = artifact.getFile();
                if (file == null || !file.exists()) continue;
                ModuleVersionIdentifier id = artifact.getModuleVersion().getId();
                final String depId = BuildInfoExtractorUtils.getModuleIdString((String)id.getGroup(), (String)id.getName(), (String)id.getVersion());
                Predicate<Dependency> idEqualsPredicate = new Predicate<Dependency>(){

                    public boolean apply(@Nullable Dependency input) {
                        return input.getId().equals(depId);
                    }
                };
                if (Iterables.any((Iterable)dependencies, (Predicate)idEqualsPredicate)) {
                    Dependency existingDependency = (Dependency)Iterables.find((Iterable)dependencies, (Predicate)idEqualsPredicate);
                    Set existingScopes = existingDependency.getScopes();
                    existingScopes.add(configuration.getName());
                    existingDependency.setScopes(existingScopes);
                    continue;
                }
                Map checksums = FileChecksumCalculator.calculateChecksums((File)file, (String[])new String[]{MD5, SHA1});
                DependencyBuilder dependencyBuilder = new DependencyBuilder().type(BuildInfoExtractorUtils.getTypeString((String)artifact.getType(), (String)artifact.getClassifier(), (String)artifact.getExtension())).id(depId).scopes((Set)Sets.newHashSet((Object[])new String[]{configuration.getName()})).md5((String)checksums.get(MD5)).sha1((String)checksums.get(SHA1));
                dependencies.add(dependencyBuilder.build());
            }
        }
        return dependencies;
    }

    private class IncludeExcludePredicate
    implements Predicate<GradleDeployDetails> {
        private Project project;
        private IncludeExcludePatterns patterns;
        private boolean include;

        public IncludeExcludePredicate(Project project, IncludeExcludePatterns patterns, boolean isInclude) {
            this.project = project;
            this.patterns = patterns;
            this.include = isInclude;
        }

        public boolean apply(@Nullable GradleDeployDetails input) {
            if (this.include) {
                return input.getProject().equals(this.project) && !PatternMatcher.pathConflicts((String)input.getDeployDetails().getArtifactPath(), (IncludeExcludePatterns)this.patterns);
            }
            return input.getProject().equals(this.project) && PatternMatcher.pathConflicts((String)input.getDeployDetails().getArtifactPath(), (IncludeExcludePatterns)this.patterns);
        }
    }

    private class ProjectPredicate
    implements Predicate<GradleDeployDetails> {
        private final Project project;

        private ProjectPredicate(Project project) {
            this.project = project;
        }

        public boolean apply(@Nullable GradleDeployDetails input) {
            return input.getProject().equals(this.project);
        }
    }
}

