/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u0011\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinPropertyMapping;", "T", "", "projectPropName", "", "taskPropName", "transform", "Lkotlin/Function1;", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "apply", "", "properties", "Ljava/util/Properties;", "task", "Lorg/gradle/api/tasks/compile/AbstractCompile;", "project", "Lorg/gradle/api/Project;", "setPropertyValue", "value", "kotlin-gradle-plugin"})
final class KotlinPropertyMapping<T> {
    private final String projectPropName;
    private final String taskPropName;
    private final Function1<String, T> transform;

    public final void apply(@NotNull Project project, @NotNull AbstractCompile task) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        if (!project.hasProperty(this.projectPropName)) {
            return;
        }
        this.setPropertyValue(task, project.property(this.projectPropName));
    }

    public final void apply(@NotNull Properties properties, @NotNull AbstractCompile task) {
        Intrinsics.checkParameterIsNotNull((Object)properties, (String)"properties");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        this.setPropertyValue(task, properties.getProperty(this.projectPropName));
    }

    private final void setPropertyValue(AbstractCompile task, Object value) {
        if (!(value instanceof String)) {
            return;
        }
        Object object = this.transform.invoke(value);
        if (object == null) {
            return;
        }
        Object transformedValue = object;
        task.setProperty(this.taskPropName, transformedValue);
    }

    public KotlinPropertyMapping(@NotNull String projectPropName, @NotNull String taskPropName, @NotNull Function1<? super String, ? extends T> transform) {
        Intrinsics.checkParameterIsNotNull((Object)projectPropName, (String)"projectPropName");
        Intrinsics.checkParameterIsNotNull((Object)taskPropName, (String)"taskPropName");
        Intrinsics.checkParameterIsNotNull(transform, (String)"transform");
        this.projectPropName = projectPropName;
        this.taskPropName = taskPropName;
        this.transform = transform;
    }
}

