/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.registry;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.LoadingState;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.RegistryValue;

public final class Registry {
    private static Reference<Map<String, String>> bundledRegistry;
    private final Map<String, String> myUserProperties = new LinkedHashMap<String, String>();
    private final Map<String, RegistryValue> myValues = new ConcurrentHashMap<String, RegistryValue>();
    private Map<String, RegistryKeyDescriptor> myContributedKeys = Collections.emptyMap();
    private static final Registry ourInstance;
    private volatile boolean isLoaded;

    @NotNull
    public static RegistryValue get(@NonNls @NotNull String key) {
        if (key == null) {
            Registry.$$$reportNull$$$0(0);
        }
        return Registry.getInstance().doGet(key);
    }

    @NotNull
    private RegistryValue doGet(@NonNls @NotNull String key) {
        if (key == null) {
            Registry.$$$reportNull$$$0(2);
        }
        RegistryValue registryValue = this.myValues.computeIfAbsent(key, s -> new RegistryValue(this, (String)s, this.myContributedKeys.get(s)));
        if (registryValue == null) {
            Registry.$$$reportNull$$$0(3);
        }
        return registryValue;
    }

    public static boolean is(@NonNls @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(4);
        }
        return Registry.get(key).asBoolean();
    }

    public static boolean is(@NonNls @NotNull String key, boolean defaultValue) {
        if (key == null) {
            Registry.$$$reportNull$$$0(5);
        }
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            LoadingState.LAF_INITIALIZED.checkOccurred();
            return defaultValue;
        }
        try {
            return Registry.getInstance().doGet(key).asBoolean();
        }
        catch (MissingResourceException ignore) {
            return defaultValue;
        }
    }

    public static int intValue(@NonNls @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(6);
        }
        return Registry.getInstance().doGet(key).asInteger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Map<String, String> loadFromBundledConfig() throws IOException {
        Map<String, String> result2;
        Reference<Map<String, String>> bundleRef = bundledRegistry;
        Map<String, String> map = result2 = bundleRef == null ? null : bundleRef.get();
        if (result2 != null) {
            return result2;
        }
        InputStream stream = Registry.class.getClassLoader().getResourceAsStream("misc/registry.properties");
        if (stream == null) {
            return null;
        }
        final HashMap<String, String> map2 = new HashMap<String, String>(1800);
        try {
            new Properties(){

                @Override
                public Object put(Object key, Object value2) {
                    return map2.put((String)key, (String)value2);
                }
            }.load(stream);
        }
        finally {
            stream.close();
        }
        bundledRegistry = new SoftReference(map2);
        return map2;
    }

    @Nullable
    public String getBundleValueOrNull(@NonNls @NotNull String key) {
        RegistryKeyDescriptor contributed;
        if (key == null) {
            Registry.$$$reportNull$$$0(13);
        }
        if ((contributed = this.myContributedKeys.get(key)) != null) {
            return contributed.getDefaultValue();
        }
        try {
            Map<String, String> bundle = Registry.loadFromBundledConfig();
            return bundle == null ? null : bundle.get(key);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    String getBundleValue(@NonNls @NotNull String key) throws MissingResourceException {
        RegistryKeyDescriptor contributed;
        if (key == null) {
            Registry.$$$reportNull$$$0(14);
        }
        if ((contributed = this.myContributedKeys.get(key)) != null) {
            String string2 = contributed.getDefaultValue();
            if (string2 == null) {
                Registry.$$$reportNull$$$0(15);
            }
            return string2;
        }
        String result2 = this.getBundleValueOrNull(key);
        if (result2 == null) {
            throw new MissingResourceException("Registry key " + key + " is not defined", "misc.registry", key);
        }
        String string3 = result2;
        if (string3 == null) {
            Registry.$$$reportNull$$$0(16);
        }
        return string3;
    }

    @NotNull
    public static Registry getInstance() {
        LoadingState.COMPONENTS_LOADED.checkOccurred();
        Registry registry = ourInstance;
        if (registry == null) {
            Registry.$$$reportNull$$$0(17);
        }
        return registry;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    @NotNull
    Map<String, String> getUserProperties() {
        Map<String, String> map = this.myUserProperties;
        if (map == null) {
            Registry.$$$reportNull$$$0(19);
        }
        return map;
    }

    static {
        ourInstance = new Registry();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/registry/Registry";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/registry/Registry";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doGet";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "stringValue";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleValue";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserProperties";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_getWithoutStateCheck";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doGet";
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "intValue";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doubleValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "stringValue";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBundleValueOrNull";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getBundleValue";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isRestartNeeded";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setKeys";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "mutateContributedKeys";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

