/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kotlinx.coroutines.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kotlinx.coroutines.InternalCoroutinesApi;
import org.jetbrains.kotlin.kotlinx.coroutines.internal.ThreadSafeHeapNode;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000*\u0012\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00060\u0004j\u0002`\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000H\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J$\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00028\u00002\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016H\u0086\b\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u0018\u001a\u00020\u0010J\u000f\u0010\u0019\u001a\u0004\u0018\u00018\u0000H\u0001\u00a2\u0006\u0002\u0010\u001aJ\r\u0010\u001b\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\bH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0013\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0015\u0010 \u001a\u00028\u00002\u0006\u0010!\u001a\u00020\u000eH\u0001\u00a2\u0006\u0002\u0010\"J$\u0010#\u001a\u0004\u0018\u00018\u00002\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0%H\u0086\b\u00a2\u0006\u0002\u0010&J\r\u0010'\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0011\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u000eH\u0082\u0010J\u0011\u0010*\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u000eH\u0082\u0010J\u0018\u0010+\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u000eH\u0002R\u001a\u0010\u0007\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0012\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/kotlinx/coroutines/internal/ThreadSafeHeap;", "T", "Lorg/jetbrains/kotlin/kotlinx/coroutines/internal/ThreadSafeHeapNode;", "", "", "Lorg/jetbrains/kotlin/kotlinx/coroutines/internal/SynchronizedObject;", "()V", "a", "", "[Lorg/jetbrains/kotlin/kotlinx/coroutines/internal/ThreadSafeHeapNode;", "isEmpty", "", "()Z", "size", "", "addImpl", "", "node", "(Lkotlinx/coroutines/internal/ThreadSafeHeapNode;)V", "addLast", "addLastIf", "cond", "Lkotlin/Function0;", "(Lkotlinx/coroutines/internal/ThreadSafeHeapNode;Lkotlin/jvm/functions/Function0;)Z", "clear", "firstImpl", "()Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "peek", "realloc", "()[Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "remove", "(Lkotlinx/coroutines/internal/ThreadSafeHeapNode;)Z", "removeAtImpl", "index", "(I)Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "removeFirstIf", "predicate", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "removeFirstOrNull", "siftDownFrom", "i", "siftUpFrom", "swap", "j", "kotlinx-coroutines-core"})
@InternalCoroutinesApi
public final class ThreadSafeHeap<T extends ThreadSafeHeapNode & Comparable<? super T>> {
    private T[] a;
    @JvmField
    public volatile int size;

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final synchronized void clear() {
        Arrays.fill(this.a, 0, this.size, null);
        this.size = 0;
    }

    @Nullable
    public final synchronized T peek() {
        return this.firstImpl();
    }

    @Nullable
    public final synchronized T removeFirstOrNull() {
        return this.size > 0 ? (T)this.removeAtImpl(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Nullable
    public final T removeFirstIf(@NotNull Function1<? super T, Boolean> predicate) {
        block5: {
            int $i$f$removeFirstIf = 0;
            Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
            ThreadSafeHeap lock$iv = this;
            boolean $i$f$synchronized = false;
            boolean bl = false;
            boolean bl2 = false;
            // MONITORENTER : lock$iv
            boolean bl3 = false;
            if (this.firstImpl() != null) break block5;
            T t = null;
            InlineMarker.finallyStart((int)2);
            // MONITOREXIT : lock$iv
            InlineMarker.finallyEnd((int)2);
            return t;
        }
        try {
            T t;
            T first2 = t;
            T t2 = ((Boolean)predicate.invoke(first2)).booleanValue() ? (T)this.removeAtImpl(0) : null;
            return t2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
        }
    }

    public final synchronized void addLast(@NotNull T node) {
        Intrinsics.checkParameterIsNotNull(node, (String)"node");
        this.addImpl(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addLastIf(@NotNull T node, @NotNull Function0<Boolean> cond) {
        int $i$f$addLastIf = 0;
        Intrinsics.checkParameterIsNotNull(node, (String)"node");
        Intrinsics.checkParameterIsNotNull(cond, (String)"cond");
        ThreadSafeHeap lock$iv = this;
        boolean $i$f$synchronized = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (lock$iv) {
            try {
                boolean bl3;
                boolean bl4 = false;
                if (((Boolean)cond.invoke()).booleanValue()) {
                    this.addImpl(node);
                    bl3 = true;
                } else {
                    bl3 = false;
                }
                bl2 = bl3;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl21 : MonitorExitStatement: MONITOREXIT : lock$iv
                InlineMarker.finallyEnd((int)1);
            }
            return bl2;
        }
    }

    public final synchronized boolean remove(@NotNull T node) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(node, (String)"node");
        if (node.getHeap() == null) {
            bl = false;
        } else {
            int index2 = node.getIndex();
            boolean bl2 = index2 >= 0;
            boolean bl3 = false;
            boolean bl4 = false;
            bl4 = false;
            boolean bl5 = false;
            if (!bl2) {
                boolean bl6 = false;
                String string2 = "Check failed.";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            this.removeAtImpl(index2);
            bl = true;
        }
        return bl;
    }

    @PublishedApi
    @Nullable
    public final T firstImpl() {
        return (T)(this.a != null ? this.a[0] : null);
    }

    /*
     * Unable to fully structure code
     */
    @PublishedApi
    @NotNull
    public final T removeAtImpl(int index) {
        block8: {
            var2_2 = this.size > 0;
            var3_4 = 0;
            var4_6 = false;
            var4_6 = false;
            var5_7 = false;
            if (!var2_2) {
                var6_9 = false;
                var5_8 = "Check failed.";
                throw (Throwable)new IllegalStateException(var5_8.toString());
            }
            if (this.a == null) {
                Intrinsics.throwNpe();
            }
            a = this.a;
            var3_4 = this.size;
            this.size = var3_4 + -1;
            if (index >= this.size) break block8;
            this.swap(index, this.size);
            j = (index - 1) / 2;
            if (index <= 0) ** GOTO lbl-1000
            v0 = a[index];
            if (v0 == null) {
                Intrinsics.throwNpe();
            }
            v1 = (Comparable)v0;
            v2 = a[j];
            if (v2 == null) {
                Intrinsics.throwNpe();
            }
            if (v1.compareTo(v2) < 0) {
                this.swap(index, j);
                this.siftUpFrom(j);
            } else lbl-1000:
            // 2 sources

            {
                this.siftDownFrom(index);
            }
        }
        v3 = a[this.size];
        if (v3 == null) {
            Intrinsics.throwNpe();
        }
        var4_6 = (result = v3).getHeap() == this;
        var5_7 = false;
        var6_10 = false;
        var6_10 = false;
        var7_11 = false;
        if (!var4_6) {
            var8_13 = false;
            var7_12 = "Check failed.";
            throw (Throwable)new IllegalStateException(var7_12.toString());
        }
        result.setHeap(null);
        result.setIndex(-1);
        a[this.size] = null;
        return result;
    }

    @PublishedApi
    public final void addImpl(@NotNull T node) {
        Intrinsics.checkParameterIsNotNull(node, (String)"node");
        boolean bl = node.getHeap() == null;
        boolean bl2 = false;
        int n = 0;
        n = 0;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Check failed.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        node.setHeap(this);
        ThreadSafeHeapNode[] a = this.realloc();
        n = this.size;
        this.size = n + 1;
        int i = n;
        a[i] = node;
        node.setIndex(i);
        this.siftUpFrom(i);
    }

    private final void siftUpFrom(int i) {
        while (i > 0) {
            if (this.a == null) {
                Intrinsics.throwNpe();
            }
            T[] a = this.a;
            int j = (i - 1) / 2;
            T t = a[j];
            if (t == null) {
                Intrinsics.throwNpe();
            }
            Comparable comparable = (Comparable)t;
            T t2 = a[i];
            if (t2 == null) {
                Intrinsics.throwNpe();
            }
            if (comparable.compareTo(t2) <= 0) {
                return;
            }
            this.swap(i, j);
            i = j;
        }
        return;
    }

    private final void siftDownFrom(int i) {
        int j;
        while ((j = 2 * i + 1) < this.size) {
            if (this.a == null) {
                Intrinsics.throwNpe();
            }
            T[] a = this.a;
            if (j + 1 < this.size) {
                T t = a[j + 1];
                if (t == null) {
                    Intrinsics.throwNpe();
                }
                Comparable comparable = (Comparable)t;
                T t2 = a[j];
                if (t2 == null) {
                    Intrinsics.throwNpe();
                }
                if (comparable.compareTo(t2) < 0) {
                    ++j;
                }
            }
            T t = a[i];
            if (t == null) {
                Intrinsics.throwNpe();
            }
            Comparable comparable = (Comparable)t;
            T t3 = a[j];
            if (t3 == null) {
                Intrinsics.throwNpe();
            }
            if (comparable.compareTo(t3) <= 0) {
                return;
            }
            this.swap(i, j);
            i = j;
        }
        return;
    }

    private final T[] realloc() {
        Object[] objectArray;
        T[] a = this.a;
        if (a == null) {
            ThreadSafeHeapNode[] threadSafeHeapNodeArray = new ThreadSafeHeapNode[4];
            boolean bl = false;
            boolean bl2 = false;
            ThreadSafeHeapNode[] it = threadSafeHeapNodeArray;
            boolean bl3 = false;
            this.a = it;
            objectArray = threadSafeHeapNodeArray;
        } else if (this.size >= a.length) {
            T[] TArray = a;
            int n = this.size * 2;
            boolean bl = false;
            T[] TArray2 = Arrays.copyOf(TArray, n);
            Intrinsics.checkExpressionValueIsNotNull(TArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
            TArray = TArray2;
            n = 0;
            bl = false;
            ThreadSafeHeapNode[] it = (ThreadSafeHeapNode[])TArray;
            boolean bl4 = false;
            this.a = it;
            objectArray = (ThreadSafeHeapNode[])TArray;
        } else {
            objectArray = a;
        }
        return objectArray;
    }

    private final void swap(int i, int j) {
        if (this.a == null) {
            Intrinsics.throwNpe();
        }
        T[] a = this.a;
        T t = a[j];
        if (t == null) {
            Intrinsics.throwNpe();
        }
        T ni = t;
        T t2 = a[i];
        if (t2 == null) {
            Intrinsics.throwNpe();
        }
        T nj = t2;
        a[i] = ni;
        a[j] = nj;
        ni.setIndex(i);
        nj.setIndex(j);
    }
}

