/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.common.Symbol;
import org.jetbrains.kotlin.js.util.AstUtil;

public final class JsNameRef
extends JsExpression
implements HasName {
    private String ident;
    private JsName name;
    private JsExpression qualifier;

    public JsNameRef(@NotNull JsName name) {
        this.name = name;
    }

    public JsNameRef(@NotNull String ident) {
        this.ident = ident;
    }

    public JsNameRef(@NotNull String ident, JsExpression qualifier) {
        this.ident = ident;
        this.qualifier = qualifier;
    }

    public JsNameRef(@NotNull String ident, @NotNull String qualifier) {
        this(ident, (JsExpression)new JsNameRef(qualifier));
    }

    public JsNameRef(@NotNull JsName name, JsExpression qualifier) {
        this.name = name;
        this.qualifier = qualifier;
    }

    @NotNull
    public String getIdent() {
        return this.name == null ? this.ident : this.name.getIdent();
    }

    @Override
    @Nullable
    public JsName getName() {
        return this.name;
    }

    @Override
    public void setName(JsName name) {
        this.name = name;
    }

    @Override
    @Nullable
    public Symbol getSymbol() {
        return this.name;
    }

    @Nullable
    public JsExpression getQualifier() {
        return this.qualifier;
    }

    @Override
    public boolean isLeaf() {
        return this.qualifier == null;
    }

    public void resolve(JsName name) {
        this.name = name;
        this.ident = null;
    }

    public void setQualifier(JsExpression qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitNameRef(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        if (this.qualifier != null) {
            visitor2.accept(this.qualifier);
        }
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx) && this.qualifier != null) {
            this.qualifier = v.accept(this.qualifier);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsNameRef deepCopy() {
        JsExpression qualifierCopy = AstUtil.deepCopy(this.qualifier);
        if (this.name != null) {
            return new JsNameRef(this.name, qualifierCopy).withMetadataFrom(this);
        }
        return new JsNameRef(this.ident, qualifierCopy).withMetadataFrom(this);
    }
}

