/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorCallExpressionImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorExpressionImpl;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012J1\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0010\b\u0002\u0010\u0010\u001a\n\u0018\u00010\u0011j\u0004\u0018\u0001`\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H\u0082\bJ\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/ErrorExpressionGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "ignoreErrors", "", "getIgnoreErrors", "()Z", "generateErrorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ktCall", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "generateErrorExpression", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "body", "Lkotlin/Function0;", "generateErrorSimpleName", "ktName", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "getErrorExpressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "ktExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin-compiler"})
public final class ErrorExpressionGenerator
extends StatementGeneratorExtension {
    private final boolean getIgnoreErrors() {
        return this.getContext().getConfiguration().getIgnoreErrors();
    }

    @NotNull
    public final IrExpression generateErrorExpression(@NotNull KtElement ktElement, @NotNull Exception e) {
        String string;
        KotlinType kotlinType;
        int n;
        int n2;
        Intrinsics.checkParameterIsNotNull(ktElement, "ktElement");
        Intrinsics.checkParameterIsNotNull(e, "e");
        ErrorExpressionGenerator this_$iv = this;
        if (this_$iv.getIgnoreErrors()) {
            n2 = PsiUtilsKt.getStartOffset(ktElement);
            n = PsiUtilsKt.getEndOffset(ktElement);
            if (ktElement instanceof KtExpression) {
                kotlinType = this.getErrorExpressionType((KtExpression)ktElement);
            } else {
                SimpleType simpleType2 = ErrorUtils.createErrorType("");
                Intrinsics.checkExpressionValueIsNotNull(simpleType2, "ErrorUtils.createErrorType(\"\")");
                kotlinType = simpleType2;
            }
            if ((string = e.getMessage()) == null) {
                string = "";
            }
        } else {
            throw (Throwable)new RuntimeException(e.getMessage() + ": " + ktElement.getClass().getSimpleName() + ":" + "\n" + ktElement.getText(), e);
        }
        return new IrErrorExpressionImpl(n2, n, kotlinType, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrExpression generateErrorCall(@NotNull KtCallExpression ktCall) {
        IrErrorCallExpressionImpl irErrorCall;
        void this_$iv;
        Exception e$iv;
        Intrinsics.checkParameterIsNotNull(ktCall, "ktCall");
        ErrorExpressionGenerator errorExpressionGenerator = this;
        Object var3_3 = null;
        int n = 2;
        Object var5_5 = null;
        if ((n & 2) != 0) {
            e$iv = null;
        }
        if (((ErrorExpressionGenerator)this_$iv).getIgnoreErrors()) {
            KtValueArgument it;
            IrExpression irExpression;
            KotlinType type2 = this.getErrorExpressionType(ktCall);
            IrErrorCallExpressionImpl irErrorCallExpressionImpl = irErrorCall = new IrErrorCallExpressionImpl(PsiUtilsKt.getStartOffset(ktCall), PsiUtilsKt.getEndOffset(ktCall), type2, "");
            PsiElement psiElement = ktCall.getParent();
            if (!(psiElement instanceof KtDotQualifiedExpression)) {
                psiElement = null;
            }
            KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)psiElement;
            if (ktDotQualifiedExpression != null) {
                KtDotQualifiedExpression ktDotQualifiedExpression2 = ktDotQualifiedExpression;
                IrErrorCallExpressionImpl irErrorCallExpressionImpl2 = irErrorCallExpressionImpl;
                KtDotQualifiedExpression it2 = ktDotQualifiedExpression2;
                IrExpression irExpression2 = this.getStatementGenerator().generateExpression(it2.getReceiverExpression());
                irErrorCallExpressionImpl = irErrorCallExpressionImpl2;
                irExpression = irExpression2;
            } else {
                irExpression = null;
            }
            irErrorCallExpressionImpl.setExplicitReceiver(irExpression);
            Iterable $receiver$iv = ktCall.getValueArguments();
            for (Object element$iv : $receiver$iv) {
                it = (KtValueArgument)element$iv;
                KtExpression ktArgument = it.getArgumentExpression();
                if (ktArgument == null) continue;
                irErrorCall.addArgument(this.getStatementGenerator().generateExpression(ktArgument));
            }
            $receiver$iv = ktCall.getLambdaArguments();
            for (Object element$iv : $receiver$iv) {
                it = (KtLambdaArgument)element$iv;
                StatementGenerator statementGenerator = this.getStatementGenerator();
                KtExpression ktExpression = ((KtLambdaArgument)it).getArgumentExpression();
                Intrinsics.checkExpressionValueIsNotNull(ktExpression, "it.getArgumentExpression()");
                irErrorCall.addArgument(statementGenerator.generateExpression(ktExpression));
            }
        } else {
            throw (Throwable)new RuntimeException(null + ": " + ((KtElement)ktCall).getClass().getSimpleName() + ":" + "\n" + ((KtElement)ktCall).getText(), e$iv);
        }
        return irErrorCall;
    }

    private final KotlinType getErrorExpressionType(KtExpression ktExpression) {
        KotlinType kotlinType = GeneratorKt.getInferredTypeWithImplicitCasts(this, ktExpression);
        if (kotlinType == null) {
            SimpleType simpleType2 = ErrorUtils.createErrorType("");
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "ErrorUtils.createErrorType(\"\")");
            kotlinType = simpleType2;
        }
        return kotlinType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrExpression generateErrorSimpleName(@NotNull KtSimpleNameExpression ktName) {
        IrExpression irExpression;
        IrErrorCallExpressionImpl irErrorCallExpressionImpl;
        IrErrorCallExpressionImpl irErrorCall;
        void this_$iv;
        Exception e$iv;
        Intrinsics.checkParameterIsNotNull(ktName, "ktName");
        ErrorExpressionGenerator errorExpressionGenerator = this;
        Object var3_3 = null;
        int n = 2;
        Object var5_5 = null;
        if ((n & 2) != 0) {
            e$iv = null;
        }
        if (((ErrorExpressionGenerator)this_$iv).getIgnoreErrors()) {
            KotlinType type2 = this.getErrorExpressionType(ktName);
            irErrorCallExpressionImpl = irErrorCall = new IrErrorCallExpressionImpl(PsiUtilsKt.getStartOffset(ktName), PsiUtilsKt.getEndOffset(ktName), type2, "");
            PsiElement psiElement = ktName.getParent();
            if (!(psiElement instanceof KtDotQualifiedExpression)) {
                psiElement = null;
            }
            KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)psiElement;
            if (ktDotQualifiedExpression != null) {
                KtDotQualifiedExpression ktDotQualifiedExpression2 = ktDotQualifiedExpression;
                IrErrorCallExpressionImpl irErrorCallExpressionImpl2 = irErrorCallExpressionImpl;
                KtDotQualifiedExpression ktParent = ktDotQualifiedExpression2;
                IrExpression irExpression2 = Intrinsics.areEqual(ktParent.getReceiverExpression(), ktName) ? null : this.getStatementGenerator().generateExpression(ktParent.getReceiverExpression());
                irErrorCallExpressionImpl = irErrorCallExpressionImpl2;
                irExpression = irExpression2;
            } else {
                irExpression = null;
            }
        } else {
            throw (Throwable)new RuntimeException(null + ": " + ((KtElement)ktName).getClass().getSimpleName() + ":" + "\n" + ((KtElement)ktName).getText(), e$iv);
        }
        irErrorCallExpressionImpl.setExplicitReceiver(irExpression);
        return irErrorCall;
    }

    public ErrorExpressionGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkParameterIsNotNull(statementGenerator, "statementGenerator");
        super(statementGenerator);
    }
}

