/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsParameter;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsVars;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.metadata.TypeCheck;
import org.jetbrains.kotlin.js.inline.util.CollectionUtilsKt;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.TypeCheckRewritingVisitor$WhenMappings;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00192\u0006\u0010\u001a\u001a\u00020\rH\u0002J\u001c\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00192\u0006\u0010\u001a\u001a\u00020\rH\u0002J(\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0 2\u0006\u0010\u001a\u001a\u00020\rH\u0002J \u0010!\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\rH\u0002J\u0018\u0010$\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010%\u001a\u00020\rH\u0002J\u001c\u0010&\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u001e\u0010&\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u001e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020'0\u0017H\u0016J\u001c\u0010&\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020(2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u000eR\u0018\u0010\u000f\u001a\u00020\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000eR\u0018\u0010\u0010\u001a\u00020\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/js/translate/utils/TypeCheckRewritingVisitor;", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsVisitorWithContextImpl;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "localVars", "Ljava/util/Stack;", "", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsName;", "scopes", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsScope;", "isAssignmentToLocalVar", "", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsExpression;", "(Lcom/google/dart/compiler/backend/js/ast/JsExpression;)Z", "isLocalVar", "needsAlias", "getNeedsAlias", "endVisit", "", "x", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsFunction;", "ctx", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsContext;", "expandArgumentForTwoInvocations", "Lkotlin/Pair;", "argument", "generateAlias", "getReplacement", "callee", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsInvocation;", "calleeArguments", "", "getReplacementForAndPredicate", "p1", "p2", "getReplacementForOrNull", "calleeArgument", "visit", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsNode;", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsVars$JsVar;", "kotlin-compiler"})
final class TypeCheckRewritingVisitor
extends JsVisitorWithContextImpl {
    private final Stack<JsScope> scopes;
    private final Stack<Set<JsName>> localVars;
    private final TranslationContext context;

    /*
     * WARNING - void declaration
     */
    public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        this.scopes.push(x.getScope());
        Set set = CollectionUtilsKt.IdentitySet();
        Stack<Set<JsName>> stack = this.localVars;
        Set $receiver = set;
        Collection collection = $receiver;
        Iterable iterable = x.getParameters();
        void var8_8 = $receiver$iv;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            void var13_13 = destination$iv$iv;
            JsName jsName = it.getName();
            var13_13.add(jsName);
        }
        iterable = (List)destination$iv$iv;
        CollectionsKt.addAll(collection, iterable);
        Set set2 = set;
        stack.push(set2);
        return super.visit(x, ctx);
    }

    public boolean visit(@NotNull JsVars.JsVar x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        JsName jsName = x.getName();
        Intrinsics.checkExpressionValueIsNotNull(jsName, "x.name");
        this.localVars.peek().add(jsName);
        return super.visit(x, ctx);
    }

    public void endVisit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        this.scopes.pop();
        this.localVars.pop();
        super.endVisit(x, ctx);
    }

    public boolean visit(@NotNull JsInvocation x, @NotNull JsContext<JsNode> ctx) {
        JsExpression replacement;
        JsInvocation callee;
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        JsExpression jsExpression = x.getQualifier();
        if (!(jsExpression instanceof JsInvocation)) {
            jsExpression = null;
        }
        JsInvocation jsInvocation = callee = (JsInvocation)jsExpression;
        List<JsExpression> calleeArguments = jsInvocation != null ? jsInvocation.getArguments() : null;
        JsExpression argument = CollectionsKt.firstOrNull(x.getArguments());
        if (callee != null && argument != null && calleeArguments != null && (replacement = this.getReplacement(callee, calleeArguments, argument)) != null) {
            ctx.replaceMe(this.accept((JsNode)replacement));
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final JsExpression getReplacement(JsInvocation callee, List<? extends JsExpression> calleeArguments, JsExpression argument) {
        JsExpression jsExpression;
        TypeCheck typeCheck;
        TypeCheck typeCheck2 = typeCheck = MetadataProperties.getTypeCheck(callee);
        if (typeCheck2 != null) {
            switch (TypeCheckRewritingVisitor$WhenMappings.$EnumSwitchMapping$0[typeCheck2.ordinal()]) {
                case 1: {
                    jsExpression = calleeArguments.isEmpty() ? TranslationUtils.isNotNullCheck(argument) : (JsBinaryOperation)null;
                    return jsExpression;
                }
                case 2: {
                    JsBinaryOperation jsBinaryOperation;
                    if (calleeArguments.size() == 1) {
                        JsExpression jsExpression2 = calleeArguments.get(0);
                        if (jsExpression2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsStringLiteral");
                        }
                        jsBinaryOperation = JsAstUtils.typeOfIs(argument, (JsStringLiteral)jsExpression2);
                    } else {
                        jsBinaryOperation = null;
                    }
                    jsExpression = jsBinaryOperation;
                    return jsExpression;
                }
                case 3: {
                    if (calleeArguments.size() == 1) {
                        jsExpression = this.context.namer().isInstanceOf(argument, calleeArguments.get(0));
                        return jsExpression;
                    }
                    jsExpression = null;
                    return jsExpression;
                }
                case 4: {
                    if (calleeArguments.size() == 1) {
                        jsExpression = this.getReplacementForOrNull(argument, calleeArguments.get(0));
                        return jsExpression;
                    }
                    jsExpression = null;
                    return jsExpression;
                }
                case 5: {
                    if (calleeArguments.size() == 2) {
                        jsExpression = this.getReplacementForAndPredicate(argument, calleeArguments.get(0), calleeArguments.get(1));
                        return jsExpression;
                    }
                    jsExpression = null;
                    return jsExpression;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        jsExpression = null;
        return jsExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final JsExpression getReplacementForOrNull(JsExpression argument, JsExpression calleeArgument) {
        void nextCheckTarget;
        void nullCheckTarget;
        if (calleeArgument instanceof JsInvocation && Intrinsics.areEqual((Object)MetadataProperties.getTypeCheck((JsInvocation)calleeArgument), (Object)TypeCheck.OR_NULL)) {
            return new JsInvocation(calleeArgument, argument);
        }
        Pair<JsExpression, JsExpression> pair = this.expandArgumentForTwoInvocations(argument);
        JsExpression jsExpression = pair.component1();
        JsExpression jsExpression2 = pair.component2();
        pair = null;
        JsBinaryOperation isNull = TranslationUtils.isNullCheck((JsExpression)nullCheckTarget);
        JsExpression jsExpression3 = JsAstUtils.or(isNull, new JsInvocation(calleeArgument, new JsExpression[]{nextCheckTarget}));
        Intrinsics.checkExpressionValueIsNotNull(jsExpression3, "or(isNull, JsInvocation(\u2026gument, nextCheckTarget))");
        return jsExpression3;
    }

    /*
     * WARNING - void declaration
     */
    private final JsExpression getReplacementForAndPredicate(JsExpression argument, JsExpression p1, JsExpression p2) {
        void arg2;
        void arg1;
        Pair<JsExpression, JsExpression> pair = this.expandArgumentForTwoInvocations(argument);
        JsExpression jsExpression = pair.component1();
        JsExpression jsExpression2 = pair.component2();
        pair = null;
        JsExpression first = (JsExpression)this.accept((JsNode)new JsInvocation(p1, new JsExpression[]{arg1}));
        JsExpression second = (JsExpression)this.accept((JsNode)new JsInvocation(p2, new JsExpression[]{arg2}));
        JsExpression jsExpression3 = JsAstUtils.and(first, second);
        Intrinsics.checkExpressionValueIsNotNull(jsExpression3, "JsAstUtils.and(first, second)");
        return jsExpression3;
    }

    private final Pair<JsExpression, JsExpression> expandArgumentForTwoInvocations(JsExpression argument) {
        Pair<JsExpression, JsExpression> pair;
        if (this.isAssignmentToLocalVar(argument)) {
            JsExpression jsExpression = argument;
            if (jsExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsBinaryOperation");
            }
            pair = new Pair<JsExpression, JsExpression>(argument, ((JsBinaryOperation)jsExpression).getArg1());
        } else {
            pair = this.getNeedsAlias(argument) ? this.generateAlias(argument) : new Pair<JsExpression, JsExpression>(argument, argument);
        }
        return pair;
    }

    private final Pair<JsExpression, JsExpression> generateAlias(JsExpression argument) {
        JsScope currentScope = this.scopes.peek();
        JsName tmp = currentScope.declareTemporary();
        JsContext<JsStatement> statementContext = this.getLastStatementLevelContext();
        statementContext.addPrevious((JsNode)JsAstUtils.newVar(tmp, null));
        return new Pair<JsExpression, JsExpression>(JsAstUtils.assignment(tmp.makeRef(), argument), tmp.makeRef());
    }

    private final boolean getNeedsAlias(@NotNull JsExpression $receiver) {
        JsExpression jsExpression = $receiver;
        return jsExpression instanceof JsLiteral.JsValueLiteral ? false : !this.isLocalVar($receiver);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLocalVar(@NotNull JsExpression $receiver) {
        Object object = this.localVars;
        if (object.isEmpty()) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!($receiver instanceof JsNameRef)) return false;
        object = ((JsNameRef)$receiver).getName();
        JsName it = (JsName)object;
        if (it == null) return false;
        if (!this.localVars.peek().contains(it)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAssignmentToLocalVar(@NotNull JsExpression $receiver) {
        Object object = this.localVars;
        if (object.isEmpty()) return false;
        boolean bl = true;
        if (!bl) return false;
        object = JsAstUtils.decomposeAssignmentToVariable($receiver);
        Pair it = (Pair)object;
        if (it == null) return false;
        if (!this.localVars.peek().contains(it.getFirst())) return false;
        return true;
    }

    public TypeCheckRewritingVisitor(@NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
        this.scopes = new Stack();
        this.localVars = new Stack();
    }
}

