/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers.hash;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.containers.hash.HashUtil;

public class HashSet<E>
extends AbstractSet<E>
implements Set<E> {
    private Entry<E>[] table;
    private int capacity;
    private int size;
    private final float loadFactor;

    public HashSet() {
        this(0);
    }

    public HashSet(int capacity) {
        this(capacity, 1.0f);
    }

    public HashSet(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.clear(capacity);
    }

    @Override
    public boolean contains(Object key) {
        Entry<E>[] table = this.table;
        int hash = HashUtil.hash(key);
        int index2 = hash % table.length;
        Entry e = table[index2];
        while (e != null) {
            Object entryKey;
            if (e.keyHash == hash && ((entryKey = e.key) == key || entryKey.equals(key))) {
                return true;
            }
            e = e.hashNext;
        }
        return false;
    }

    @Override
    public boolean add(E key) {
        Entry<E>[] table = this.table;
        int hash = HashUtil.hash(key);
        int index2 = hash % table.length;
        Entry e = table[index2];
        while (e != null) {
            Object entryKey;
            if (e.keyHash == hash && ((entryKey = e.key) == key || entryKey.equals(key))) {
                return false;
            }
            e = e.hashNext;
        }
        e = new Entry<E>(key);
        e.hashNext = (Entry)table[index2];
        table[index2] = e;
        ++this.size;
        if (this.size > this.capacity) {
            this.rehash((int)((float)this.capacity * 1.618034f));
        }
        return true;
    }

    @Override
    public boolean remove(Object key) {
        Object entryKey;
        Entry<E>[] table = this.table;
        int hash = HashUtil.hash(key);
        int index2 = hash % table.length;
        Entry e = table[index2];
        if (e == null) {
            return false;
        }
        if (e.keyHash == hash && ((entryKey = e.key) == key || entryKey.equals(key))) {
            table[index2] = e.hashNext;
        } else {
            Entry last;
            do {
                last = e;
                if ((e = e.hashNext) != null) continue;
                return false;
            } while (e.keyHash != hash || (entryKey = e.key) != key && !entryKey.equals(key));
            last.hashNext = e.hashNext;
        }
        --this.size;
        return true;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        HashSetIterator hashSetIterator = new HashSetIterator(){

            @Override
            public E next() {
                return this.nextEntry().key;
            }
        };
        if (hashSetIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/hash/HashSet", "iterator"));
        }
        return hashSetIterator;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private void init(int capacity) {
        this.table = new Entry[HashUtil.adjustTableSize((int)((float)capacity / this.loadFactor))];
        this.capacity = capacity;
    }

    private void clear(int capacity) {
        if (capacity < 5) {
            capacity = 5;
        }
        this.init(capacity);
        this.size = 0;
    }

    private void rehash(int capacity) {
        HashSetIterator entries = new HashSetIterator(){

            @Override
            public Entry<E> next() {
                return this.nextEntry();
            }
        };
        this.init(capacity);
        Entry<E>[] table = this.table;
        int tableLen = table.length;
        while (entries.hasNext()) {
            Entry e = (Entry)entries.next();
            int hash = e.keyHash % tableLen;
            e.hashNext = (Entry)table[hash];
            table[hash] = e;
        }
    }

    private abstract class HashSetIterator<T>
    implements Iterator<T> {
        private final Entry<E>[] table;
        private int index;
        private Entry<E> e;
        private Entry<E> last;

        HashSetIterator() {
            this.table = HashSet.this.table;
            this.index = 0;
            this.e = null;
            this.initNextEntry();
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            HashSet.this.remove(this.last.key);
            this.last = null;
        }

        protected Entry<E> nextEntry() {
            this.last = this.e;
            Entry result2 = this.last;
            this.initNextEntry();
            return result2;
        }

        private void initNextEntry() {
            Entry result2 = this.e;
            if (result2 != null) {
                result2 = result2.hashNext;
            }
            Entry<E>[] table = this.table;
            while (result2 == null && this.index < table.length) {
                result2 = table[this.index++];
            }
            this.e = result2;
        }
    }

    private static class Entry<E> {
        private final E key;
        private final int keyHash;
        private Entry<E> hashNext;

        public Entry(E key) {
            this.key = key;
            this.keyHash = HashUtil.hash(key);
        }
    }
}

