/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TraceEntryFilter;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfoFactory;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.ScopeUtils;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.validation.OperatorValidator;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.FakeCallResolver;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class DelegatedPropertyResolver {
    public static final Name PROPERTY_DELEGATED_FUNCTION_NAME = Name.identifier("propertyDelegated");
    public static final Name GETTER_NAME = Name.identifier("getValue");
    public static final Name SETTER_NAME = Name.identifier("setValue");
    public static final Name OLD_GETTER_NAME = Name.identifier("get");
    public static final Name OLD_SETTER_NAME = Name.identifier("set");
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;
    @NotNull
    private final FakeCallResolver fakeCallResolver;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final SymbolUsageValidator symbolUsageValidator;

    public DelegatedPropertyResolver(@NotNull SymbolUsageValidator symbolUsageValidator, @NotNull KotlinBuiltIns builtIns, @NotNull FakeCallResolver fakeCallResolver, @NotNull ExpressionTypingServices expressionTypingServices) {
        if (symbolUsageValidator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbolUsageValidator", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "<init>"));
        }
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "<init>"));
        }
        if (fakeCallResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fakeCallResolver", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "<init>"));
        }
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "<init>"));
        }
        this.symbolUsageValidator = symbolUsageValidator;
        this.builtIns = builtIns;
        this.fakeCallResolver = fakeCallResolver;
        this.expressionTypingServices = expressionTypingServices;
    }

    @Nullable
    public KotlinType getDelegatedPropertyGetMethodReturnType(@NotNull PropertyDescriptor propertyDescriptor, @NotNull KtExpression delegateExpression, @NotNull KotlinType delegateType, @NotNull BindingTrace trace, @NotNull LexicalScope delegateFunctionsScope) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "getDelegatedPropertyGetMethodReturnType"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "getDelegatedPropertyGetMethodReturnType"));
        }
        if (delegateType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateType", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "getDelegatedPropertyGetMethodReturnType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "getDelegatedPropertyGetMethodReturnType"));
        }
        if (delegateFunctionsScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateFunctionsScope", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "getDelegatedPropertyGetMethodReturnType"));
        }
        this.resolveDelegatedPropertyConventionMethod(propertyDescriptor, delegateExpression, delegateType, trace, delegateFunctionsScope, true);
        ResolvedCall<FunctionDescriptor> resolvedCall = trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, propertyDescriptor.getGetter());
        return resolvedCall != null ? resolvedCall.getResultingDescriptor().getReturnType() : null;
    }

    public void resolveDelegatedPropertyGetMethod(@NotNull PropertyDescriptor propertyDescriptor, @NotNull KtExpression delegateExpression, @NotNull KotlinType delegateType, @NotNull BindingTrace trace, @NotNull LexicalScope delegateFunctionsScope) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyGetMethod"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyGetMethod"));
        }
        if (delegateType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateType", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyGetMethod"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyGetMethod"));
        }
        if (delegateFunctionsScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateFunctionsScope", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyGetMethod"));
        }
        KotlinType returnType2 = this.getDelegatedPropertyGetMethodReturnType(propertyDescriptor, delegateExpression, delegateType, trace, delegateFunctionsScope);
        KotlinType propertyType = propertyDescriptor.getType();
        if (!(propertyType instanceof DeferredType) && returnType2 != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(returnType2, propertyType)) {
            Call call = trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, propertyDescriptor.getGetter());
            assert (call != null) : "Call should exists for " + propertyDescriptor.getGetter();
            trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_RETURN_TYPE_MISMATCH.on(delegateExpression, DelegatedPropertyResolver.renderCall(call, trace.getBindingContext()), propertyDescriptor.getType(), returnType2));
        }
    }

    public void resolveDelegatedPropertySetMethod(@NotNull PropertyDescriptor propertyDescriptor, @NotNull KtExpression delegateExpression, @NotNull KotlinType delegateType, @NotNull BindingTrace trace, @NotNull LexicalScope delegateFunctionsScope) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertySetMethod"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertySetMethod"));
        }
        if (delegateType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateType", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertySetMethod"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertySetMethod"));
        }
        if (delegateFunctionsScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateFunctionsScope", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertySetMethod"));
        }
        this.resolveDelegatedPropertyConventionMethod(propertyDescriptor, delegateExpression, delegateType, trace, delegateFunctionsScope, false);
    }

    @NotNull
    private static KtExpression createExpressionForProperty(@NotNull KtPsiFactory psiFactory) {
        if (psiFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFactory", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "createExpressionForProperty"));
        }
        KtExpression ktExpression = psiFactory.createExpression("null as " + KotlinBuiltIns.FQ_NAMES.kProperty.asSingleFqName().asString() + "<*>");
        if (ktExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "createExpressionForProperty"));
        }
        return ktExpression;
    }

    public void resolveDelegatedPropertyPDMethod(@NotNull PropertyDescriptor propertyDescriptor, @NotNull KtExpression delegateExpression, @NotNull KotlinType delegateType, @NotNull BindingTrace trace, @NotNull LexicalScope delegateFunctionsScope) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyPDMethod"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyPDMethod"));
        }
        if (delegateType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateType", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyPDMethod"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyPDMethod"));
        }
        if (delegateFunctionsScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateFunctionsScope", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyPDMethod"));
        }
        TemporaryBindingTrace traceToResolvePDMethod = TemporaryBindingTrace.create(trace, "Trace to resolve propertyDelegated method in delegated property");
        ExpressionTypingContext context = ExpressionTypingContext.newContext(traceToResolvePDMethod, delegateFunctionsScope, DataFlowInfoFactory.EMPTY, TypeUtils.NO_EXPECTED_TYPE);
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory(delegateExpression);
        List<KtExpression> arguments2 = Collections.singletonList(DelegatedPropertyResolver.createExpressionForProperty(psiFactory));
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(delegateExpression, delegateType, trace.getBindingContext());
        Pair<Call, OverloadResolutionResults<FunctionDescriptor>> resolutionResult = this.fakeCallResolver.makeAndResolveFakeCallInContext(receiver, context, arguments2, PROPERTY_DELEGATED_FUNCTION_NAME, delegateExpression);
        Call call = resolutionResult.getFirst();
        OverloadResolutionResults<FunctionDescriptor> functionResults = resolutionResult.getSecond();
        if (!functionResults.isSuccess()) {
            String expectedFunction = DelegatedPropertyResolver.renderCall(call, traceToResolvePDMethod.getBindingContext());
            if (functionResults.isIncomplete() || functionResults.isSingleResult() || functionResults.getResultCode() == OverloadResolutionResults.Code.MANY_FAILED_CANDIDATES) {
                trace.report(Errors.DELEGATE_PD_METHOD_NONE_APPLICABLE.on(delegateExpression, expectedFunction, functionResults.getResultingCalls()));
            } else if (functionResults.isAmbiguity()) {
                trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_AMBIGUITY.on(delegateExpression, expectedFunction, functionResults.getResultingCalls()));
            }
            return;
        }
        trace.record(BindingContext.DELEGATED_PROPERTY_PD_RESOLVED_CALL, propertyDescriptor, functionResults.getResultingCall());
    }

    private void resolveDelegatedPropertyConventionMethod(@NotNull PropertyDescriptor propertyDescriptor, @NotNull KtExpression delegateExpression, @NotNull KotlinType delegateType, @NotNull BindingTrace trace, @NotNull LexicalScope delegateFunctionsScope, boolean isGet) {
        KtProperty property;
        KtPropertyDelegate delegate2;
        PropertyAccessorDescriptor accessor;
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyConventionMethod"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyConventionMethod"));
        }
        if (delegateType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateType", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyConventionMethod"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyConventionMethod"));
        }
        if (delegateFunctionsScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateFunctionsScope", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyConventionMethod"));
        }
        PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = isGet ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
        assert (accessor != null) : "Delegated property should have getter/setter " + propertyDescriptor + " " + delegateExpression.getText();
        if (trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, accessor) != null) {
            return;
        }
        OverloadResolutionResults<FunctionDescriptor> functionResults = this.getDelegatedPropertyConventionMethod(propertyDescriptor, delegateExpression, delegateType, trace, delegateFunctionsScope, isGet, true);
        Call call = trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, accessor);
        assert (call != null) : "'getDelegatedPropertyConventionMethod' didn't record a call";
        if (!functionResults.isSuccess()) {
            String expectedFunction = DelegatedPropertyResolver.renderCall(call, trace.getBindingContext());
            if (functionResults.isSingleResult() || functionResults.isIncomplete() || functionResults.getResultCode() == OverloadResolutionResults.Code.MANY_FAILED_CANDIDATES) {
                trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_NONE_APPLICABLE.on(delegateExpression, expectedFunction, functionResults.getResultingCalls()));
            } else if (functionResults.isAmbiguity()) {
                trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_AMBIGUITY.on(delegateExpression, expectedFunction, functionResults.getResultingCalls()));
            } else {
                trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_MISSING.on(delegateExpression, expectedFunction, delegateType));
            }
            return;
        }
        FunctionDescriptor resultingDescriptor = functionResults.getResultingDescriptor();
        ResolvedCall<FunctionDescriptor> resultingCall = functionResults.getResultingCall();
        PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration(propertyDescriptor);
        if (declaration instanceof KtProperty && (delegate2 = (property = (KtProperty)declaration).getDelegate()) != null) {
            PsiElement byKeyword = delegate2.getByKeywordNode().getPsi();
            if (!resultingDescriptor.isOperator()) {
                OperatorValidator.Companion.report(byKeyword, resultingDescriptor, trace);
            }
            this.symbolUsageValidator.validateCall(resultingCall, resultingCall.getResultingDescriptor(), trace, byKeyword);
        }
        trace.record(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, accessor, resultingCall);
    }

    public OverloadResolutionResults<FunctionDescriptor> getDelegatedPropertyConventionMethod(@NotNull PropertyDescriptor propertyDescriptor, @NotNull KtExpression delegateExpression, @NotNull KotlinType delegateType, @NotNull BindingTrace trace, @NotNull LexicalScope delegateFunctionsScope, boolean isGet, boolean isComplete) {
        Name oldFunctionName;
        Pair<Call, OverloadResolutionResults<FunctionDescriptor>> additionalResolutionResult;
        PropertyAccessorDescriptor accessor;
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "getDelegatedPropertyConventionMethod"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "getDelegatedPropertyConventionMethod"));
        }
        if (delegateType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateType", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "getDelegatedPropertyConventionMethod"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "getDelegatedPropertyConventionMethod"));
        }
        if (delegateFunctionsScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateFunctionsScope", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "getDelegatedPropertyConventionMethod"));
        }
        PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = isGet ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
        assert (accessor != null) : "Delegated property should have getter/setter " + propertyDescriptor + " " + delegateExpression.getText();
        KotlinType expectedType = isComplete && isGet && !(propertyDescriptor.getType() instanceof DeferredType) ? propertyDescriptor.getType() : TypeUtils.NO_EXPECTED_TYPE;
        ExpressionTypingContext context = ExpressionTypingContext.newContext(trace, delegateFunctionsScope, DataFlowInfoFactory.EMPTY, expectedType);
        boolean hasThis = propertyDescriptor.getExtensionReceiverParameter() != null || propertyDescriptor.getDispatchReceiverParameter() != null;
        ArrayList<KtExpression> arguments2 = Lists.newArrayList();
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory(delegateExpression);
        arguments2.add(psiFactory.createExpression(hasThis ? "this" : "null"));
        arguments2.add(DelegatedPropertyResolver.createExpressionForProperty(psiFactory));
        if (!isGet) {
            KtReferenceExpression fakeArgument = (KtReferenceExpression)ExpressionTypingUtils.createFakeExpressionOfType(delegateExpression.getProject(), trace, "fakeArgument" + arguments2.size(), propertyDescriptor.getType());
            arguments2.add(fakeArgument);
            List<ValueParameterDescriptor> valueParameters = accessor.getValueParameters();
            trace.record(BindingContext.REFERENCE_TARGET, fakeArgument, valueParameters.get(0));
        }
        Name functionName = isGet ? GETTER_NAME : SETTER_NAME;
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(delegateExpression, delegateType, trace.getBindingContext());
        Pair<Call, OverloadResolutionResults<FunctionDescriptor>> resolutionResult = this.fakeCallResolver.makeAndResolveFakeCallInContext(receiver, context, arguments2, functionName, delegateExpression);
        OverloadResolutionResults<FunctionDescriptor> resolutionResults = resolutionResult.getSecond();
        if (!resolutionResults.isSuccess() && !resolutionResults.isAmbiguity() && (additionalResolutionResult = this.fakeCallResolver.makeAndResolveFakeCallInContext(receiver, context, arguments2, oldFunctionName = isGet ? OLD_GETTER_NAME : OLD_SETTER_NAME, delegateExpression)).getSecond().isSuccess()) {
            KtProperty property;
            KtPropertyDelegate delegate2;
            FunctionDescriptor resultingDescriptor = additionalResolutionResult.getSecond().getResultingDescriptor();
            PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration(propertyDescriptor);
            if (declaration instanceof KtProperty && (delegate2 = (property = (KtProperty)declaration).getDelegate()) != null) {
                PsiElement byKeyword = delegate2.getByKeywordNode().getPsi();
                trace.report(Errors.DELEGATE_RESOLVED_TO_DEPRECATED_CONVENTION.on(byKeyword, resultingDescriptor, delegateType, functionName.asString()));
            }
            trace.record(BindingContext.DELEGATED_PROPERTY_CALL, accessor, additionalResolutionResult.getFirst());
            return additionalResolutionResult.getSecond();
        }
        trace.record(BindingContext.DELEGATED_PROPERTY_CALL, accessor, resolutionResult.getFirst());
        return resolutionResults;
    }

    private static String renderCall(@NotNull Call call, @NotNull BindingContext context) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "renderCall"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "renderCall"));
        }
        KtExpression calleeExpression = call.getCalleeExpression();
        assert (calleeExpression != null) : "CalleeExpression should exists for fake call of convention method";
        StringBuilder builder = new StringBuilder(calleeExpression.getText());
        builder.append("(");
        ArrayList<KotlinType> argumentTypes = Lists.newArrayList();
        for (ValueArgument valueArgument : call.getValueArguments()) {
            argumentTypes.add(context.getType(valueArgument.getArgumentExpression()));
        }
        builder.append(Renderers.RENDER_COLLECTION_OF_TYPES.render(argumentTypes));
        builder.append(")");
        return builder.toString();
    }

    @NotNull
    public KotlinType resolveDelegateExpression(@NotNull KtExpression delegateExpression, @NotNull KtProperty property, @NotNull PropertyDescriptor propertyDescriptor, @NotNull LexicalScope scopeForDelegate, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegateExpression"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegateExpression"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegateExpression"));
        }
        if (scopeForDelegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForDelegate", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegateExpression"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegateExpression"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegateExpression"));
        }
        TemporaryBindingTrace traceToResolveDelegatedProperty = TemporaryBindingTrace.create(trace, "Trace to resolve delegated property");
        KtExpression calleeExpression = CallUtilKt.getCalleeExpressionIfAny(delegateExpression);
        ConstraintSystemCompleter completer = this.createConstraintSystemCompleter(property, propertyDescriptor, delegateExpression, scopeForDelegate, trace);
        if (calleeExpression != null) {
            traceToResolveDelegatedProperty.record(BindingContext.CONSTRAINT_SYSTEM_COMPLETER, calleeExpression, completer);
        }
        KotlinType delegateType = this.expressionTypingServices.safeGetType(scopeForDelegate, delegateExpression, TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, traceToResolveDelegatedProperty);
        traceToResolveDelegatedProperty.commit(new TraceEntryFilter(){

            @Override
            public boolean accept(@Nullable WritableSlice<?, ?> slice, @Nullable Diagnostic diagnostic, Object key) {
                return slice != BindingContext.CONSTRAINT_SYSTEM_COMPLETER;
            }
        }, true);
        KotlinType kotlinType = delegateType;
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegateExpression"));
        }
        return kotlinType;
    }

    @NotNull
    private ConstraintSystemCompleter createConstraintSystemCompleter(@NotNull KtProperty property, final @NotNull PropertyDescriptor propertyDescriptor, final @NotNull KtExpression delegateExpression, @NotNull LexicalScope scopeForDelegate, final @NotNull BindingTrace trace) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "createConstraintSystemCompleter"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "createConstraintSystemCompleter"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "createConstraintSystemCompleter"));
        }
        if (scopeForDelegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForDelegate", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "createConstraintSystemCompleter"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "createConstraintSystemCompleter"));
        }
        final LexicalScope delegateFunctionsScope = ScopeUtils.makeScopeForDelegateConventionFunctions(scopeForDelegate, propertyDescriptor);
        final KotlinType expectedType = property.getTypeReference() != null ? propertyDescriptor.getType() : TypeUtils.NO_EXPECTED_TYPE;
        ConstraintSystemCompleter constraintSystemCompleter = new ConstraintSystemCompleter(){

            @Override
            public void completeConstraintSystem(@NotNull ConstraintSystem.Builder constraintSystem, @NotNull ResolvedCall<?> resolvedCall) {
                FunctionDescriptor descriptor2;
                List<ValueParameterDescriptor> valueParameters;
                if (constraintSystem == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver$2", "completeConstraintSystem"));
                }
                if (resolvedCall == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver$2", "completeConstraintSystem"));
                }
                KotlinType returnType2 = resolvedCall.getCandidateDescriptor().getReturnType();
                if (returnType2 == null) {
                    return;
                }
                TypeSubstitutor typeVariableSubstitutor = constraintSystem.getTypeVariableSubstitutors().get(TypeVariableKt.toHandle(resolvedCall.getCall()));
                assert (typeVariableSubstitutor != null) : "No substitutor in the system for call: " + resolvedCall.getCall();
                TemporaryBindingTrace traceToResolveConventionMethods = TemporaryBindingTrace.create(trace, "Trace to resolve delegated property convention methods");
                OverloadResolutionResults<FunctionDescriptor> getMethodResults = DelegatedPropertyResolver.this.getDelegatedPropertyConventionMethod(propertyDescriptor, delegateExpression, returnType2, traceToResolveConventionMethods, delegateFunctionsScope, true, false);
                if (this.conventionMethodFound(getMethodResults)) {
                    KotlinType returnTypeInSystem;
                    FunctionDescriptor descriptor3 = getMethodResults.getResultingDescriptor();
                    KotlinType returnTypeOfGetMethod = descriptor3.getReturnType();
                    if (returnTypeOfGetMethod != null && !TypeUtils.noExpectedType(expectedType) && (returnTypeInSystem = typeVariableSubstitutor.substitute(returnTypeOfGetMethod, Variance.INVARIANT)) != null) {
                        constraintSystem.addSubtypeConstraint(returnTypeInSystem, expectedType, ConstraintPositionKind.FROM_COMPLETER.position());
                    }
                    this.addConstraintForThisValue(constraintSystem, typeVariableSubstitutor, descriptor3);
                }
                if (!propertyDescriptor.isVar()) {
                    return;
                }
                if (propertyDescriptor.getReturnType() instanceof DeferredType) {
                    return;
                }
                OverloadResolutionResults<FunctionDescriptor> setMethodResults = DelegatedPropertyResolver.this.getDelegatedPropertyConventionMethod(propertyDescriptor, delegateExpression, returnType2, traceToResolveConventionMethods, delegateFunctionsScope, false, false);
                if (this.conventionMethodFound(setMethodResults) && (valueParameters = (descriptor2 = setMethodResults.getResultingDescriptor()).getValueParameters()).size() == 3) {
                    ValueParameterDescriptor valueParameterForThis = valueParameters.get(2);
                    if (!TypeUtils.noExpectedType(expectedType)) {
                        constraintSystem.addSubtypeConstraint(expectedType, typeVariableSubstitutor.substitute(valueParameterForThis.getType(), Variance.INVARIANT), ConstraintPositionKind.FROM_COMPLETER.position());
                    }
                    this.addConstraintForThisValue(constraintSystem, typeVariableSubstitutor, descriptor2);
                }
            }

            private boolean conventionMethodFound(@NotNull OverloadResolutionResults<FunctionDescriptor> results) {
                if (results == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver$2", "conventionMethodFound"));
                }
                return results.isSuccess() || results.isSingleResult() && results.getResultCode() == OverloadResolutionResults.Code.SINGLE_CANDIDATE_ARGUMENT_MISMATCH;
            }

            private void addConstraintForThisValue(ConstraintSystem.Builder constraintSystem, TypeSubstitutor typeVariableSubstitutor, FunctionDescriptor resultingDescriptor) {
                ReceiverParameterDescriptor extensionReceiver2 = propertyDescriptor.getExtensionReceiverParameter();
                ReceiverParameterDescriptor dispatchReceiver = propertyDescriptor.getDispatchReceiverParameter();
                KotlinType typeOfThis = extensionReceiver2 != null ? extensionReceiver2.getType() : (dispatchReceiver != null ? dispatchReceiver.getType() : DelegatedPropertyResolver.this.builtIns.getNullableNothingType());
                List<ValueParameterDescriptor> valueParameters = resultingDescriptor.getValueParameters();
                if (valueParameters.isEmpty()) {
                    return;
                }
                ValueParameterDescriptor valueParameterForThis = valueParameters.get(0);
                constraintSystem.addSubtypeConstraint(typeOfThis, typeVariableSubstitutor.substitute(valueParameterForThis.getType(), Variance.INVARIANT), ConstraintPositionKind.FROM_COMPLETER.position());
            }
        };
        if (constraintSystemCompleter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "createConstraintSystemCompleter"));
        }
        return constraintSystemCompleter;
    }
}

