/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.jline;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.jetbrains.kotlin.relocated.jline.WindowsTerminal;
import org.jetbrains.kotlin.relocated.jline.internal.Configuration;
import org.jetbrains.kotlin.relocated.org.fusesource.jansi.AnsiConsole;
import org.jetbrains.kotlin.relocated.org.fusesource.jansi.AnsiOutputStream;
import org.jetbrains.kotlin.relocated.org.fusesource.jansi.WindowsAnsiOutputStream;

public class AnsiWindowsTerminal
extends WindowsTerminal {
    private final boolean ansiSupported = AnsiWindowsTerminal.detectAnsiSupport();

    @Override
    public OutputStream wrapOutIfNeeded(OutputStream out) {
        return AnsiWindowsTerminal.wrapOutputStream(out);
    }

    private static OutputStream wrapOutputStream(OutputStream stream2) {
        if (Configuration.isWindows()) {
            try {
                return new WindowsAnsiOutputStream(stream2);
            }
            catch (Throwable throwable) {
                return new AnsiOutputStream(stream2);
            }
        }
        return stream2;
    }

    private static boolean detectAnsiSupport() {
        OutputStream out = AnsiConsole.wrapOutputStream(new ByteArrayOutputStream());
        try {
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out instanceof WindowsAnsiOutputStream;
    }

    @Override
    public boolean isAnsiSupported() {
        return this.ansiSupported;
    }

    @Override
    public boolean hasWeirdWrap() {
        return false;
    }
}

