/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.units.bigints;

import com.google.common.collect.DiscreteDomain;
import java.util.function.Function;
import org.apache.tuweni.units.bigints.UInt64;
import org.apache.tuweni.units.bigints.UInt64Value;

public final class UInt64ValueDomain<T extends UInt64Value<T>>
extends DiscreteDomain<T> {
    private final T minValue;
    private final T maxValue;

    public UInt64ValueDomain(Function<UInt64, T> ctor) {
        this.minValue = (UInt64Value)ctor.apply(UInt64.MIN_VALUE);
        this.maxValue = (UInt64Value)ctor.apply(UInt64.MAX_VALUE);
    }

    public T next(T value) {
        return value.add(1L);
    }

    public T previous(T value) {
        return value.subtract(1L);
    }

    public long distance(T start, T end) {
        T distance;
        boolean negativeDistance = start.compareTo(end) < 0;
        T t = distance = negativeDistance ? end.subtract(start) : start.subtract(end);
        if (!distance.fitsLong()) {
            return negativeDistance ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        long distanceLong = distance.toLong();
        return negativeDistance ? -distanceLong : distanceLong;
    }

    public T minValue() {
        return this.minValue;
    }

    public T maxValue() {
        return this.maxValue;
    }
}

