/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.config;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.tuweni.config.Configuration;
import org.apache.tuweni.config.ConfigurationError;
import org.apache.tuweni.config.ConfigurationValidator;
import org.apache.tuweni.config.PropertyValidator;
import org.apache.tuweni.config.Schema;

public final class SchemaBuilder {
    private final Map<String, String> propertyDescriptions = new HashMap<String, String>();
    private final Map<String, Object> propertyDefaults = new HashMap<String, Object>();
    private final ListMultimap<String, PropertyValidator<Object>> propertyValidators = ArrayListMultimap.create();
    private final List<ConfigurationValidator> configurationValidators = new ArrayList<ConfigurationValidator>();

    public static SchemaBuilder create() {
        return new SchemaBuilder();
    }

    SchemaBuilder() {
    }

    public SchemaBuilder documentProperty(String key, String description) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(description);
        this.propertyDescriptions.put(Configuration.canonicalKey(key), description);
        return this;
    }

    public SchemaBuilder addDefault(String key, Object value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.propertyDefaults.put(Configuration.canonicalKey(key), value);
        return this;
    }

    public SchemaBuilder validateProperty(String key, PropertyValidator<Object> validator) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(validator);
        this.propertyValidators.put((Object)Configuration.canonicalKey(key), validator);
        return this;
    }

    public SchemaBuilder validateConfiguration(ConfigurationValidator validator) {
        Objects.requireNonNull(validator);
        this.configurationValidators.add(validator);
        return this;
    }

    public SchemaBuilder addString(String key, @Nullable String defaultValue, @Nullable String description, @Nullable PropertyValidator<? super String> validator) {
        Objects.requireNonNull(key);
        return this.addScalar(String.class, "string", key, defaultValue, description, validator);
    }

    public SchemaBuilder addInteger(String key, @Nullable Integer defaultValue, @Nullable String description, @Nullable PropertyValidator<? super Integer> validator) {
        Objects.requireNonNull(key);
        if (defaultValue != null) {
            this.addDefault(key, defaultValue);
        }
        if (description != null) {
            this.documentProperty(key, description);
        }
        this.validateProperty(key, (canonicalKey, position, value) -> {
            Integer intValue;
            if (value != null && !(value instanceof Integer) && !(value instanceof Long)) {
                return Collections.singletonList(new ConfigurationError(position, "Property at '" + canonicalKey + "' requires an integer"));
            }
            if (validator == null || defaultValue != null && value == null) {
                return Collections.emptyList();
            }
            if (value instanceof Long) {
                if ((Long)value > Integer.MAX_VALUE) {
                    return Collections.singletonList(new ConfigurationError(position, "Value of property '" + canonicalKey + "' is too large for an integer"));
                }
                intValue = ((Long)value).intValue();
            } else {
                intValue = (Integer)value;
            }
            return validator.validate(canonicalKey, position, intValue);
        });
        return this;
    }

    public SchemaBuilder addLong(String key, @Nullable Long defaultValue, @Nullable String description, @Nullable PropertyValidator<? super Long> validator) {
        Objects.requireNonNull(key);
        if (defaultValue != null) {
            this.addDefault(key, defaultValue);
        }
        if (description != null) {
            this.documentProperty(key, description);
        }
        this.validateProperty(key, (vkey, position, value) -> {
            if (value != null && !(value instanceof Long) && !(value instanceof Integer)) {
                return Collections.singletonList(new ConfigurationError(position, "Property at '" + vkey + "' requires a long"));
            }
            if (validator == null || defaultValue != null && value == null) {
                return Collections.emptyList();
            }
            Long longValue = value instanceof Integer ? Long.valueOf(((Integer)value).longValue()) : (Long)value;
            return validator.validate(vkey, position, longValue);
        });
        return this;
    }

    public SchemaBuilder addDouble(String key, @Nullable Double defaultValue, @Nullable String description, @Nullable PropertyValidator<? super Double> validator) {
        Objects.requireNonNull(key);
        return this.addScalar(Double.class, "double", key, defaultValue, description, validator);
    }

    public SchemaBuilder addBoolean(String key, @Nullable Boolean defaultValue, @Nullable String description, @Nullable PropertyValidator<? super Boolean> validator) {
        Objects.requireNonNull(key);
        return this.addScalar(Boolean.class, "boolean", key, defaultValue, description, validator);
    }

    public SchemaBuilder addListOfString(String key, @Nullable List<String> defaultValue, @Nullable String description, @Nullable PropertyValidator<? super List<String>> validator) {
        Objects.requireNonNull(key);
        return this.addList(String.class, "string", key, defaultValue, description, validator);
    }

    public SchemaBuilder addListOfInteger(String key, @Nullable List<Integer> defaultValue, @Nullable String description, @Nullable PropertyValidator<? super List<Integer>> validator) {
        Objects.requireNonNull(key);
        if (defaultValue != null) {
            if (defaultValue.stream().anyMatch(Objects::isNull)) {
                throw new IllegalArgumentException("default value list contains null value(s)");
            }
            this.addDefault(key, defaultValue);
        }
        if (description != null) {
            this.documentProperty(key, description);
        }
        this.validateProperty(key, (vkey, position, value) -> {
            if (value != null && !(value instanceof List)) {
                return Collections.singletonList(new ConfigurationError(position, "Property at '" + vkey + "' requires a list of integers"));
            }
            boolean containsLong = false;
            if (value != null) {
                List objs = (List)value;
                for (int i = 0; i < objs.size(); ++i) {
                    Object obj = objs.get(i);
                    if (obj == null) {
                        return Collections.singletonList(new ConfigurationError(position, "Value of property '" + vkey + "', index " + i + ", is null"));
                    }
                    if (!(obj instanceof Integer) && !(obj instanceof Long)) {
                        return Collections.singletonList(new ConfigurationError(position, "Value of property '" + vkey + "', index " + i + ", is not an integer"));
                    }
                    if (!(obj instanceof Long)) continue;
                    containsLong = true;
                    if ((Long)obj <= Integer.MAX_VALUE) continue;
                    return Collections.singletonList(new ConfigurationError(position, "Value of property '" + vkey + "', index " + i + ", is too large for an integer"));
                }
            }
            if (validator == null || defaultValue != null && value == null) {
                return Collections.emptyList();
            }
            if (!containsLong) {
                return validator.validate(vkey, position, (List)value);
            }
            return validator.validate(vkey, position, ((List)value).stream().map(o -> {
                if (o instanceof Integer) {
                    return (Integer)o;
                }
                assert (o instanceof Long);
                return ((Long)o).intValue();
            }).collect(Collectors.toList()));
        });
        return this;
    }

    public SchemaBuilder addListOfLong(String key, @Nullable List<Long> defaultValue, @Nullable String description, @Nullable PropertyValidator<? super List<Long>> validator) {
        Objects.requireNonNull(key);
        if (defaultValue != null) {
            if (defaultValue.stream().anyMatch(Objects::isNull)) {
                throw new IllegalArgumentException("default value list contains null value(s)");
            }
            this.addDefault(key, defaultValue);
        }
        if (description != null) {
            this.documentProperty(key, description);
        }
        this.validateProperty(key, (canonicalKey, position, value) -> {
            if (value != null && !(value instanceof List)) {
                return Collections.singletonList(new ConfigurationError(position, "Property at '" + canonicalKey + "' requires a list of longs"));
            }
            boolean containsInteger = false;
            if (value != null) {
                List objs = (List)value;
                for (int i = 0; i < objs.size(); ++i) {
                    Object obj = objs.get(i);
                    if (obj == null) {
                        return Collections.singletonList(new ConfigurationError(position, "Value of property '" + canonicalKey + "', index " + i + ", is null"));
                    }
                    if (!(obj instanceof Long) && !(obj instanceof Integer)) {
                        return Collections.singletonList(new ConfigurationError(position, "Value of property '" + canonicalKey + "', index " + i + ", is not a long"));
                    }
                    containsInteger |= obj instanceof Integer;
                }
            }
            if (validator == null || defaultValue != null && value == null) {
                return Collections.emptyList();
            }
            if (!containsInteger) {
                return validator.validate(canonicalKey, position, (List)value);
            }
            return validator.validate(canonicalKey, position, ((List)value).stream().map(o -> {
                if (o instanceof Long) {
                    return (Long)o;
                }
                assert (o instanceof Integer);
                return ((Integer)o).longValue();
            }).collect(Collectors.toList()));
        });
        return this;
    }

    public SchemaBuilder addListOfDouble(String key, @Nullable List<Double> defaultValue, @Nullable String description, @Nullable PropertyValidator<? super List<Double>> validator) {
        Objects.requireNonNull(key);
        return this.addList(Double.class, "double", key, defaultValue, description, validator);
    }

    public SchemaBuilder addListOfBoolean(String key, @Nullable List<Boolean> defaultValue, @Nullable String description, @Nullable PropertyValidator<? super List<Boolean>> validator) {
        Objects.requireNonNull(key);
        return this.addList(Boolean.class, "boolean", key, defaultValue, description, validator);
    }

    public SchemaBuilder addListOfMap(String key, @Nullable List<Map<String, Object>> defaultValue, @Nullable String description, @Nullable PropertyValidator<? super List<Map<String, Object>>> validator) {
        Objects.requireNonNull(key);
        return this.addList(Map.class, "map", key, defaultValue, description, validator);
    }

    public Schema toSchema() {
        return new Schema(this.propertyDescriptions, this.propertyDefaults, this.propertyValidators, this.configurationValidators);
    }

    private <T> SchemaBuilder addScalar(Class<T> clazz, String typeName, String key, @Nullable T defaultValue, @Nullable String description, @Nullable PropertyValidator<? super T> validator) {
        if (defaultValue != null) {
            this.addDefault(key, defaultValue);
        }
        if (description != null) {
            this.documentProperty(key, description);
        }
        this.validateProperty(key, (canonicalKey, position, value) -> {
            if (value != null && !clazz.isInstance(value)) {
                return Collections.singletonList(new ConfigurationError(position, "Property at '" + canonicalKey + "' requires a " + typeName));
            }
            if (validator == null || defaultValue != null && value == null) {
                return Collections.emptyList();
            }
            return validator.validate(canonicalKey, position, (Object)clazz.cast(value));
        });
        return this;
    }

    private <T, U> SchemaBuilder addList(Class<U> innerClass, String typeName, String key, @Nullable List<T> defaultValue, @Nullable String description, @Nullable PropertyValidator<? super List<T>> validator) {
        if (defaultValue != null) {
            if (defaultValue.stream().anyMatch(Objects::isNull)) {
                throw new IllegalArgumentException("default value list contains null value(s)");
            }
            this.addDefault(key, defaultValue);
        }
        if (description != null) {
            this.documentProperty(key, description);
        }
        this.validateProperty(key, (canonicalKey, position, value) -> {
            if (value != null && !(value instanceof List)) {
                return Collections.singletonList(new ConfigurationError(position, "Property at '" + canonicalKey + "' requires a list of " + typeName + "s"));
            }
            if (value != null) {
                List objs = (List)value;
                for (int i = 0; i < objs.size(); ++i) {
                    Object obj = objs.get(i);
                    if (obj == null) {
                        return Collections.singletonList(new ConfigurationError(position, "Value of property '" + canonicalKey + "', index " + i + ", is null"));
                    }
                    if (innerClass.isInstance(obj)) continue;
                    return Collections.singletonList(new ConfigurationError(position, "Value of property '" + canonicalKey + "', index " + i + ", is not a " + typeName));
                }
            }
            if (validator == null || defaultValue != null && value == null) {
                return Collections.emptyList();
            }
            return validator.validate(canonicalKey, position, (List)value);
        });
        return this;
    }
}

