/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.annotation.TargetApi;
import android.app.Service;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanResult;
import android.content.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.Callback;
import org.altbeacon.beacon.service.DetectionTracker;
import org.altbeacon.beacon.service.ExtraDataBeaconTracker;
import org.altbeacon.beacon.service.MonitoringStatus;
import org.altbeacon.beacon.service.RangeState;
import org.altbeacon.beacon.service.RangingData;
import org.altbeacon.beacon.service.ScanState;
import org.altbeacon.beacon.service.Stats;
import org.altbeacon.beacon.service.scanner.NonBeaconLeScanCallback;

public class ScanDataProcessor {
    private static final String TAG = ScanDataProcessor.class.getSimpleName();
    private Service mService;
    private Map<Region, RangeState> mRangedRegionState = new HashMap<Region, RangeState>();
    private MonitoringStatus mMonitoringStatus;
    private Set<BeaconParser> mBeaconParsers = new HashSet<BeaconParser>();
    private ExtraDataBeaconTracker mExtraDataBeaconTracker;
    private NonBeaconLeScanCallback mNonBeaconLeScanCallback;
    private DetectionTracker mDetectionTracker = DetectionTracker.getInstance();
    int trackedBeaconsPacketCount;

    public ScanDataProcessor(Service scanService, ScanState scanState) {
        this.mService = scanService;
        this.mMonitoringStatus = scanState.getMonitoringStatus();
        this.mRangedRegionState = scanState.getRangedRegionState();
        this.mMonitoringStatus = scanState.getMonitoringStatus();
        this.mExtraDataBeaconTracker = scanState.getExtraBeaconDataTracker();
        this.mBeaconParsers = scanState.getBeaconParsers();
    }

    @TargetApi(value=21)
    public void process(ScanResult scanResult) {
        ScanData scanData = new ScanData(scanResult.getDevice(), scanResult.getRssi(), scanResult.getScanRecord().getBytes());
        this.process(scanData);
    }

    public void process(ScanData scanData) {
        BeaconParser parser;
        Beacon beacon = null;
        Iterator<BeaconParser> iterator = this.mBeaconParsers.iterator();
        while (iterator.hasNext() && (beacon = (parser = iterator.next()).fromScanData(scanData.scanRecord, scanData.rssi, scanData.device)) == null) {
        }
        if (beacon != null) {
            this.mDetectionTracker.recordDetection();
            ++this.trackedBeaconsPacketCount;
            this.processBeaconFromScan(beacon);
        } else if (this.mNonBeaconLeScanCallback != null) {
            this.mNonBeaconLeScanCallback.onNonBeaconLeScan(scanData.device, scanData.rssi, scanData.scanRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBeaconFromScan(Beacon beacon) {
        if (Stats.getInstance().isEnabled()) {
            Stats.getInstance().log(beacon);
        }
        if (LogManager.isVerboseLoggingEnabled()) {
            LogManager.d(TAG, "beacon detected : %s", beacon.toString());
        }
        if ((beacon = this.mExtraDataBeaconTracker.track(beacon)) == null) {
            if (LogManager.isVerboseLoggingEnabled()) {
                LogManager.d(TAG, "not processing detections for GATT extra data beacon", new Object[0]);
            }
        } else {
            this.mMonitoringStatus.updateNewlyInsideInRegionsContaining(beacon);
            List<Region> matchedRegions = null;
            LogManager.d(TAG, "looking for ranging region matches for this beacon out of " + this.mRangedRegionState.keySet().size() + " regions.", new Object[0]);
            Map<Region, RangeState> map = this.mRangedRegionState;
            synchronized (map) {
                matchedRegions = this.matchingRegions(beacon, this.mRangedRegionState.keySet());
                for (Region region : matchedRegions) {
                    LogManager.d(TAG, "matches ranging region: %s", region);
                    RangeState rangeState = this.mRangedRegionState.get(region);
                    if (rangeState == null) continue;
                    rangeState.addBeacon(beacon);
                }
            }
        }
    }

    private List<Region> matchingRegions(Beacon beacon, Collection<Region> regions) {
        ArrayList<Region> matched = new ArrayList<Region>();
        for (Region region : regions) {
            if (region.matchesBeacon(beacon)) {
                matched.add(region);
                continue;
            }
            LogManager.d(TAG, "This region (%s) does not match beacon: %s", region, beacon);
        }
        return matched;
    }

    public void onCycleEnd() {
        this.mMonitoringStatus.updateNewlyOutside();
        this.processRangeData();
        if (BeaconManager.getBeaconSimulator() != null) {
            if (BeaconManager.getBeaconSimulator().getBeacons() != null) {
                if (0 != (this.mService.getApplicationContext().getApplicationInfo().flags &= 2)) {
                    for (Beacon beacon : BeaconManager.getBeaconSimulator().getBeacons()) {
                        this.processBeaconFromScan(beacon);
                    }
                } else {
                    LogManager.w(TAG, "Beacon simulations provided, but ignored because we are not running in debug mode.  Please remove beacon simulations for production.", new Object[0]);
                }
            } else {
                LogManager.w(TAG, "getBeacons is returning null. No simulated beacons to report.", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRangeData() {
        Map<Region, RangeState> map = this.mRangedRegionState;
        synchronized (map) {
            for (Region region : this.mRangedRegionState.keySet()) {
                RangeState rangeState = this.mRangedRegionState.get(region);
                LogManager.d(TAG, "Calling ranging callback", new Object[0]);
                Callback callback = new Callback(this.mService.getPackageName());
                callback.call((Context)this.mService, "rangingData", new RangingData(rangeState.finalizeBeacons(), region).toBundle());
            }
        }
    }

    private class ScanData {
        int rssi;
        BluetoothDevice device;
        byte[] scanRecord;

        public ScanData(BluetoothDevice device, int rssi, byte[] scanRecord) {
            this.device = device;
            this.rssi = rssi;
            this.scanRecord = scanRecord;
        }
    }
}

