/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.gradle.plugins.license.maven;

import com.google.code.mojo.license.Callback;
import com.google.code.mojo.license.HeaderSection;
import com.google.code.mojo.license.document.Document;
import com.google.code.mojo.license.document.DocumentType;
import com.google.code.mojo.license.header.AdditionalHeaderDefinition;
import com.google.code.mojo.license.header.Header;
import com.google.code.mojo.license.header.HeaderDefinition;
import com.google.code.mojo.license.header.HeaderType;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mycila.xmltool.XMLDoc;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import nl.javadude.gradle.plugins.license.maven.DocumentFactory;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class AbstractLicenseMojo {
    static Logger logger = Logging.getLogger(AbstractLicenseMojo.class);
    Collection<File> validHeaders;
    File rootDir;
    Map<String, String> initial;
    protected String[] keywords = new String[]{"copyright"};
    protected String[] headerDefinitions = new String[0];
    protected HeaderSection[] headerSections = new HeaderSection[0];
    protected String encoding = System.getProperty("file.encoding");
    protected float concurrencyFactor = 1.5f;
    protected Map<String, String> mapping;
    boolean dryRun;
    boolean skipExistingHeaders;
    boolean useDefaultMappings;
    boolean strictCheck;
    File header;
    FileCollection source;

    public AbstractLicenseMojo(Collection<File> validHeaders, File rootDir, Map<String, String> initial, boolean dryRun, boolean skipExistingHeaders, boolean useDefaultMappings, boolean strictCheck, File header, FileCollection source, Map<String, String> mapping) {
        this.validHeaders = validHeaders;
        this.rootDir = rootDir;
        this.initial = initial;
        this.dryRun = dryRun;
        this.skipExistingHeaders = skipExistingHeaders;
        this.useDefaultMappings = useDefaultMappings;
        this.strictCheck = strictCheck;
        this.header = header;
        this.source = source;
        this.mapping = mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void execute(final Callback callback) throws MalformedURLException {
        Map<String, String> props = this.mergeProperties();
        final Header h = new Header(this.header.toURI().toURL(), props, this.headerSections);
        logger.debug("Header {}:\n{}", (Object)h.getLocation(), (Object)h);
        if (this.validHeaders == null) {
            this.validHeaders = new ArrayList<File>();
        }
        final ArrayList<Header> validHeaders = new ArrayList<Header>(this.validHeaders.size());
        for (File validHeader : this.validHeaders) {
            validHeaders.add(new Header(validHeader.toURI().toURL(), props, this.headerSections));
        }
        final DocumentFactory documentFactory = new DocumentFactory(this.rootDir, this.buildMapping(), this.buildHeaderDefinitions(), this.encoding, this.keywords);
        int nThreads = (int)((float)Runtime.getRuntime().availableProcessors() * this.concurrencyFactor);
        ExecutorService executorService = Executors.newFixedThreadPool(nThreads);
        ExecutorCompletionService completionService = new ExecutorCompletionService(executorService);
        int count = 0;
        logger.debug("Number of execution threads: {}", (Object)nThreads);
        try {
            for (final File file : this.source) {
                completionService.submit(new Runnable(){

                    @Override
                    public void run() {
                        Document document = documentFactory.createDocuments(file);
                        logger.debug("Selected file: {} [header style: {}]", (Object)DocumentFactory.getRelativeFile(AbstractLicenseMojo.this.rootDir, document), (Object)document.getHeaderDefinition());
                        if (document.isNotSupported()) {
                            logger.warn("Unknown file extension: {}", (Object)DocumentFactory.getRelativeFile(AbstractLicenseMojo.this.rootDir, document));
                        } else if (document.is(h)) {
                            logger.debug("Skipping header file: {}", (Object)DocumentFactory.getRelativeFile(AbstractLicenseMojo.this.rootDir, document));
                        } else if (document.hasHeader(h, AbstractLicenseMojo.this.strictCheck)) {
                            callback.onExistingHeader(document, h);
                        } else {
                            boolean headerFound = false;
                            for (Header validHeader : validHeaders) {
                                headerFound = document.hasHeader(validHeader, AbstractLicenseMojo.this.strictCheck);
                                if (!headerFound) continue;
                                callback.onExistingHeader(document, h);
                                break;
                            }
                            if (!headerFound) {
                                callback.onHeaderNotFound(document, h);
                            }
                        }
                    }
                }, null);
                ++count;
            }
            while (count-- > 0) {
                try {
                    completionService.take().get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    if (!(cause instanceof RuntimeException)) throw new GradleException(cause.getMessage(), cause);
                    throw (RuntimeException)cause;
                    return;
                }
            }
        }
        finally {
            executorService.shutdownNow();
        }
    }

    protected final Map<String, String> mergeProperties() {
        HashMap<String, String> props = new HashMap<String, String>(System.getenv());
        props.putAll(this.initial);
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            props.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return props;
    }

    private Map<String, String> buildMapping() {
        HashMap<String, String> extensionMapping = this.useDefaultMappings ? new HashMap<String, String>(DocumentType.defaultMapping()) : new HashMap();
        List<HeaderType> headerTypes = Arrays.asList(HeaderType.values());
        HashSet validHeaderTypes = Sets.newHashSet((Iterable)Lists.transform(headerTypes, (Function)new Function<HeaderType, String>(){

            public String apply(HeaderType headerType) {
                return headerType.name();
            }
        }));
        for (Map.Entry<String, String> entry : this.mapping.entrySet()) {
            String headerType = entry.getValue().toUpperCase();
            String fileType = entry.getKey().toLowerCase();
            if (!validHeaderTypes.contains(headerType)) {
                throw new InvalidUserDataException(String.format("The provided header type (%s) for %s is invalid", headerType, fileType));
            }
            extensionMapping.put(fileType, headerType);
        }
        extensionMapping.put(DocumentType.UNKNOWN.getExtension(), DocumentType.UNKNOWN.getDefaultHeaderTypeName());
        return extensionMapping;
    }

    private Map<String, HeaderDefinition> buildHeaderDefinitions() {
        HashMap<String, HeaderDefinition> headers = new HashMap<String, HeaderDefinition>(HeaderType.defaultDefinitions());
        for (String resource : this.headerDefinitions) {
            AdditionalHeaderDefinition fileDefinitions = new AdditionalHeaderDefinition(XMLDoc.from((File)this.findResource(resource), (boolean)true));
            Map map = fileDefinitions.getDefinitions();
            logger.debug("{} header definitions loaded from '{}'", (Object)map.size(), (Object)resource);
            headers.putAll(map);
        }
        headers.put(HeaderType.UNKNOWN.getDefinition().getType(), HeaderType.UNKNOWN.getDefinition());
        return headers;
    }

    private File findResource(String resource) {
        return null;
    }
}

