/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.errorprone;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerArgumentsBuilder;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.internal.UncheckedException;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.util.GradleVersion;

public class ErrorProneCompiler
implements Compiler<JavaCompileSpec> {
    private static final Logger LOGGER = Logging.getLogger(ErrorProneCompiler.class);
    private static final WorkResult DID_WORK = GradleVersion.current().compareTo(GradleVersion.version((String)"4.2")) >= 0 ? WorkResults.didWork((boolean)true) : new SimpleWorkResult(true);
    private final Configuration errorprone;

    public ErrorProneCompiler(Configuration errorprone) {
        this.errorprone = errorprone;
    }

    public WorkResult execute(JavaCompileSpec spec) {
        int exitCode;
        LOGGER.info("Compiling with error-prone compiler");
        List args = new JavaCompilerArgumentsBuilder(spec).includeSourceFiles(true).build();
        URL[] urls = (URL[])this.errorprone.getFiles().stream().map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }).toArray(URL[]::new);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try (SelfFirstClassLoader cl = new SelfFirstClassLoader(urls);){
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> builderClass = ((ClassLoader)cl).loadClass("com.google.errorprone.ErrorProneCompiler$Builder");
            Object compilerBuilder = builderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Object compiler = builderClass.getMethod("build", new Class[0]).invoke(compilerBuilder, new Object[0]);
            Object result = compiler.getClass().getMethod("compile", String[].class).invoke(compiler, new Object[]{args.toArray(new String[args.size()])});
            exitCode = result.getClass().getField("exitCode").getInt(result);
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        if (exitCode != 0) {
            throw new CompilationFailedException(exitCode);
        }
        return DID_WORK;
    }

    private static class SelfFirstClassLoader
    extends URLClassLoader {
        private static final ClassLoader PLATFORM_CLASSLOADER;
        @Nullable
        private static final ClassLoader PARENT_CLASSLOADER;

        public SelfFirstClassLoader(URL[] urls) {
            super(urls, PARENT_CLASSLOADER);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.loadClass(name, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> cls = this.findLoadedClass(name);
                if (cls == null) {
                    try {
                        cls = this.findClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (cls == null) {
                        cls = PLATFORM_CLASSLOADER.loadClass(name);
                    }
                }
                if (resolve) {
                    this.resolveClass(cls);
                }
                return cls;
            }
        }

        @Override
        public URL getResource(String name) {
            URL resource = this.findResource(name);
            if (resource == null) {
                resource = PLATFORM_CLASSLOADER.getResource(name);
            }
            return resource;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            Enumeration<URL> selfResources = this.findResources(name);
            Enumeration<URL> bootstrapResources = PLATFORM_CLASSLOADER.getResources(name);
            if (!selfResources.hasMoreElements()) {
                return bootstrapResources;
            }
            if (!bootstrapResources.hasMoreElements()) {
                return selfResources;
            }
            ArrayList<URL> resources = Collections.list(selfResources);
            resources.addAll(Collections.list(bootstrapResources));
            return Collections.enumeration(resources);
        }

        static {
            ClassLoader parentClassloader;
            ClassLoader platformClassloader;
            try {
                parentClassloader = platformClassloader = (ClassLoader)ClassLoader.class.cast(ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                assert (!JavaVersion.current().isJava9Compatible());
                platformClassloader = new ClassLoader(null){};
                parentClassloader = null;
            }
            PLATFORM_CLASSLOADER = platformClassloader;
            PARENT_CLASSLOADER = parentClassloader;
        }
    }
}

