/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.errorprone;

import net.ltgt.gradle.errorprone.ErrorProneCompiler;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.NormalizingJavaCompiler;
import org.gradle.jvm.internal.toolchain.JavaToolChainInternal;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.platform.base.internal.toolchain.ToolProvider;
import org.gradle.util.TreeVisitor;

public class ErrorProneToolChain
implements JavaToolChainInternal {
    private final Configuration configuration;
    private final JavaVersion javaVersion = JavaVersion.current();

    public static ErrorProneToolChain create(Project project) {
        return new ErrorProneToolChain(project.getConfigurations().getByName("errorprone"));
    }

    public ErrorProneToolChain(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getName() {
        return String.format("ErrorProneJDK%s", this.javaVersion);
    }

    public String getVersion() {
        return this.javaVersion.getMajorVersion();
    }

    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    public String getDisplayName() {
        return String.format("Error-prone; JDK %s (%s)", this.javaVersion.getMajorVersion(), this.javaVersion);
    }

    public ToolProvider select(JavaPlatform targetPlatform) {
        if (targetPlatform != null && targetPlatform.getTargetCompatibility().compareTo((Enum)this.javaVersion) > 0) {
            return new UnavailableToolProvider(targetPlatform);
        }
        return new JavaToolProvider();
    }

    private class UnavailableToolProvider
    implements ToolProvider {
        private final JavaPlatform targetPlatform;

        private UnavailableToolProvider(JavaPlatform targetPlatform) {
            this.targetPlatform = targetPlatform;
        }

        public <T extends CompileSpec> Compiler<T> newCompiler(Class<T> spec) {
            throw new IllegalArgumentException(this.getMessage());
        }

        public <T> T get(Class<T> toolType) {
            throw new IllegalArgumentException(String.format("Don't know how to provide tool of type %s.", toolType.getSimpleName()));
        }

        public boolean isAvailable() {
            return false;
        }

        public void explain(TreeVisitor<? super String> visitor) {
            visitor.node((Object)this.getMessage());
        }

        private String getMessage() {
            return String.format("Could not target platform: '%s' using tool chain: '%s'.", this.targetPlatform.getDisplayName(), ErrorProneToolChain.this.getDisplayName());
        }
    }

    private class JavaToolProvider
    implements ToolProvider {
        private JavaToolProvider() {
        }

        public <T extends CompileSpec> Compiler<T> newCompiler(Class<T> spec) {
            if (JavaCompileSpec.class.isAssignableFrom(spec)) {
                return new NormalizingJavaCompiler((Compiler)new ErrorProneCompiler(ErrorProneToolChain.this.configuration));
            }
            throw new IllegalArgumentException(String.format("Don't know how to compile using spec of type %s.", spec.getSimpleName()));
        }

        public <T> T get(Class<T> toolType) {
            throw new IllegalArgumentException(String.format("Don't know how to provide tool of type %s.", toolType.getSimpleName()));
        }

        public boolean isAvailable() {
            return true;
        }

        public void explain(TreeVisitor<? super String> visitor) {
        }
    }
}

